/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.handler;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.inspect.InspectResult;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.HashMap;

public class InspectHandler
extends KernelHandler<Message> {
    public static final String STATUS = "status";
    public static final String METADATA = "metadata";
    public static final String FOUND = "found";
    public static final String CODE = "code";
    public static final String CURSOR_POS = "cursor_pos";
    public static final String DATA = "data";

    public InspectHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        String code = (String)((Object)message.getContent().get(CODE));
        int cursorPos = (Integer)message.getContent().get(CURSOR_POS);
        InspectResult inspectResult = this.kernel.inspect(code, cursorPos);
        Message reply = this.createMsg(message, inspectResult);
        this.send(reply);
    }

    private Message createMsg(Message message, InspectResult inspectResult) {
        Message reply = new Message(new Header(JupyterMessages.INSPECT_REPLY, message.getHeader().getSession()));
        reply.setIdentities(message.getIdentities());
        reply.setParentHeader(message.getHeader());
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        content.put(STATUS, (Serializable)((Object)"ok"));
        content.put(DATA, inspectResult.getData());
        content.put(FOUND, inspectResult.getFound());
        reply.setContent(content);
        return reply;
    }
}

