/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.fileloader;

import com.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class CSV {
    public static String TIME_COLUMN = "time";

    public List<Map<String, Object>> read(String fileName) throws IOException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        CSVIterator iterator = new CSVIterator(fileName);
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next == null) continue;
            result.add((Map<String, Object>)next);
        }
        return result;
    }

    public Iterable<Map<String, Object>> readIterable(String fileName) throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(fileName));
        return () -> new CSVIterator(reader);
    }

    private Object convertToNumber(Object value) {
        if (value instanceof String && NumberUtils.isCreatable((String)((String)value))) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (Exception exception) {
                try {
                    return new BigInteger((String)value);
                }
                catch (Exception exception2) {
                    return Double.parseDouble((String)value);
                }
            }
        }
        return value;
    }

    private Object convertDate(Object x) {
        if (x instanceof Number) {
            return x;
        }
        if (x instanceof Date) {
            Date date = (Date)x;
            return date;
        }
        if (x instanceof String) {
            return this.parseToDate((String)x);
        }
        throw new IllegalArgumentException("time column accepts numbers or java.util.Date objects or String date in a following format yyyy-MM-dd");
    }

    private Object parseToDate(String x) {
        Date inputDate = this.getDateWithTimezone(x);
        if (inputDate == null) {
            try {
                inputDate = new SimpleDateFormat("yyyy-MM-dd").parse(x);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("time column accepts String date in a following format yyyy-MM-dd");
            }
        }
        return inputDate;
    }

    private Date getDateWithTimezone(String x) {
        Date inputDate = null;
        try {
            inputDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z").parse(x);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return inputDate;
    }

    public class CSVIterator
    implements Iterator<Map<String, Object>>,
    AutoCloseable {
        private CSVReader reader;
        private String[] header;
        private Iterator<String[]> rows;

        public CSVIterator(String fileName) throws IOException {
            this(new CSVReader((Reader)new FileReader(fileName)));
        }

        CSVIterator(CSVReader csvReader) {
            this.reader = csvReader;
            this.rows = this.reader.iterator();
            this.header = this.rows.next();
        }

        @Override
        public boolean hasNext() {
            return this.rows.hasNext();
        }

        @Override
        public Map<String, Object> next() {
            if (!this.hasNext()) {
                return null;
            }
            String[] row = this.rows.next();
            if (this.rowIsEmpty(row, this.header)) {
                return null;
            }
            LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>();
            int index = 0;
            for (String hc : this.header) {
                if (hc.equals(TIME_COLUMN)) {
                    entry.put(hc, CSV.this.convertDate(row[index++]));
                    continue;
                }
                entry.put(hc, CSV.this.convertToNumber(row[index++]));
            }
            return entry;
        }

        private boolean rowIsEmpty(String[] row, String[] header) {
            return header.length > row.length && row.length == 1 && row[0].isEmpty();
        }

        @Override
        public void close() throws Exception {
            this.reader.close();
        }
    }
}

