/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.xychart;

import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.chart.xychart.TimePlot;
import com.twosigma.beakerx.chart.xychart.plotitem.Line;
import com.twosigma.beakerx.chart.xychart.plotitem.Points;
import com.twosigma.beakerx.chart.xychart.plotitem.XYGraphics;
import com.twosigma.beakerx.util.DateUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleTimePlot
extends TimePlot {
    private List<Map<String, Object>> data;
    private String timeColumn = "time";
    private List<String> columns;
    private List<String> displayNames;
    private List<Object> colors;
    private boolean displayLines = true;
    private boolean displayPoints = false;

    public SimpleTimePlot(List<Map<String, Object>> data, List<String> columns) {
        this(null, data, columns);
    }

    public SimpleTimePlot(Map<String, Object> parameters, List<Map<String, Object>> data, List<String> columns) {
        this.data = data;
        this.columns = columns;
        this.setUseToolTip(true);
        this.setShowLegend(true);
        this.setXLabel("Time");
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                String fieldName = entry.getKey();
                Object fieldValue = entry.getValue();
                ReflectionUtils.set(this, fieldName, fieldValue);
            }
        }
        if (this.displayNames == null || this.displayNames.size() == 0) {
            this.displayNames = columns;
        }
        this.reinitialize();
    }

    private List<Color> getChartColors() {
        ArrayList<Color> chartColors = new ArrayList<Color>();
        if (this.colors != null) {
            for (int i = 0; i < this.columns.size(); ++i) {
                if (i >= this.colors.size()) continue;
                chartColors.add(this.createChartColor(this.colors.get(i)));
            }
        }
        return chartColors;
    }

    private Color createChartColor(Object color) {
        if (color instanceof Color) {
            return (Color)color;
        }
        if (color instanceof java.awt.Color) {
            return new Color((java.awt.Color)color);
        }
        if (color instanceof List) {
            try {
                return new Color((Integer)((List)color).get(0), (Integer)((List)color).get(1), (Integer)((List)color).get(2));
            }
            catch (IndexOutOfBoundsException x) {
                throw new RuntimeException("Color list too short");
            }
        }
        String colorAsStr = (String)color;
        if (colorAsStr.indexOf("#") == 0) {
            return Color.decode(colorAsStr);
        }
        return this.colorFromName(colorAsStr);
    }

    private Color colorFromName(String color) {
        try {
            Field field = Class.forName("com.twosigma.beakerx.chart.Color").getField(color);
            return (Color)field.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException x) {
            throw new RuntimeException(String.format("Can not parse color '%s'", color), x);
        }
    }

    private void reinitialize() {
        List<XYGraphics> graphics = this.getGraphics();
        SimpleTimePlot.filter(graphics, new Predicate<XYGraphics>(){

            @Override
            public boolean test(XYGraphics graphic) {
                return !(graphic instanceof Line) && !(graphic instanceof Points);
            }
        });
        ArrayList<Object> xs = new ArrayList<Object>();
        ArrayList yss = new ArrayList();
        HashSet<String> dataColumnsNames = new HashSet<String>();
        if (this.data != null && this.columns != null) {
            int i;
            for (Map<String, Object> row : this.data) {
                dataColumnsNames.addAll(row.keySet());
                xs.add(this.getNumberForTimeColumn(row.get(this.timeColumn)));
                for (i = 0; i < this.columns.size(); ++i) {
                    String column = this.columns.get(i);
                    if (i >= yss.size()) {
                        yss.add(new ArrayList());
                    }
                    ((List)yss.get(i)).add(this.getNumberForTimeColumn(row.get(column)));
                }
            }
            HashSet<String> columnsWithoutData = this.getColumnsWithoutData(dataColumnsNames);
            if (!columnsWithoutData.isEmpty()) {
                throw new IllegalArgumentException(String.format("Chart data not found for columns: %s", columnsWithoutData));
            }
            List<Color> colors = this.getChartColors();
            for (i = 0; i < yss.size(); ++i) {
                List ys = (List)yss.get(i);
                if (this.displayLines) {
                    Line line = new Line();
                    line.setX(xs);
                    line.setY(ys);
                    if (this.displayNames != null && i < this.displayNames.size()) {
                        line.setDisplayName(this.displayNames.get(i));
                    } else {
                        line.setDisplayName(this.columns.get(i));
                    }
                    if (i < colors.size()) {
                        line.setColor(colors.get(i));
                    }
                    this.add(line);
                }
                if (!this.displayPoints) continue;
                Points points = new Points();
                points.setX(xs);
                points.setY(ys);
                if (this.displayNames != null && i < this.displayNames.size()) {
                    points.setDisplayName(this.displayNames.get(i));
                } else {
                    points.setDisplayName(this.columns.get(i));
                }
                if (i < colors.size()) {
                    points.setColor(colors.get(i));
                }
                this.add(points);
            }
        }
    }

    private Number getNumberForTimeColumn(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        return DateUtil.dateToLong(o);
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data = data;
        this.reinitialize();
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
        this.reinitialize();
    }

    public void setDisplayNames(List<String> displayNames) {
        this.displayNames = displayNames;
        if (displayNames != null) {
            List<XYGraphics> graphics = this.getGraphics();
            int i = 0;
            for (XYGraphics graphic : graphics) {
                if (!(graphic instanceof Line)) continue;
                graphic.setDisplayName(displayNames.get(++i));
            }
        }
    }

    public List<String> getDisplayNames() {
        return this.displayNames;
    }

    public void setColors(List<Object> colors) {
        this.colors = colors;
    }

    public List<Object> getColors() {
        return this.colors;
    }

    public String getTimeColumn() {
        return this.timeColumn;
    }

    public void setTimeColumn(String timeColumn) {
        this.timeColumn = timeColumn;
        this.reinitialize();
    }

    public boolean isDisplayLines() {
        return this.displayLines;
    }

    public void setDisplayLines(boolean displayLines) {
        this.displayLines = displayLines;
        this.reinitialize();
    }

    public boolean isDisplayPoints() {
        return this.displayPoints;
    }

    public void setDisplayPoints(boolean displayPoints) {
        this.displayPoints = displayPoints;
        this.reinitialize();
    }

    private HashSet<String> getColumnsWithoutData(Set<String> dataColumnsNames) {
        HashSet<String> columnsCopy = new HashSet<String>(this.columns);
        columnsCopy.removeAll(dataColumnsNames);
        return columnsCopy;
    }

    private static <T> void filter(Collection<T> collection, Predicate<T> predicate) {
        if (collection != null && predicate != null) {
            Iterator<T> itr = collection.iterator();
            while (itr.hasNext()) {
                T obj = itr.next();
                if (predicate.test(obj)) continue;
                itr.remove();
            }
        }
    }

    private static class ReflectionUtils {
        private static Map<String, Method> SETTERS_MAP = new HashMap<String, Method>();

        private ReflectionUtils() {
        }

        static boolean set(Object object, String fieldName, Object fieldValue) {
            Class<?> clazz = object.getClass();
            while (clazz != null) {
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(object, fieldValue);
                    return true;
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
                catch (Exception exception) {
                }
            }
            return ReflectionUtils.callSetter(object, fieldName, fieldValue);
        }

        private static boolean callSetter(Object obj, String fieldName, Object fieldValue) {
            String key = String.format("%s.%s(%s)", obj.getClass().getName(), fieldName, fieldValue.getClass().getName());
            Method m = null;
            if (!SETTERS_MAP.containsKey(key)) {
                m = ReflectionUtils.findMethod(obj, fieldName, fieldValue);
                SETTERS_MAP.put(key, m);
            } else {
                m = SETTERS_MAP.get(key);
            }
            if (m != null) {
                try {
                    m.invoke(obj, fieldValue);
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return false;
        }

        private static Method findMethod(Object obj, String fieldName, Object fieldValue) {
            Method m = null;
            Class<?> theClass = obj.getClass();
            String setter = String.format("set%C%s", Character.valueOf(fieldName.charAt(0)), fieldName.substring(1));
            for (Class<?> paramType = fieldValue.getClass(); paramType != null; paramType = paramType.getSuperclass()) {
                try {
                    m = theClass.getMethod(setter, paramType);
                    return m;
                }
                catch (NoSuchMethodException ex) {
                    for (Class<?> iface : paramType.getInterfaces()) {
                        try {
                            m = theClass.getMethod(setter, iface);
                            return m;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                    }
                    continue;
                }
            }
            return m;
        }
    }

    private static interface Predicate<T> {
        public boolean test(T var1);
    }
}

