/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart;

import com.twosigma.beakerx.chart.Chart;
import com.twosigma.beakerx.chart.ChartToJson;
import com.twosigma.beakerx.chart.xychart.plotitem.Crosshair;
import com.twosigma.beakerx.chart.xychart.plotitem.YAxis;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public abstract class AbstractChart
extends Chart {
    private String xLabel;
    protected final YAxis yAxis = new YAxis();
    private final List<YAxis> yAxes = new ArrayList<YAxis>();
    private double xLowerMargin = 0.05;
    private double xUpperMargin = 0.05;
    protected TimeZone timeZone;
    private Crosshair crosshair;
    private boolean omitCheckboxes = false;
    private boolean autoZoom = false;

    protected AbstractChart() {
        this.yAxes.add(this.yAxis);
    }

    public AbstractChart setXLabel(String xLabel) {
        this.xLabel = xLabel;
        this.sendModelUpdate(ChartToJson.serializeXLabel(this.xLabel));
        return this;
    }

    public AbstractChart setxLabel(String xLabel) {
        return this.setXLabel(xLabel);
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public String getxLabel() {
        return this.getXLabel();
    }

    public AbstractChart setYLabel(String yLabel) {
        this.yAxis.setLabel(yLabel);
        this.sendModelUpdate(ChartToJson.serializeYLabel(this.yAxis.getLabel()));
        return this;
    }

    public AbstractChart setyLabel(String yLabel) {
        this.setYLabel(yLabel);
        return this;
    }

    public String getYLabel() {
        return this.yAxis.getLabel();
    }

    public String getyLabel() {
        return this.getYLabel();
    }

    public AbstractChart add(YAxis yAxis) {
        this.yAxes.add(yAxis);
        this.sendModelUpdate(ChartToJson.serializeYAxes(this.yAxes));
        return this;
    }

    public AbstractChart leftShift(YAxis yAxis) {
        return this.add(yAxis);
    }

    public List<YAxis> getYAxes() {
        return this.yAxes;
    }

    public List<YAxis> getyAxes() {
        return this.getYAxes();
    }

    public AbstractChart add(List items) {
        for (Object o : items) {
            if (!(o instanceof YAxis)) continue;
            this.add((YAxis)o);
        }
        return this;
    }

    public AbstractChart leftShift(List items) {
        return this.add(items);
    }

    public AbstractChart setXLowerMargin(double margin) {
        this.xLowerMargin = margin;
        this.sendModelUpdate(ChartToJson.serializeXLowerMargin(this.xLowerMargin));
        return this;
    }

    public AbstractChart setxLowerMargin(double margin) {
        return this.setXLowerMargin(margin);
    }

    public double getXLowerMargin() {
        return this.xLowerMargin;
    }

    public double getxLowerMargin() {
        return this.getXLowerMargin();
    }

    public AbstractChart setXUpperMargin(double margin) {
        this.xUpperMargin = margin;
        this.sendModelUpdate(ChartToJson.serializeXUpperMargin(this.xUpperMargin));
        return this;
    }

    public AbstractChart setxUpperMargin(double margin) {
        return this.setXUpperMargin(margin);
    }

    public double getXUpperMargin() {
        return this.xUpperMargin;
    }

    public double getxUpperMargin() {
        return this.getXUpperMargin();
    }

    public AbstractChart setyAutoRange(boolean yAutoRange) {
        this.yAxis.setAutoRange(yAutoRange);
        this.sendModelUpdate(ChartToJson.serializeAutoRange(this.yAxis.getAutoRange()));
        return this;
    }

    public AbstractChart setYAutoRange(boolean yAutoRange) {
        return this.setyAutoRange(yAutoRange);
    }

    public Boolean getyAutoRange() {
        return this.yAxis.getAutoRange();
    }

    public Boolean getYAutoRange() {
        return this.getyAutoRange();
    }

    public AbstractChart setYAutoRangeIncludesZero(boolean yAutoRangeIncludesZero) {
        this.yAxis.setAutoRangeIncludesZero(yAutoRangeIncludesZero);
        this.sendModelUpdate(ChartToJson.serializeAutoRangeIncludesZero(this.yAxis.getAutoRangeIncludesZero()));
        return this;
    }

    public AbstractChart setyAutoRangeIncludesZero(boolean yAutoRangeIncludesZero) {
        return this.setYAutoRangeIncludesZero(yAutoRangeIncludesZero);
    }

    public Boolean getYAutoRangeIncludesZero() {
        return this.yAxis.getAutoRangeIncludesZero();
    }

    public Boolean getyAutoRangeIncludesZero() {
        return this.getYAutoRangeIncludesZero();
    }

    public AbstractChart setYLowerMargin(double margin) {
        return this.setyLowerMargin(margin);
    }

    public AbstractChart setyLowerMargin(double margin) {
        this.yAxis.setLowerMargin(margin);
        this.sendModelUpdate(ChartToJson.serializeYLowerMargin(this.yAxis.getLowerMargin()));
        return this;
    }

    public double getYLowerMargin() {
        return this.yAxis.getLowerMargin();
    }

    public double getyLowerMargin() {
        return this.getYLowerMargin();
    }

    public AbstractChart setYUpperMargin(double margin) {
        return this.setyUpperMargin(margin);
    }

    public AbstractChart setyUpperMargin(double margin) {
        this.yAxis.setUpperMargin(margin);
        this.sendModelUpdate(ChartToJson.serializeUpperMargin(this.yAxis.getUpperMargin()));
        return this;
    }

    public double getYUpperMargin() {
        return this.yAxis.getUpperMargin();
    }

    public double getyUpperMargin() {
        return this.getYUpperMargin();
    }

    public AbstractChart setYBound(double lower, double upper) {
        this.yAxis.setAutoRange(false);
        this.yAxis.setBound(lower, upper);
        this.sendModelUpdate(ChartToJson.serializeYBound(this.yAxis));
        return this;
    }

    public AbstractChart setYBound(List<Number> bound) {
        if (bound.size() != 2) {
            throw new IllegalArgumentException("to set the y bound, the list needs to be of size=2");
        }
        Number n0 = bound.get(0);
        Number n1 = bound.get(1);
        this.setYBound(n0.doubleValue(), n1.doubleValue());
        return this;
    }

    public AbstractChart setyBound(List<Number> bound) {
        return this.setYBound(bound);
    }

    public Double getYLowerBound() {
        return this.yAxis.getLowerBound();
    }

    public Double getyLowerBound() {
        return this.getYLowerBound();
    }

    public Double getYUpperBound() {
        return this.yAxis.getUpperBound();
    }

    public Double getyUpperBound() {
        return this.getYUpperBound();
    }

    public AbstractChart setLogY(boolean logY) {
        this.yAxis.setLog(logY);
        this.sendModelUpdate(ChartToJson.serializeLogY(this.yAxis.getLog()));
        return this;
    }

    public Boolean getLogY() {
        return this.yAxis.getLog();
    }

    public AbstractChart setYLogBase(double yLogBase) {
        this.yAxis.setLogBase(yLogBase);
        this.sendModel();
        return this;
    }

    public AbstractChart setyLogBase(double yLogBase) {
        return this.setYLogBase(yLogBase);
    }

    public Double getYLogBase() {
        return this.yAxis.getLogBase();
    }

    public Double getyLogBase() {
        return this.getYLogBase();
    }

    protected AbstractChart setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.sendModelUpdate(ChartToJson.serializeTimeZone(this.timeZone));
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public AbstractChart setCrosshair(Crosshair crosshair) {
        this.crosshair = crosshair;
        this.sendModelUpdate(ChartToJson.serializeCrosshair(this.crosshair));
        return this;
    }

    public Crosshair getCrosshair() {
        return this.crosshair;
    }

    public Boolean getOmitCheckboxes() {
        return this.omitCheckboxes;
    }

    public AbstractChart setOmitCheckboxes(boolean omitCheckboxes) {
        this.omitCheckboxes = omitCheckboxes;
        this.sendModelUpdate(ChartToJson.serializeOmitCheckboxes(this.omitCheckboxes));
        return this;
    }

    public Boolean getAutoZoom() {
        return this.autoZoom;
    }

    public AbstractChart setAutoZoom(boolean autoZoom) {
        this.autoZoom = autoZoom;
        this.sendModelUpdate(ChartToJson.serializeAutoZoom(this.autoZoom));
        return this;
    }
}

