/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteCandidate;
import com.twosigma.beakerx.autocomplete.AutocompleteRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassUtils {
    protected ClassLoader loader;
    private Map<String, String> typeMap;
    private Map<String, String> classToTypeMap;
    public static final int DO_STATIC = 0;
    public static final int DO_NON_STATIC = 1;
    public static final int DO_ALL = 2;
    private static final ModifierValidator classModifierValidator = (type, modifiers) -> Modifier.isStatic(modifiers) && type != 1;
    private static final ModifierValidator variableModifierValidator = (type, modifiers) -> classModifierValidator.validate(type, modifiers) || !Modifier.isStatic(modifiers) && type != 0;

    public ClassUtils(ClassLoader l) {
        this.loader = l;
        this.typeMap = new HashMap<String, String>();
        this.classToTypeMap = new HashMap<String, String>();
    }

    public ClassUtils() {
        this.loader = null;
        this.typeMap = new HashMap<String, String>();
        this.classToTypeMap = new HashMap<String, String>();
    }

    public void clear() {
        this.typeMap.clear();
        this.classToTypeMap.clear();
    }

    public void defineVariable(String name, String type) {
        this.typeMap.put(this.groovyVariableNameGenericParserProblems(name), type);
    }

    private String groovyVariableNameGenericParserProblems(String name) {
        if (name.contains(">")) {
            return name.substring(name.indexOf(">") + 1, name.length());
        }
        return name;
    }

    public String getVariableType(String name) {
        return this.typeMap.get(name);
    }

    public void defineClassShortName(String name, String fqname) {
        this.classToTypeMap.put(name, fqname);
    }

    protected Class<?> getClass(String name) throws ClassNotFoundException {
        try {
            if (this.loader != null) {
                return this.loader.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AutocompleteCandidate expandExpression(String txt, AutocompleteRegistry registry, int type) {
        if (!txt.contains(".")) {
            return null;
        }
        boolean endsWithDot = txt.endsWith(".");
        Pattern p = Pattern.compile("((?:[a-zA-Z$_][a-zA-Z0-9$_]*(?:\\(.*\\))?\\.\\s*)+)$");
        Matcher m = !endsWithDot ? p.matcher(txt.substring(0, txt.lastIndexOf(46) + 1)) : p.matcher(txt);
        if (m.find()) {
            try {
                AutocompleteCandidate c;
                ModifierValidator modifierValidator;
                String curtype;
                String[] v = m.group(0).split("\\.");
                String n = v[0].trim();
                if (this.typeMap.containsKey(n)) {
                    curtype = this.typeMap.get(n);
                    modifierValidator = variableModifierValidator;
                } else {
                    curtype = n;
                    modifierValidator = classModifierValidator;
                }
                if (this.classToTypeMap.containsKey(curtype)) {
                    curtype = this.classToTypeMap.get(curtype);
                }
                for (int i = 1; i < v.length; ++i) {
                    modifierValidator = variableModifierValidator;
                    String field = v[i];
                    String ntype = null;
                    Class<?> cl = this.getClass(curtype);
                    if (cl == null) {
                        return null;
                    }
                    if (field.contains("(")) {
                        field = field.substring(0, field.indexOf(40));
                        Method[] mtn = cl.getMethods();
                        for (int j = 0; j < mtn.length; ++j) {
                            int modifiers = mtn[j].getModifiers();
                            if (!mtn[j].getName().equals(field) || !Modifier.isPublic(modifiers) || !modifierValidator.validate(type, modifiers)) continue;
                            ntype = mtn[j].getReturnType().getCanonicalName();
                            break;
                        }
                    } else {
                        Field[] flds;
                        for (Field f : flds = cl.getFields()) {
                            int modifiers = f.getModifiers();
                            if (!f.getName().equals(field) || !Modifier.isPublic(modifiers) || !modifierValidator.validate(type, modifiers)) continue;
                            ntype = f.getType().getCanonicalName();
                            break;
                        }
                    }
                    if (ntype == null) {
                        return null;
                    }
                    curtype = ntype;
                }
                AutocompleteCandidate l = c = new AutocompleteCandidate(1, v, v.length);
                while (l.hasChildren()) {
                    l = l.getChildrens().get(0);
                }
                Class<?> cl = this.getClass(curtype);
                if (cl == null) {
                    return null;
                }
                Field[] fl = cl.getFields();
                Method[] mt = cl.getMethods();
                if (fl != null) {
                    for (Field f : fl) {
                        if (f.getName().contains("$") || !Modifier.isPublic(f.getModifiers()) || !modifierValidator.validate(type, f.getModifiers())) continue;
                        AutocompleteCandidate c2 = new AutocompleteCandidate(1, f.getName());
                        l.addChildren(c2);
                    }
                }
                if (mt != null) {
                    for (Method mm : mt) {
                        if (mm.getName().contains("$") || !Modifier.isPublic(mm.getModifiers()) || !modifierValidator.validate(type, mm.getModifiers())) continue;
                        AutocompleteCandidate c2 = new AutocompleteCandidate(1, mm.getName());
                        l.addChildren(c2);
                    }
                }
                registry.addCandidate(c);
                l = c = new AutocompleteCandidate(1, v);
                while (l.hasChildren()) {
                    l = l.getChildrens().get(0);
                }
                if (endsWithDot) {
                    l.addChildren(new AutocompleteCandidate(1, ""));
                } else {
                    l.addChildren(new AutocompleteCandidate(1, txt.substring(txt.lastIndexOf(46) + 1)));
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static interface ModifierValidator {
        public boolean validate(int var1, int var2);
    }
}

