/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonatype.guice.bean.locators.LocatedBeans;
import org.sonatype.guice.bean.locators.RankedList;
import org.sonatype.guice.bean.locators.spi.BindingDistributor;
import org.sonatype.guice.bean.locators.spi.BindingPublisher;
import org.sonatype.guice.bean.locators.spi.BindingSubscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RankedBindings<T>
implements Iterable<Binding<T>>,
BindingDistributor,
BindingSubscriber {
    final RankedList<Binding<T>> bindings = new RankedList();
    final List<Reference<LocatedBeans<?, T>>> locatedBeanRefs = new ArrayList();
    final RankedList<BindingPublisher> pendingPublishers;
    final TypeLiteral<T> type;

    RankedBindings(TypeLiteral<T> type, RankedList<BindingPublisher> publishers) {
        this.pendingPublishers = null != publishers ? publishers.clone() : new RankedList();
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(BindingPublisher publisher, int rank) {
        RankedList<BindingPublisher> rankedList = this.pendingPublishers;
        synchronized (rankedList) {
            this.pendingPublishers.insert(publisher, rank);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(BindingPublisher publisher) {
        RankedList<BindingPublisher> rankedList = this.pendingPublishers;
        synchronized (rankedList) {
            if (!this.pendingPublishers.remove(publisher)) {
                publisher.unsubscribe(this.type, this);
                RankedList<Binding<T>> rankedList2 = this.bindings;
                synchronized (rankedList2) {
                    boolean updated = false;
                    for (int i = 0; i < this.bindings.size(); ++i) {
                        if (!publisher.contains(this.bindings.get(i))) continue;
                        this.bindings.remove(i--);
                        updated = true;
                    }
                    if (updated) {
                        this.evictStaleBeanEntries();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Binding binding, int rank) {
        RankedList<Binding<T>> rankedList = this.bindings;
        synchronized (rankedList) {
            this.bindings.insert(binding, rank);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Binding binding) {
        RankedList<Binding<T>> rankedList = this.bindings;
        synchronized (rankedList) {
            int index = this.bindings.indexOfThis(binding);
            if (index >= 0) {
                this.bindings.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        RankedList<BindingPublisher> rankedList = this.pendingPublishers;
        synchronized (rankedList) {
            this.pendingPublishers.clear();
            RankedList<Binding<T>> rankedList2 = this.bindings;
            synchronized (rankedList2) {
                this.bindings.clear();
                this.evictStaleBeanEntries();
            }
        }
    }

    public Itr iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <Q extends Annotation> void linkToBeans(LocatedBeans<Q, T> beans) {
        List<Reference<LocatedBeans<?, T>>> list = this.locatedBeanRefs;
        synchronized (list) {
            WeakReference<LocatedBeans<Q, T>> beanRef = new WeakReference<LocatedBeans<Q, T>>(beans);
            int size = this.locatedBeanRefs.size();
            for (int i = 0; i < size; ++i) {
                if (null != this.locatedBeanRefs.get(i).get()) continue;
                this.locatedBeanRefs.set(i, beanRef);
                return;
            }
            this.locatedBeanRefs.add(beanRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActive() {
        boolean isActive = false;
        List<Reference<LocatedBeans<?, T>>> list = this.locatedBeanRefs;
        synchronized (list) {
            for (int i = 0; i < this.locatedBeanRefs.size(); ++i) {
                if (null != this.locatedBeanRefs.get(i).get()) {
                    isActive = true;
                    continue;
                }
                this.locatedBeanRefs.remove(i--);
            }
        }
        return isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictStaleBeanEntries() {
        List<Reference<LocatedBeans<?, T>>> list = this.locatedBeanRefs;
        synchronized (list) {
            int size = this.locatedBeanRefs.size();
            for (int i = 0; i < size; ++i) {
                LocatedBeans<?, T> beans = this.locatedBeanRefs.get(i).get();
                if (null == beans) continue;
                beans.retainAll(this.bindings);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Itr
    implements Iterator<Binding<T>> {
        private final RankedList.Itr itr;

        Itr() {
            this.itr = RankedBindings.this.bindings.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (RankedBindings.this.pendingPublishers.size() > 0) {
                RankedList<BindingPublisher> rankedList = RankedBindings.this.pendingPublishers;
                synchronized (rankedList) {
                    while (RankedBindings.this.pendingPublishers.size() > 0 && RankedBindings.this.pendingPublishers.getRank(0) > this.itr.peekNextRank()) {
                        RankedBindings.this.pendingPublishers.get(0).subscribe(RankedBindings.this.type, RankedBindings.this);
                        RankedBindings.this.pendingPublishers.remove(0);
                    }
                }
            }
            return this.itr.hasNext();
        }

        @Override
        public Binding<T> next() {
            return (Binding)this.itr.next();
        }

        public int rank() {
            return this.itr.rank();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

