/*
 * Decompiled with CFR 0.152.
 */
package org.abstractmeta.toolbox.compilation.compiler.registry.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.JavaFileObject;
import org.abstractmeta.toolbox.compilation.compiler.registry.JavaFileObjectRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFileObjectRegistryImpl
implements JavaFileObjectRegistry {
    private final Logger logger = LoggerFactory.getLogger((String)JavaFileObjectRegistryImpl.class.getName());
    private final Map<URI, JavaFileObject> javaFileObjects = new ConcurrentHashMap<URI, JavaFileObject>();

    @Override
    public void register(JavaFileObject fileObject) {
        this.javaFileObjects.put(fileObject.toUri(), fileObject);
    }

    @Override
    public boolean isRegistered(URI objectUri) {
        return this.javaFileObjects.containsKey(objectUri);
    }

    @Override
    public JavaFileObject get(URI objectUri) {
        return this.javaFileObjects.get(objectUri);
    }

    @Override
    public void unregister(URI objectUri) {
        this.javaFileObjects.remove(objectUri);
    }

    @Override
    public Collection<JavaFileObject> get(JavaFileObject.Kind kind) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        for (JavaFileObject candidate : this.javaFileObjects.values()) {
            if (candidate.getKind() != kind) continue;
            result.add(candidate);
        }
        return result;
    }
}

