/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.autocomplete;

import com.twosigma.beakerx.autocomplete.ClassUtils;
import com.twosigma.beakerx.javash.autocomplete.JavaClasspathScanner;
import com.twosigma.beakerx.jvm.classloader.BeakerXUrlClassLoader;
import java.util.List;
import java.util.Optional;

public class JavaClassUtils
extends ClassUtils {
    private JavaClasspathScanner classpathscanner;
    private BeakerXUrlClassLoader classLoader;

    public JavaClassUtils(JavaClasspathScanner cps, ClassLoader l) {
        super(l);
        this.classpathscanner = cps;
    }

    protected Class<?> getClass(String name) throws ClassNotFoundException {
        try {
            Class c = super.getClass(name);
            if (c != null) {
                return c;
            }
        }
        catch (Exception c) {
            // empty catch block
        }
        String fname = this.classpathscanner.getFileForClass(name);
        if (fname != null) {
            try {
                if (this.classLoader == null) {
                    this.classLoader = new BeakerXUrlClassLoader(this.loader != null ? this.loader : ((Object)((Object)this)).getClass().getClassLoader());
                }
                Class clazz = this.classLoader.parseClass(fname);
                return clazz;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Class<?> aClass = this.getClass(name, this.classpathscanner);
        return aClass;
    }

    private Class<?> getClass(String name, JavaClasspathScanner cps) {
        for (String pkg : cps.getPackages()) {
            Optional<String> clazz;
            List cls = cps.getClasses(pkg);
            if (cls == null || cls.isEmpty() || !(clazz = cls.stream().filter(x -> x.equals(name)).findFirst()).isPresent()) continue;
            try {
                return Class.forName(pkg + "." + clazz.get());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }
}

