/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.serializers;

import clojure.lang.IPersistentMap;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentVector;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import com.twosigma.beakerx.table.serializer.TableDisplayDeSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ClojureTableDeserializer
implements ObjectDeserializer {
    private final BeakerObjectConverter parent;

    public ClojureTableDeserializer(BeakerObjectConverter p) {
        this.parent = p;
        this.parent.addKnownBeakerType("TableDisplay");
    }

    public boolean canBeUsed(JsonNode n) {
        return n.has("type") && n.get("type").asText().equals("TableDisplay");
    }

    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        Pair deserializeObject = TableDisplayDeSerializer.getDeserializeObject((BeakerObjectConverter)this.parent, (JsonNode)n, (ObjectMapper)mapper);
        String subtype = (String)deserializeObject.getLeft();
        if (subtype != null && subtype.equals("Dictionary")) {
            return PersistentArrayMap.create((Map)((Map)deserializeObject.getRight()));
        }
        if (subtype != null && subtype.equals("ListOfMaps")) {
            List rows = (List)deserializeObject.getRight();
            ArrayList<IPersistentMap> oo = new ArrayList<IPersistentMap>();
            for (Map row : rows) {
                oo.add(PersistentArrayMap.create((Map)row));
            }
            return PersistentVector.create(oo);
        }
        if (subtype != null && subtype.equals("Matrix")) {
            List matrix = (List)deserializeObject.getRight();
            return PersistentVector.create((List)matrix);
        }
        return deserializeObject.getRight();
    }
}

