/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.kernel.BeakerXClasspath;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.scala.magic.command.EnableSparkSupportActionOptions;
import com.twosigma.beakerx.scala.magic.command.SparkInitCommandFactory;

class LoadLatestVersionOfSparkIfIsNotOnClasspath
implements SparkInitCommandFactory.Command {
    public static final String VERSION = "[2.3.1,)";
    private final Message message;
    private String error;
    private BeakerXClasspath classpath;
    private EnableSparkSupportActionOptions supportActionOptions;

    public LoadLatestVersionOfSparkIfIsNotOnClasspath(BeakerXClasspath classpath, EnableSparkSupportActionOptions supportActionOptions, Message message) {
        this.classpath = classpath;
        this.supportActionOptions = supportActionOptions;
        this.message = message;
        this.error = "";
    }

    @Override
    public MagicCommandOutcomeItem run() {
        MagicCommandOutcomeItem latestVersion;
        if (!this.classpath.isJarOnClasspath("spark-sql") && !(latestVersion = this.supportActionOptions.loadSpark(this.message, VERSION)).getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) {
            this.error = ((MIMEContainer)latestVersion.getMIMEContainer().get()).getData().toString();
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, this.error);
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }
}

