/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.kernel;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.BeakerXCommRepository;
import com.twosigma.beakerx.CommRepository;
import com.twosigma.beakerx.DefaultJVMVariables;
import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.kernel.BeakerXJson;
import com.twosigma.beakerx.kernel.BeakerXJsonConfig;
import com.twosigma.beakerx.kernel.CacheFolderFactory;
import com.twosigma.beakerx.kernel.CloseKernelAction;
import com.twosigma.beakerx.kernel.ConfigurationFile;
import com.twosigma.beakerx.kernel.CustomMagicCommandsFactory;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.Kernel;
import com.twosigma.beakerx.kernel.KernelConfigurationFile;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelRunner;
import com.twosigma.beakerx.kernel.KernelSocketsFactory;
import com.twosigma.beakerx.kernel.KernelSocketsFactoryImpl;
import com.twosigma.beakerx.kernel.Utils;
import com.twosigma.beakerx.kernel.handler.CommOpenHandler;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandConfiguration;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandConfigurationImpl;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.restserver.BeakerXServer;
import com.twosigma.beakerx.kernel.restserver.impl.GetUrlArgHandler;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.sql.evaluator.SQLEvaluator;
import com.twosigma.beakerx.sql.handlers.SQLCommOpenHandler;
import com.twosigma.beakerx.sql.handlers.SQLKernelInfoHandler;
import com.twosigma.beakerx.sql.kernel.SQLBeakerXServer;
import com.twosigma.beakerx.sql.magic.command.DataSourcesMagicCommand;
import com.twosigma.beakerx.sql.magic.command.DefaultDataSourcesMagicCommand;
import com.twosigma.beakerx.util.BeakerXSystem;
import com.twosigma.beakerx.util.BeakerXSystemImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SQL
extends Kernel {
    private static final Logger logger = Logger.getLogger(SQL.class.getName());
    public static final String BEAKERX_SQL_DEFAULT_JDBC = "BEAKERX_SQL_DEFAULT_JDBC";

    private SQL(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory, CommRepository commRepository, BeakerXServer beakerXServer, MagicCommandConfiguration magicCommandConfiguration, BeakerXJson beakerXJson) {
        super(sessionId, evaluator, kernelSocketsFactory, (CustomMagicCommandsFactory)new SQLCustomMagicCommandsImpl(), commRepository, beakerXServer, magicCommandConfiguration, beakerXJson);
    }

    public SQL(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory, CloseKernelAction closeKernelAction, CacheFolderFactory cacheFolderFactory, CommRepository commRepository, BeakerXServer beakerXServer, MagicCommandConfiguration magicCommandConfiguration, BeakerXJson beakerXJson) {
        super(sessionId, evaluator, kernelSocketsFactory, closeKernelAction, cacheFolderFactory, (CustomMagicCommandsFactory)new SQLCustomMagicCommandsImpl(), commRepository, beakerXServer, magicCommandConfiguration, beakerXJson);
    }

    public CommOpenHandler getCommOpenHandler(Kernel kernel) {
        return new SQLCommOpenHandler((KernelFunctionality)kernel);
    }

    public KernelHandler<Message> getKernelInfoHandler(Kernel kernel) {
        return new SQLKernelInfoHandler((KernelFunctionality)kernel);
    }

    public static void main(String[] args) {
        KernelRunner.run(() -> {
            String id = Utils.uuid();
            BeakerXCommRepository commRepository = new BeakerXCommRepository();
            KernelConfigurationFile configurationFile = new KernelConfigurationFile(args);
            KernelSocketsFactoryImpl kernelSocketsFactory = new KernelSocketsFactoryImpl((ConfigurationFile)configurationFile);
            EvaluatorParameters params = SQL.getKernelParameters(BeakerXSystemImpl.getINSTANCE());
            NamespaceClient beakerxClient = NamespaceClient.create((String)id, (ConfigurationFile)configurationFile, (CommRepository)commRepository);
            MagicCommandConfigurationImpl magicConfiguration = new MagicCommandConfigurationImpl();
            SQLEvaluator evaluator = new SQLEvaluator(id, id, params, (BeakerXClient)beakerxClient, magicConfiguration.patterns());
            return new SQL(id, (Evaluator)evaluator, (KernelSocketsFactory)kernelSocketsFactory, (CommRepository)commRepository, (BeakerXServer)new SQLBeakerXServer(new GetUrlArgHandler((BeakerXClient)beakerxClient)), (MagicCommandConfiguration)magicConfiguration, (BeakerXJson)new BeakerXJsonConfig());
        });
    }

    static EvaluatorParameters getKernelParameters(BeakerXSystem beakerXSystem) {
        Map<String, Object> kernelParameters = new HashMap<String, Object>();
        kernelParameters.put("imports", new DefaultJVMVariables().getImports());
        kernelParameters = SQL.getDefaultConnectionString(beakerXSystem, kernelParameters);
        return new EvaluatorParameters(kernelParameters);
    }

    private static Map<String, Object> getDefaultConnectionString(BeakerXSystem beakerXSystem, Map<String, Object> kernelParameters) {
        String uri = beakerXSystem.getenv(BEAKERX_SQL_DEFAULT_JDBC);
        if (uri != null && uri.contains("jdbc:")) {
            logger.info("Setting default connection string to " + uri);
            kernelParameters.put("%defaultDatasource", uri);
        } else if (uri != null) {
            logger.warning("Ignoring incorrectly formatted BEAKERX_SQL_DEFAULT_JDBC: " + uri);
        }
        return kernelParameters;
    }

    static class SQLCustomMagicCommandsImpl
    implements CustomMagicCommandsFactory {
        SQLCustomMagicCommandsImpl() {
        }

        public List<MagicCommandType> customMagicCommands(KernelFunctionality kernel) {
            return Arrays.asList(new MagicCommandType("%datasources", "<jdbc:[dbEngine]:[subsubprotocol:][databaseName]>", (MagicCommandFunctionality)new DataSourcesMagicCommand(kernel)), new MagicCommandType("%defaultDatasource", "<sourceName=jdbc:[dbEngine]:[subsubprotocol:][databaseName]>", (MagicCommandFunctionality)new DefaultDataSourcesMagicCommand(kernel)));
        }
    }
}

