/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.AutocompleteServiceBeakerx;
import com.twosigma.beakerx.autocomplete.ClasspathScanner;
import com.twosigma.beakerx.autocomplete.MagicCommandAutocompletePatterns;
import com.twosigma.beakerx.sql.ConnectionStringHolder;
import com.twosigma.beakerx.sql.JDBCClient;
import com.twosigma.beakerx.sql.autocomplete.KeyWithIndex;
import com.twosigma.beakerx.sql.autocomplete.db.DbCache;
import com.twosigma.beakerx.sql.autocomplete.db.DbExplorerFactory;
import com.twosigma.beakerx.sql.autocomplete.db.DbInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SQLAutocomplete
extends AutocompleteServiceBeakerx {
    private static final String[] SQL_KEYS = new String[]{"ABORT", "ACTION", "ADD", "AFTER", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ATTACH", "AUTOINCREMENT", "BEFORE", "BEGIN", "BETWEEN", "BY", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONFLICT", "CONSTRAINT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DROP", "EACH", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXISTS", "EXPLAIN", "FAIL", "FOR", "FOREIGN", "FROM", "FULL", "GLOB", "GROUP", "HAVING", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "KEY", "LEFT", "LIKE", "LIMIT", "MATCH", "NATURAL", "NO", "NOT", "NOTNULL", "NULL", "OF", "OFFSET", "ON", "OR", "ORDER", "OUTER", "PLAN", "PRAGMA", "PRIMARY", "QUERY", "RAISE", "RECURSIVE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "RIGHT", "ROLLBACK", "ROW", "SAVEPOINT", "SELECT", "SET", "TABLE", "TEMP", "TEMPORARY", "THEN", "TO", "TRANSACTION", "TRIGGER", "UNION", "UNIQUE", "UPDATE", "USING", "VACUUM", "VALUES", "VIEW", "VIRTUAL", "WHEN", "WHERE", "WITH", "WITHOUT"};
    private static final String PARAM_CHAR = "%";
    private static final String[] PARAM_KEYS = new String[]{"%%beakerDB", "%%inputs"};
    private final JDBCClient jdbcClient;
    private final String sessionId;
    private ConnectionStringHolder defaultConnectionString;
    private final Map<String, ConnectionStringHolder> namedConnectionString;
    private final DbCache cache;

    public SQLAutocomplete(ClasspathScanner _cps, JDBCClient jdbcClient, String sessionId, ConnectionStringHolder defaultConnectionString, Map<String, ConnectionStringHolder> namedConnectionString, MagicCommandAutocompletePatterns autocompletePatterns) {
        super(autocompletePatterns);
        this.jdbcClient = jdbcClient;
        this.sessionId = sessionId;
        this.defaultConnectionString = defaultConnectionString;
        this.namedConnectionString = namedConnectionString;
        this.cache = DbExplorerFactory.getDbCache();
    }

    protected AutocompleteResult doAutocomplete(String txt, int cur) {
        List<String> matches = this.findMatches(txt, cur);
        KeyWithIndex key = this.findKey(txt, cur);
        return new AutocompleteResult(matches, key.getIndex());
    }

    private List<String> findKeys(String key, String[] keys) {
        ArrayList<String> ret = new ArrayList<String>();
        if (key == null || key.trim().length() == 0) {
            ret.addAll(Arrays.asList(keys));
        } else {
            String lowerTxt = key.toLowerCase(Locale.ROOT);
            for (String str : Arrays.asList(keys)) {
                if (!str.toLowerCase(Locale.ROOT).startsWith(lowerTxt)) continue;
                ret.add(str);
            }
        }
        return ret;
    }

    private List<String> findSqlKeys(String key) {
        return this.findKeys(key, SQL_KEYS);
    }

    private List<String> findParamKeys(String key) {
        return this.findKeys(key, PARAM_KEYS);
    }

    private KeyWithIndex findKey(String txt, int cur) {
        int eos;
        if (cur <= 0 || Character.isWhitespace(txt.charAt(cur - 1))) {
            return new KeyWithIndex("", txt.length());
        }
        String res = "";
        for (int i = eos = cur - 1; i >= 0; --i) {
            boolean isIdentifier;
            boolean bl = isIdentifier = Character.isUnicodeIdentifierPart(txt.charAt(i)) || PARAM_CHAR.charAt(0) == txt.charAt(i);
            if (isIdentifier) {
                eos = i;
            }
            if (isIdentifier && i != 0) continue;
            res = new String(txt.substring(eos, cur));
            break;
        }
        return new KeyWithIndex(res, eos);
    }

    private List<String> findMatches(String txt, int cur) {
        LinkedList<String> ret = new LinkedList<String>();
        if (cur == 0) {
            return this.findParamKeys(null);
        }
        String key = this.findKey(txt, cur).getKey();
        if (key != null && key.length() > 0 && key.startsWith(PARAM_CHAR)) {
            return this.findParamKeys(key);
        }
        ret.addAll(this.findSqlKeys(key));
        DbInfo dbInfo = DbExplorerFactory.getDbInfo(txt, this.jdbcClient, this.sessionId, this.defaultConnectionString, this.namedConnectionString);
        if (dbInfo != null) {
            List<String> dbRet = null;
            if (cur > key.length() + 1 && (txt.charAt(cur - key.length() - 1) == '.' || ".".equals(key))) {
                String tableName;
                String fieldKey = key;
                int searchTableIndex = cur - key.length() - 1;
                if (".".equals(key)) {
                    fieldKey = "";
                    searchTableIndex = cur - 1;
                }
                if ((tableName = this.findKey(txt, searchTableIndex).getKey()) != null) {
                    return dbInfo.getTableFieldNames(this.cache, null, tableName, fieldKey);
                }
            } else {
                dbRet = dbInfo.getTableNames(this.cache, null, key);
            }
            if (dbRet != null) {
                ret.addAll(0, dbRet);
            }
        }
        return ret;
    }
}

