/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroovyStackTracePrettyPrinter {
    public static final String ORG_CODEHAUS_GROOVY_CONTROL_MULTIPLE_COMPILATION_ERRORS_EXCEPTION_STARTUP_FAILED = "org.codehaus.groovy.control.MultipleCompilationErrorsException: startup failed:";

    public static String printStacktrace(String scriptName, String stacktrace) {
        Optional<String> value = GroovyStackTracePrettyPrinter.scriptRunScript(scriptName, stacktrace);
        if (value.isPresent()) {
            return value.get();
        }
        value = GroovyStackTracePrettyPrinter.multipleCompilationErrorsExceptionWithScript(scriptName, stacktrace);
        if (value.isPresent()) {
            return value.get();
        }
        return stacktrace;
    }

    private static Optional<String> multipleCompilationErrorsExceptionWithScript(String scriptName, String stacktrace) {
        String pattern;
        Pattern r;
        Matcher m;
        String result = stacktrace;
        if (result.startsWith(ORG_CODEHAUS_GROOVY_CONTROL_MULTIPLE_COMPILATION_ERRORS_EXCEPTION_STARTUP_FAILED) && (m = (r = Pattern.compile(pattern = String.format("(%s:\\s*)(\\d+)(:)(.*)(%s*)", scriptName, System.lineSeparator()))).matcher(stacktrace)).find()) {
            result = result.replace(ORG_CODEHAUS_GROOVY_CONTROL_MULTIPLE_COMPILATION_ERRORS_EXCEPTION_STARTUP_FAILED, "");
            String replace = result.replace(m.group(0), m.group(4));
            return Optional.of(replace.trim());
        }
        return Optional.empty();
    }

    private static Optional<String> scriptRunScript(String scriptName, String stacktrace) {
        String pattern = String.format("(%s.run\\(%s:\\s*)(\\d+)(\\))", scriptName, scriptName);
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(stacktrace);
        if (m.find()) {
            String replace = stacktrace.replace(m.group(0), "this cell line " + m.group(2));
            return Optional.of(replace);
        }
        return Optional.empty();
    }
}

