/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.autocomplete;

import com.twosigma.beakerx.autocomplete.ClassUtils;
import com.twosigma.beakerx.groovy.autocomplete.GroovyClasspathScanner;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.util.List;
import java.util.Optional;

public class GroovyClassUtils
extends ClassUtils {
    private GroovyClasspathScanner classpathscanner;
    private GroovyClassLoader gloader;

    public GroovyClassUtils(GroovyClasspathScanner cps, ClassLoader l) {
        super(l);
        this.classpathscanner = cps;
    }

    protected Class<?> getClass(String name) throws ClassNotFoundException {
        try {
            Class c = super.getClass(name);
            if (c != null) {
                return c;
            }
        }
        catch (Exception c) {
            // empty catch block
        }
        String fname = this.classpathscanner.getFileForClass(name);
        if (fname != null) {
            try {
                if (this.gloader == null) {
                    this.gloader = new GroovyClassLoader(this.loader != null ? this.loader : ((Object)((Object)this)).getClass().getClassLoader());
                }
                Class groovyClass = this.gloader.parseClass(new File(fname));
                return groovyClass;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Class<?> aClass = this.getClass(name, this.classpathscanner);
        return aClass;
    }

    public Class<?> getClass(String name, GroovyClasspathScanner cps) {
        for (String pkg : cps.getPackages()) {
            Optional<String> clazz;
            List cls = cps.getClasses(pkg);
            if (cls == null || cls.isEmpty() || !(clazz = cls.stream().filter(x -> x.equals(name)).findFirst()).isPresent()) continue;
            try {
                return Class.forName(pkg + "." + clazz.get());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }
}

