/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.FQ;
import zmq.IOThread;
import zmq.LB;
import zmq.Msg;
import zmq.Options;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;

public class Dealer
extends SocketBase {
    private final FQ fq;
    private final LB lb;
    private boolean prefetched = false;
    private Msg prefetchedMsg;

    public Dealer(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 5;
        this.fq = new FQ();
        this.lb = new LB();
        this.options.recvIdentity = true;
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean icanhasall) {
        assert (pipe != null);
        this.fq.attach(pipe);
        this.lb.attach(pipe);
    }

    @Override
    protected boolean xsend(Msg msg) {
        return this.lb.send(msg, this.errno);
    }

    @Override
    protected Msg xrecv() {
        return this.xxrecv();
    }

    private Msg xxrecv() {
        Msg msg = null;
        if (this.prefetched) {
            msg = this.prefetchedMsg;
            this.prefetched = false;
            this.prefetchedMsg = null;
            return msg;
        }
        do {
            if ((msg = this.fq.recv(this.errno)) != null) continue;
            return null;
        } while ((msg.flags() & 0x40) != 0);
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        if (this.prefetched) {
            return true;
        }
        this.prefetchedMsg = this.xxrecv();
        if (this.prefetchedMsg == null) {
            return false;
        }
        this.prefetched = true;
        return true;
    }

    @Override
    protected boolean xhasOut() {
        return this.lb.hasOut();
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        this.fq.activated(pipe);
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        this.lb.activated(pipe);
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        this.fq.terminated(pipe);
        this.lb.terminated(pipe);
    }

    public static class DealerSession
    extends SessionBase {
        public DealerSession(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            super(ioThread, connect, socket, options, addr);
        }
    }
}

