/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.NameReplacingVisitor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0005\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "fillCoroutineMetadata", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl$WithDestructuringDeclaration;", "js.translator"})
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        PsiElement finalElement = UtilsKt.getFinalElement(declaration);
        TranslationContext invokingContext = this.context();
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration);
        JsFunction lambda2 = invokingContext.getFunctionObject(descriptor2);
        TranslationContext translationContext = invokingContext.newFunctionBodyWithUsageTracker(lambda2, descriptor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"invokingContext\n        \u2026acker(lambda, descriptor)");
        FunctionDescriptor functionDescriptor = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"descriptor");
        JsFunction jsFunction = lambda2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsFunction, (String)"lambda");
        List<JsParameter> list2 = jsFunction.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"lambda.parameters");
        TranslationContext functionContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext, functionDescriptor, list2);
        List<ValueParameterDescriptor> list3 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"descriptor.valueParameters");
        Iterable $receiver$iv = list3;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            if (!(it instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration)) continue;
            JsBlock jsBlock = lambda2.getBody();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"lambda.body");
            jsBlock.getStatements().add(this.translate((ValueParameterDescriptorImpl.WithDestructuringDeclaration)it, functionContext));
        }
        JsBlock jsBlock = lambda2.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"lambda.body");
        $receiver$iv = jsBlock.getStatements();
        List<JsStatement> list4 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, functionContext);
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"setDefaultValueForArgume\u2026criptor, functionContext)");
        Object object = list4;
        CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object);
        JsBlock jsBlock2 = lambda2.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock2, (String)"lambda.body");
        $receiver$iv = jsBlock2.getStatements();
        object = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, functionContext);
        $receiver$iv.add(object);
        MetadataProperties.setFunctionDescriptor(lambda2, descriptor2);
        lambda2.setSource(finalElement);
        UsageTracker usageTracker = functionContext.usageTracker();
        if (usageTracker == null) {
            Intrinsics.throwNpe();
        }
        UsageTracker tracker = usageTracker;
        JsName name = invokingContext.getInnerNameForDescriptor(descriptor2);
        UsageTracker usageTracker2 = tracker;
        Intrinsics.checkExpressionValueIsNotNull((Object)usageTracker2, (String)"tracker");
        if (UsageTrackerKt.hasCapturedExceptContaining(usageTracker2)) {
            JsFunction lambdaCreator;
            JsFunction jsFunction2 = lambdaCreator = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda2.source(declaration));
            Intrinsics.checkExpressionValueIsNotNull((Object)jsFunction2, (String)"lambdaCreator");
            MetadataProperties.setLocal(jsFunction2, true);
            if (tracker.getCapturedDescriptors().contains(descriptor2) && !DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
                lambda2.setName(UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor2));
            }
            JsName jsName = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"name");
            MetadataProperties.setStaticRef(jsName, lambdaCreator);
            TranslationContext translationContext2 = invokingContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)translationContext2, (String)"invokingContext");
            this.fillCoroutineMetadata(lambdaCreator, translationContext2, descriptor2);
            lambdaCreator.setSource(declaration);
            return LiteralFunctionTranslatorKt.withCapturedParameters(lambdaCreator, functionContext, name, invokingContext, declaration);
        }
        if (tracker.getCapturedDescriptors().contains(descriptor2)) {
            JsName jsName = UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor2);
            if (jsName == null) {
                Intrinsics.throwNpe();
            }
            JsName capturedName = jsName;
            JsName globalName = invokingContext.getInnerNameForDescriptor(descriptor2);
            NameReplacingVisitor replacingVisitor = new NameReplacingVisitor(MapsKt.mapOf((Pair)TuplesKt.to((Object)capturedName, (Object)JsAstUtils.pureFqn(globalName, null))));
            replacingVisitor.accept((JsNode)lambda2);
        }
        MetadataProperties.setLocal(lambda2, true);
        TranslationContext translationContext3 = invokingContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext3, (String)"invokingContext");
        JsName jsName = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"name");
        LiteralFunctionTranslatorKt.access$addFunctionDeclaration(translationContext3, jsName, lambda2, declaration);
        this.fillCoroutineMetadata(lambda2, invokingContext, descriptor2);
        MetadataProperties.setStaticRef(name, lambda2);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(name, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"JsAstUtils.pureFqn(name, null)");
        return jsNameRef;
    }

    public final void fillCoroutineMetadata(@NotNull JsFunction $receiver, @NotNull TranslationContext context, @NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (!descriptor2.isSuspend()) {
            return;
        }
        UtilsKt.fillCoroutineMetadata($receiver, context, descriptor2, descriptor2.getExtensionReceiverParameter() != null);
        MetadataProperties.setForceStateMachine($receiver, true);
    }

    @NotNull
    public final JsVars translate(@NotNull ValueParameterDescriptorImpl.WithDestructuringDeclaration $receiver, @NotNull TranslationContext context) {
        ASTDelegatePsiElement aSTDelegatePsiElement;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration($receiver);
        if (!(psiElement instanceof KtParameter)) {
            psiElement = null;
        }
        if ((aSTDelegatePsiElement = (KtParameter)psiElement) == null || (aSTDelegatePsiElement = aSTDelegatePsiElement.getDestructuringDeclaration()) == null) {
            String string = "Destructuring declaration for descriptor " + $receiver + " not found";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ASTDelegatePsiElement destructuringDeclaration = aSTDelegatePsiElement;
        JsExpression parameterRef = ReferenceTranslator.translateAsValueReference($receiver, context);
        JsVars jsVars = DestructuringDeclarationTranslator.translate((KtDestructuringDeclaration)destructuringDeclaration, parameterRef, context);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsVars, (String)"DestructuringDeclaration\u2026n, parameterRef, context)");
        return jsVars;
    }

    public LiteralFunctionTranslator(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }
}

