/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableAccessInfo;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0012\u0010\u0016\u001a\u00020\u0006*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0006\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0010\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0010\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u000b\u001a\n\u0010\u001d\u001a\u00020\u001c*\u00020\u0010\u001a\n\u0010\u001e\u001a\u00020\u001c*\u00020\u0002\u001a\n\u0010\u001f\u001a\u00020\u001c*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\n*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "getCallableDescriptor", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "calleeOwner", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getCalleeOwner", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "functionName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "getFunctionName", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;", "getVariableDescriptor", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;)Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variableName", "getVariableName", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "constructAccessExpression", "ref", "getAccessDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "getAccessDescriptorIfNeeded", "hasSpreadOperator", "", "isGetAccess", "isNative", "isSuperInvocation", "js.translator"})
public final class CallInfoExtensionsKt {
    @NotNull
    public static final CallableDescriptor getCallableDescriptor(@NotNull CallInfo $receiver) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CallableDescriptor result2 = $receiver.getResolvedCall().getResultingDescriptor().getOriginal();
        if (result2 instanceof TypeAliasConstructorDescriptor) {
            callableDescriptor = ((TypeAliasConstructorDescriptor)result2).getUnderlyingConstructorDescriptor();
        } else {
            CallableDescriptor callableDescriptor2 = result2;
            callableDescriptor = callableDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor2, (String)"result");
        }
        return callableDescriptor;
    }

    public static final boolean isNative(@NotNull CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return AnnotationsUtils.isNativeObject(CallInfoExtensionsKt.getCallableDescriptor($receiver));
    }

    public static final boolean isSuperInvocation(@NotNull CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ReceiverValue dispatchReceiver = $receiver.getResolvedCall().getDispatchReceiver();
        return dispatchReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)dispatchReceiver).getExpression() instanceof KtSuperExpression;
    }

    @NotNull
    public static final JsExpression getCalleeOwner(@NotNull CallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor calleeOwner = $receiver.getResolvedCall().getResultingDescriptor().getContainingDeclaration();
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(calleeOwner, $receiver.getContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"ReferenceTranslator.tran\u2026nce(calleeOwner, context)");
        return jsExpression;
    }

    @NotNull
    public static final VariableDescriptor getVariableDescriptor(@NotNull VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CallableDescriptor callableDescriptor = CallInfoExtensionsKt.getCallableDescriptor($receiver);
        if (callableDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
        }
        return (VariableDescriptor)callableDescriptor;
    }

    @NotNull
    public static final JsName getVariableName(@NotNull VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        JsName jsName = $receiver.getContext().getNameForDescriptor(CallInfoExtensionsKt.getVariableDescriptor($receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"context.getNameForDescriptor(variableDescriptor)");
        return jsName;
    }

    public static final boolean isGetAccess(@NotNull VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getValue() == null;
    }

    @NotNull
    public static final PropertyAccessorDescriptor getAccessDescriptor(@NotNull VariableAccessInfo $receiver) {
        PropertyAccessorDescriptor propertyAccessorDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        VariableDescriptor variableDescriptor = CallInfoExtensionsKt.getVariableDescriptor($receiver);
        if (variableDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
        }
        PropertyDescriptor property = (PropertyDescriptor)variableDescriptor;
        if (CallInfoExtensionsKt.isGetAccess($receiver)) {
            PropertyGetterDescriptor propertyGetterDescriptor = property.getGetter();
            if (propertyGetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor, (String)"property.getter!!");
            propertyAccessorDescriptor = propertyGetterDescriptor;
        } else {
            PropertySetterDescriptor propertySetterDescriptor = property.getSetter();
            if (propertySetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor, (String)"property.setter!!");
            propertyAccessorDescriptor = propertySetterDescriptor;
        }
        return propertyAccessorDescriptor;
    }

    @NotNull
    public static final CallableDescriptor getAccessDescriptorIfNeeded(@NotNull VariableAccessInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return CallInfoExtensionsKt.getVariableDescriptor($receiver) instanceof PropertyDescriptor && (DescriptorUtilsKt.isExtension(CallInfoExtensionsKt.getVariableDescriptor($receiver)) || TranslationUtils.shouldAccessViaFunctions(CallInfoExtensionsKt.getVariableDescriptor($receiver))) ? (CallableDescriptor)CallInfoExtensionsKt.getAccessDescriptor($receiver) : (CallableDescriptor)CallInfoExtensionsKt.getVariableDescriptor($receiver);
    }

    @NotNull
    public static final JsExpression constructAccessExpression(@NotNull VariableAccessInfo $receiver, @NotNull JsExpression ref) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        if (CallInfoExtensionsKt.isGetAccess($receiver)) {
            jsExpression = ref;
        } else {
            MetadataProperties.setSideEffects(ref, SideEffectKind.PURE);
            JsExpression jsExpression2 = $receiver.getValue();
            if (jsExpression2 == null) {
                Intrinsics.throwNpe();
            }
            JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(ref, jsExpression2);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperation, (String)"JsAstUtils.assignment(ref, value!!)");
            jsExpression = jsBinaryOperation;
        }
        return jsExpression;
    }

    @NotNull
    public static final JsName getFunctionName(@NotNull FunctionCallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        JsName jsName = $receiver.getContext().getNameForDescriptor(CallInfoExtensionsKt.getCallableDescriptor($receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"context.getNameForDescriptor(callableDescriptor)");
        return jsName;
    }

    public static final boolean hasSpreadOperator(@NotNull FunctionCallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getArgumentsInfo().getHasSpreadOperator();
    }
}

