/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.text;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.text.ASTDiffBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.text.BlockSupportImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.util.diff.DiffTreeChangeBuilder;

public class DiffLog
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final List<LogEntry> myEntries = new ArrayList<LogEntry>();

    @NotNull
    public TreeChangeEventImpl performActualPsiChange(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "performActualPsiChange"));
        }
        ASTDiffBuilder astDiffBuilder = new ASTDiffBuilder((PsiFileImpl)file2);
        for (LogEntry entry : this.myEntries) {
            entry.doActualPsiChange(file2, astDiffBuilder);
        }
        file2.subtreeChanged();
        TreeChangeEventImpl treeChangeEventImpl = astDiffBuilder.getEvent();
        if (treeChangeEventImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "performActualPsiChange"));
        }
        return treeChangeEventImpl;
    }

    @Override
    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "nodeReplaced"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "nodeReplaced"));
        }
        if (oldNode instanceof FileElement && newNode instanceof FileElement) {
            this.appendReplaceFileElement((FileElement)oldNode, (FileElement)newNode);
        } else {
            this.myEntries.add(new ReplaceEntry(oldNode, newNode));
        }
    }

    void appendReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "appendReplaceElementWithEvents"));
        }
        if (newRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "appendReplaceElementWithEvents"));
        }
        this.myEntries.add(new ReplaceElementWithEvents(oldRoot, newRoot));
    }

    void appendReplaceFileElement(@NotNull FileElement oldNode, @NotNull FileElement newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "appendReplaceFileElement"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "appendReplaceFileElement"));
        }
        this.myEntries.add(new ReplaceFileElement(oldNode, newNode));
    }

    @Override
    public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
        if (oldParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "nodeDeleted"));
        }
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "nodeDeleted"));
        }
        this.myEntries.add(new DeleteEntry(oldParent, oldNode));
    }

    @Override
    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        if (oldParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "nodeInserted"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog", "nodeInserted"));
        }
        this.myEntries.add(new InsertEntry(oldParent, newNode, pos));
    }

    private static PsiElement getPsi(ASTNode node, PsiFile file2) {
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, ((PsiFileImpl)file2).getTreeElement());
        PsiElement psiChild = file2.isPhysical() ? node.getPsi() : null;
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, null);
        return psiChild;
    }

    private static class ReplaceElementWithEvents
    extends LogEntry {
        @NotNull
        private final CompositeElement myOldRoot;
        @NotNull
        private final CompositeElement myNewRoot;

        private ReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
            if (oldRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents", "<init>"));
            }
            if (newRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents", "<init>"));
            }
            this.myOldRoot = oldRoot;
            this.myNewRoot = newRoot;
            TreeUtil.ensureParsed(this.myOldRoot.getFirstChildNode());
            TreeUtil.ensureParsed(this.myNewRoot.getFirstChildNode());
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents", "doActualPsiChange"));
            }
            this.myOldRoot.replaceAllChildrenToChildrenOf(this.myNewRoot);
        }
    }

    private static class ReplaceFileElement
    extends LogEntry {
        @NotNull
        private final FileElement myOldNode;
        @NotNull
        private final FileElement myNewNode;

        private ReplaceFileElement(@NotNull FileElement oldNode, @NotNull FileElement newNode) {
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement", "<init>"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement", "<init>"));
            }
            this.myOldNode = oldNode;
            this.myNewNode = newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            TreeElement firstChildNode;
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement", "doActualPsiChange"));
            }
            PsiFileImpl fileImpl = (PsiFileImpl)file2;
            int oldLength = this.myOldNode.getTextLength();
            PsiManagerImpl manager = (PsiManagerImpl)fileImpl.getManager();
            BlockSupportImpl.sendBeforeChildrenChangeEvent(manager, fileImpl, false);
            if (this.myOldNode.getFirstChildNode() != null) {
                this.myOldNode.rawRemoveAllChildren();
            }
            if ((firstChildNode = this.myNewNode.getFirstChildNode()) != null) {
                this.myOldNode.rawAddChildren(firstChildNode);
            }
            fileImpl.getTreeElement().setCharTable(this.myNewNode.getCharTable());
            this.myOldNode.subtreeChanged();
            BlockSupportImpl.sendAfterChildrenChangedEvent(manager, fileImpl, oldLength, false);
        }
    }

    private static class InsertEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myNewNode;
        private final int myPos;

        private InsertEntry(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$InsertEntry", "<init>"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$InsertEntry", "<init>"));
            }
            assert (oldParent instanceof CompositeElement) : oldParent;
            assert (pos >= 0) : pos;
            this.myOldParent = oldParent;
            this.myNewNode = newNode;
            this.myPos = pos;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$InsertEntry", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$InsertEntry", "doActualPsiChange"));
            }
            ASTNode anchor2 = null;
            ASTNode firstChildNode = this.myOldParent.getFirstChildNode();
            for (int i = 0; i < this.myPos; ++i) {
                anchor2 = anchor2 == null ? firstChildNode : anchor2.getTreeNext();
            }
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiChild = DiffLog.getPsi(this.myNewNode, file2);
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file2);
                ((PsiManagerEx)file2.getManager()).beforeChildAddition(event);
            }
            ((TreeElement)this.myNewNode).rawRemove();
            if (anchor2 != null) {
                ((TreeElement)anchor2).rawInsertAfterMe((TreeElement)this.myNewNode);
            } else if (firstChildNode != null) {
                ((TreeElement)firstChildNode).rawInsertBeforeMe((TreeElement)this.myNewNode);
            } else {
                ((CompositeElement)this.myOldParent).rawAddChildren((TreeElement)this.myNewNode);
            }
            astDiffBuilder.nodeInserted(this.myOldParent, this.myNewNode, this.myPos);
            ((TreeElement)this.myNewNode).clearCaches();
            ((CompositeElement)this.myOldParent).subtreeChanged();
            DebugUtil.checkTreeStructure(this.myOldParent);
        }
    }

    private static class DeleteEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myOldNode;

        private DeleteEntry(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$DeleteEntry", "<init>"));
            }
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$DeleteEntry", "<init>"));
            }
            this.myOldParent = oldParent;
            this.myOldNode = oldNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            PsiElement psiChild;
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$DeleteEntry", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$DeleteEntry", "doActualPsiChange"));
            }
            ASTNode child = this.myOldNode;
            ASTNode parent2 = this.myOldParent;
            PsiElement psiParent = parent2.getPsi();
            PsiElement psiElement = psiChild = file2.isPhysical() ? child.getPsi() : null;
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file2);
                ((PsiManagerEx)file2.getManager()).beforeChildRemoval(event);
            }
            astDiffBuilder.nodeDeleted(parent2, child);
            ((TreeElement)child).rawRemove();
            ((CompositeElement)parent2).subtreeChanged();
            DebugUtil.checkTreeStructure(parent2);
        }
    }

    private static class ReplaceEntry
    extends LogEntry {
        private final ASTNode myOldChild;
        private final ASTNode myNewChild;

        private ReplaceEntry(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry", "<init>"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry", "<init>"));
            }
            this.myOldChild = oldNode;
            this.myNewChild = newNode;
            ASTNode parent2 = oldNode.getTreeParent();
            assert (parent2 != null) : "old:" + oldNode + " new:" + newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            PsiElement psiOldChild;
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry", "doActualPsiChange"));
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astDiffBuilder", "org/jetbrains/kotlin/com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry", "doActualPsiChange"));
            }
            ASTNode oldNode = this.myOldChild;
            ASTNode newNode = this.myNewChild;
            ASTNode parent2 = oldNode.getTreeParent();
            assert (parent2 != null) : "old:" + oldNode + " new:" + newNode;
            PsiElement psiParent = parent2.getPsi();
            PsiElement psiElement = psiOldChild = file2.isPhysical() ? oldNode.getPsi() : null;
            if (psiParent != null && psiOldChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setFile(file2);
                event.setOldChild(psiOldChild);
                PsiElement psiNewChild = DiffLog.getPsi(newNode, file2);
                event.setNewChild(psiNewChild);
                ((PsiManagerEx)file2.getManager()).beforeChildReplacement(event);
            }
            ((TreeElement)newNode).rawRemove();
            ((TreeElement)oldNode).rawReplaceWithList((TreeElement)newNode);
            astDiffBuilder.nodeReplaced(oldNode, newNode);
            ((TreeElement)newNode).clearCaches();
            if (!(newNode instanceof FileElement)) {
                ((CompositeElement)newNode.getTreeParent()).subtreeChanged();
            }
            DebugUtil.checkTreeStructure(parent2);
        }
    }

    private static abstract class LogEntry {
        protected LogEntry() {
            ProgressIndicatorProvider.checkCanceled();
        }

        abstract void doActualPsiChange(@NotNull PsiFile var1, @NotNull ASTDiffBuilder var2);
    }
}

