/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class ResolveClassUtil {
    @Nullable
    public static PsiClass resolveClass(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveClassUtil", "resolveClass"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveClassUtil", "resolveClass"));
        }
        if (ref instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)ref).getKind(containingFile) == 6) {
            PsiClass qualifierClass;
            PsiType qualifierType;
            PsiExpression qualifier;
            PsiElement parent2 = ref.getParent();
            if (parent2 instanceof PsiAnonymousClass) {
                parent2 = parent2.getParent();
            }
            if (parent2 instanceof PsiNewExpression && (qualifier = ((PsiNewExpression)parent2).getQualifier()) != null && (qualifierType = qualifier.getType()) instanceof PsiClassType && (qualifierClass = PsiUtil.resolveClassInType(qualifierType)) != null) {
                return qualifierClass.findInnerClassByName(ref.getText(), true);
            }
        } else {
            PsiElement classNameElement = ref.getReferenceNameElement();
            if (classNameElement instanceof PsiIdentifier) {
                String className2 = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className2, ref, containingFile);
                PsiScopesUtil.resolveAndWalk(processor, ref, null);
                if (processor.getResult().length == 1) {
                    return (PsiClass)processor.getResult()[0].getElement();
                }
            }
        }
        return null;
    }
}

