/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.filters.ClassFilter;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.StaticImportResolveProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiImportStaticReferenceElementImpl
extends CompositePsiElement
implements PsiImportStaticReferenceElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiImportStaticReferenceElementImpl");
    private volatile String myCanonicalText;

    public PsiImportStaticReferenceElementImpl() {
        super(JavaElementType.IMPORT_STATIC_REFERENCE);
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        if (refName != null) {
            return refName.getStartOffset();
        }
        return super.getTextOffset();
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCanonicalText = null;
    }

    @Override
    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 53: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                TreeElement node = this.getFirstChildNode();
                return node.getElementType() == JavaElementType.JAVA_CODE_REFERENCE ? node : null;
            }
            case 55: 
        }
        return this.findChildByType(JavaTokenType.DOT);
    }

    @Override
    public final int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl", "getTypeParameters"));
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiJavaCodeReferenceElement getClassReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiImportStaticStatement bindToTargetClass(PsiClass aClass2) throws IncorrectOperationException {
        String qualifiedName = aClass2.getQualifiedName();
        if (qualifiedName == null) {
            throw new IncorrectOperationException();
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        CompositeElement newRef = (CompositeElement)parserFacade.createReferenceFromText(qualifiedName, null).getNode();
        if (this.getQualifier() != null) {
            this.replaceChildInternal(this.findChildByRole(54), newRef);
            return (PsiImportStaticStatement)this.getParent();
        }
        LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, SharedImplUtil.findCharTableByTree(newRef), this.getManager());
        newRef.rawInsertAfterMe(dot);
        CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
        dot.rawInsertAfterMe(errorElement);
        CompositeElement parentComposite = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(this.getParent());
        parentComposite.addInternal(newRef, errorElement, this, Boolean.TRUE);
        parentComposite.deleteChildInternal(this);
        return (PsiImportStaticStatement)SourceTreeToPsiMap.treeElementToPsi(parentComposite);
    }

    @Override
    public boolean isQualified() {
        return this.findChildByRole(54) != null;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public String getReferenceName() {
        ASTNode childByRole = this.findChildByRole(53);
        if (childByRole == null) {
            return "";
        }
        return childByRole.getText();
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.findChildByRole(53);
        if (nameChild == null) {
            return new TextRange(0, this.getTextLength());
        }
        int startOffset = nameChild.getStartOffsetInParent();
        return new TextRange(startOffset, startOffset + nameChild.getTextLength());
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String canonicalText = this.myCanonicalText;
        if (canonicalText == null) {
            this.myCanonicalText = canonicalText = this.calcCanonicalText();
        }
        String string = canonicalText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl", "getCanonicalText"));
        }
        return string;
    }

    private String calcCanonicalText() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getQualifier();
        if (referenceElement == null) {
            return this.getReferenceName();
        }
        return referenceElement.getCanonicalText() + "." + this.getReferenceName();
    }

    @Override
    public String toString() {
        return "PsiImportStaticReferenceElement:" + this.getText();
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            JavaResolveResult javaResolveResult = results[0];
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl", "advancedResolve"));
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl", "advancedResolve"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getContainingFile();
        ResolveCache resolveCache = ResolveCache.getInstance(file2.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, OurGenericsResolver.INSTANCE, true, incompleteCode, file2);
        JavaResolveResult[] javaResolveResultArray = results instanceof JavaResolveResult[] ? (JavaResolveResult[])results : JavaResolveResult.EMPTY_ARRAY;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        String name = this.getReferenceName();
        if (name == null || !(element instanceof PsiNamedElement) || !name.equals(((PsiNamedElement)element).getName())) {
            return false;
        }
        for (JavaResolveResult result2 : this.multiResolve(false)) {
            if (!this.getManager().areElementsEquivalent(result2.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl", "bindToElement"));
        }
        if (!(element instanceof PsiMember) || !(element instanceof PsiNamedElement) || ((PsiNamedElement)element).getName() == null) {
            throw new IncorrectOperationException();
        }
        if (!((PsiModifierListOwner)element).hasModifierProperty("static")) {
            if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null) {
                return this.replaceWithRegularImport((PsiClass)element);
            }
            throw new IncorrectOperationException();
        }
        PsiClass containingClass = ((PsiMember)element).getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException();
        }
        PsiElement qualifier = this.getQualifier();
        if (qualifier == null) {
            throw new IncorrectOperationException();
        }
        ((PsiReference)((Object)qualifier)).bindToElement(containingClass);
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(((PsiNamedElement)element).getName());
        oldIdentifier.replace(identifier);
        return this;
    }

    private PsiElement replaceWithRegularImport(PsiClass psiClass) throws IncorrectOperationException {
        PsiImportStaticStatement baseStatement = PsiTreeUtil.getParentOfType(this.getElement(), PsiImportStaticStatement.class);
        PsiImportStatement statement2 = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createImportStatement(psiClass);
        statement2 = (PsiImportStatement)baseStatement.replace(statement2);
        PsiJavaCodeReferenceElement reference = statement2.getImportReference();
        assert (reference != null);
        return reference;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl", "processVariants"));
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)new ClassFilter(PsiModifierListOwner.class), processor);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitImportStaticReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantResolver<PsiImportStaticReferenceElementImpl> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @Override
        @NotNull
        public JavaResolveResult[] resolve(@NotNull PsiImportStaticReferenceElementImpl referenceElement, boolean incompleteCode) {
            if (referenceElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl$OurGenericsResolver", "resolve"));
            }
            PsiElement qualifier = referenceElement.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl$OurGenericsResolver", "resolve"));
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            PsiElement target = ((PsiJavaCodeReferenceElement)qualifier).resolve();
            if (!(target instanceof PsiClass)) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl$OurGenericsResolver", "resolve"));
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            StaticImportResolveProcessor processor = new StaticImportResolveProcessor(referenceElement);
            target.processDeclarations(processor, ResolveState.initial(), referenceElement, referenceElement);
            JavaResolveResult[] javaResolveResultArray = processor.getResults();
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticReferenceElementImpl$OurGenericsResolver", "resolve"));
            }
            return javaResolveResultArray;
        }
    }
}

