/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CollectionStubMethodGenerator;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.DefaultParameterValueSubstitutor;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.InterfaceImplBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.ObjectSuperCallArgumentGenerator;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SuperClassInfo;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtils2Kt;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmClassSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ImplementationBodyCodegen
extends ClassBodyCodegen {
    private Type superClassAsmType;
    @NotNull
    private SuperClassInfo superClassInfo;
    private final Type classAsmType;
    private final boolean isLocal;
    private List<PropertyAndDefaultValue> companionObjectPropertiesToCopy;
    private final DelegationFieldsInfo delegationFieldsInfo;
    private final List<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>> additionalTasks = new ArrayList<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>>();
    private static final Map<FqName, String> KOTLIN_MARKER_INTERFACES = new HashMap<FqName, String>();

    public ImplementationBodyCodegen(@NotNull KtPureClassOrObject aClass2, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen, boolean isLocal) {
        super(aClass2, context, v, state2, parentCodegen);
        this.classAsmType = Type.getObjectType(this.typeMapper.classInternalName(this.descriptor));
        this.isLocal = isLocal;
        this.delegationFieldsInfo = this.getDelegationFieldsInfo(this.myClass.getSuperTypeListEntries());
    }

    @Override
    protected void generateDeclaration() {
        this.getSuperClass();
        JvmClassSignature signature = this.signature();
        boolean isAbstract = false;
        boolean isInterface = false;
        boolean isFinal = false;
        boolean isAnnotation = false;
        boolean isEnum = false;
        ClassKind kind = this.descriptor.getKind();
        Modality modality = this.descriptor.getModality();
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            isAbstract = true;
        }
        if (kind == ClassKind.INTERFACE) {
            isAbstract = true;
            isInterface = true;
        } else if (kind == ClassKind.ANNOTATION_CLASS) {
            isAbstract = true;
            isInterface = true;
            isAnnotation = true;
        } else if (kind == ClassKind.ENUM_CLASS) {
            isAbstract = JvmCodegenUtil.hasAbstractMembers(this.descriptor);
            isEnum = true;
        }
        if (modality != Modality.OPEN && !isAbstract) {
            isFinal = kind == ClassKind.OBJECT || kind != ClassKind.ENUM_CLASS || this.state.getClassBuilderMode().generateBodies;
        }
        int access = 0;
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES && !DescriptorUtils.isTopLevelDeclaration(this.descriptor)) {
            access |= AsmUtil.getVisibilityAccessFlag(this.descriptor);
            if (!this.descriptor.isInner()) {
                access |= 8;
            }
        } else {
            access |= AsmUtil.getVisibilityAccessFlagForClass(this.descriptor);
        }
        if (isAbstract) {
            access |= 0x400;
        }
        access = isInterface ? (access |= 0x200) : (access |= 0x20);
        if (isFinal) {
            access |= 0x10;
        }
        if (isAnnotation) {
            access |= 0x2000;
        }
        if (KotlinBuiltIns.isDeprecated(this.descriptor)) {
            access |= 0x20000;
        }
        if (isEnum) {
            for (KtDeclaration declaration : this.myClass.getDeclarations()) {
                if (!(declaration instanceof KtEnumEntry) || !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration)) continue;
                access &= 0xFFFFFFEF;
            }
            access |= 0x4000;
        }
        this.v.defineClass(this.myClass.getPsiOrParent(), this.state.getClassFileVersion(), access, signature.getName(), signature.getJavaGenericSignature(), signature.getSuperclassName(), ArrayUtil.toStringArray(signature.getInterfaces()));
        this.v.visitSource(this.myClass.getContainingKtFile().getName(), null);
        InlineCodegenUtils2Kt.initDefaultSourceMappingIfNeeded(this.context, this, this.state);
        this.writeEnclosingMethod();
        AnnotationCodegen.forClass(this.v.getVisitor(), this, this.typeMapper).genAnnotations(this.descriptor, null);
        this.generateEnumEntries();
    }

    @Override
    protected void generateDefaultImplsIfNeeded() {
        if (DescriptorUtils.isInterface(this.descriptor) && !this.isLocal && (!JvmCodegenUtil.isJvm8InterfaceWithDefaults(this.descriptor, this.state) || this.state.getGenerateDefaultImplsForJvm8())) {
            Type defaultImplsType = this.state.getTypeMapper().mapDefaultImpls(this.descriptor);
            ClassBuilder defaultImplsBuilder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.DefaultImpls(this.myClass.getPsiOrParent(), this.descriptor), defaultImplsType, this.myClass.getContainingKtFile());
            CodegenContext parentContext = this.context.getParentContext();
            assert (parentContext != null) : "Parent context of interface declaration should not be null";
            ClassContext defaultImplsContext = parentContext.intoDefaultImplsClass(this.descriptor, (ClassContext)this.context, this.state);
            new InterfaceImplBodyCodegen(this.myClass, defaultImplsContext, defaultImplsBuilder, this.state, this).generate();
        }
    }

    @Override
    protected void generateKotlinMetadataAnnotation() {
        this.generateKotlinClassMetadataAnnotation(this.descriptor, false);
    }

    private void writeEnclosingMethod() {
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor) || !(this.descriptor.getContainingDeclaration() instanceof ClassOrPackageFragmentDescriptor)) {
            this.writeOuterClassAndEnclosingMethod();
        }
    }

    @NotNull
    private JvmClassSignature signature() {
        return ImplementationBodyCodegen.signature(this.descriptor, this.classAsmType, this.superClassInfo, this.typeMapper);
    }

    @NotNull
    public static JvmClassSignature signature(@NotNull ClassDescriptor descriptor2, @NotNull Type classAsmType, @NotNull SuperClassInfo superClassInfo, @NotNull KotlinTypeMapper typeMapper) {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        typeMapper.writeFormalTypeParameters(descriptor2.getDeclaredTypeParameters(), sw);
        ((JvmSignatureWriter)sw).writeSuperclass();
        if (superClassInfo.getKotlinType() == null) {
            ((JvmSignatureWriter)sw).writeClassBegin(superClassInfo.getType());
            ((JvmSignatureWriter)sw).writeClassEnd();
        } else {
            typeMapper.mapSupertype(superClassInfo.getKotlinType(), sw);
        }
        ((JvmSignatureWriter)sw).writeSuperclassEnd();
        LinkedHashSet<String> superInterfaces = new LinkedHashSet<String>();
        LinkedHashSet<String> kotlinMarkerInterfaces = new LinkedHashSet<String>();
        for (KotlinType supertype : descriptor2.getTypeConstructor().getSupertypes()) {
            if (!JvmCodegenUtil.isJvmInterface(supertype.getConstructor().getDeclarationDescriptor())) continue;
            FqName kotlinInterfaceName = DescriptorUtils.getFqName(supertype.getConstructor().getDeclarationDescriptor()).toSafe();
            ((JvmSignatureWriter)sw).writeInterface();
            Type jvmInterfaceType = typeMapper.mapSupertype(supertype, sw);
            ((JvmSignatureWriter)sw).writeInterfaceEnd();
            String jvmInterfaceInternalName = jvmInterfaceType.getInternalName();
            superInterfaces.add(jvmInterfaceInternalName);
            String kotlinMarkerInterfaceInternalName = KOTLIN_MARKER_INTERFACES.get(kotlinInterfaceName);
            if (kotlinMarkerInterfaceInternalName == null) continue;
            if (typeMapper.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
                ((JvmSignatureWriter)sw).writeInterface();
                Type kotlinCollectionType = typeMapper.mapType(supertype, sw, TypeMappingMode.SUPER_TYPE_KOTLIN_COLLECTIONS_AS_IS);
                ((JvmSignatureWriter)sw).writeInterfaceEnd();
                superInterfaces.add(kotlinCollectionType.getInternalName());
            }
            kotlinMarkerInterfaces.add(kotlinMarkerInterfaceInternalName);
        }
        for (String kotlinMarkerInterface : kotlinMarkerInterfaces) {
            ((JvmSignatureWriter)sw).writeInterface();
            ((JvmSignatureWriter)sw).writeAsmType(Type.getObjectType(kotlinMarkerInterface));
            ((JvmSignatureWriter)sw).writeInterfaceEnd();
        }
        superInterfaces.addAll(kotlinMarkerInterfaces);
        return new JvmClassSignature(classAsmType.getInternalName(), superClassInfo.getType().getInternalName(), new ArrayList<String>(superInterfaces), ((JvmSignatureWriter)sw).makeJavaGenericSignature());
    }

    private void getSuperClass() {
        this.superClassInfo = SuperClassInfo.getSuperClassInfo(this.descriptor, this.typeMapper);
        this.superClassAsmType = this.superClassInfo.getType();
    }

    @Override
    protected void generateSyntheticPartsBeforeBody() {
        this.generatePropertyMetadataArrayFieldIfNeeded(this.classAsmType);
    }

    @Override
    protected void generateSyntheticPartsAfterBody() {
        this.generateFieldForSingleton();
        this.initializeObjects();
        this.generateCompanionObjectBackingFieldCopies();
        this.generateTraitMethods();
        this.generateDelegates(this.delegationFieldsInfo);
        if (!DescriptorUtils.isInterface(this.descriptor) || this.kind == OwnerKind.DEFAULT_IMPLS) {
            this.generateSyntheticAccessors();
        }
        this.generateEnumMethods();
        this.generateFunctionsForDataClasses();
        if (this.state.getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES) {
            new CollectionStubMethodGenerator(this.typeMapper, this.descriptor).generate(this.functionCodegen, this.v);
            this.generateToArray();
        }
        if (this.context.closure != null) {
            AsmUtil.genClosureFields(this.context.closure, this.v, this.typeMapper);
        }
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        for (ExpressionCodegenExtension extension : ExpressionCodegenExtension.Companion.getInstances(this.state.getProject())) {
            extension.generateClassSyntheticParts(this);
        }
    }

    @Override
    protected void generateConstructors() {
        try {
            this.lookupConstructorExpressionsInClosureIfPresent();
            this.generatePrimaryConstructor(this.delegationFieldsInfo);
            for (ClassConstructorDescriptor secondaryConstructor : DescriptorUtilsKt.getSecondaryConstructors(this.descriptor)) {
                this.generateSecondaryConstructor(secondaryConstructor);
            }
        }
        catch (CompilationException | ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error generating constructors of class " + this.myClass.getName() + " with kind " + (Object)((Object)this.kind), e);
        }
    }

    private void generateToArray() {
        MethodVisitor mv;
        if (this.descriptor.getKind() == ClassKind.INTERFACE) {
            return;
        }
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(this.descriptor);
        if (!DescriptorUtils.isSubclass(this.descriptor, builtIns.getCollection())) {
            return;
        }
        if (CollectionsKt.any(DescriptorUtilsKt.getAllSuperclassesWithoutAny(this.descriptor), classDescriptor -> !(classDescriptor instanceof JavaClassDescriptor) && DescriptorUtils.isSubclass(classDescriptor, builtIns.getCollection()))) {
            return;
        }
        Collection<SimpleFunctionDescriptor> functions2 = this.descriptor.getDefaultType().getMemberScope().getContributedFunctions(Name.identifier("toArray"), NoLookupLocation.FROM_BACKEND);
        boolean hasGenericToArray = false;
        boolean hasNonGenericToArray = false;
        for (FunctionDescriptor functionDescriptor : functions2) {
            hasGenericToArray |= CodegenUtilKt.isGenericToArray(functionDescriptor);
            hasNonGenericToArray |= CodegenUtilKt.isNonGenericToArray(functionDescriptor);
        }
        if (!hasNonGenericToArray) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 1, "toArray", "()[Ljava/lang/Object;", null, null);
            InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
            mv.visitCode();
            instructionAdapter.load(0, this.classAsmType);
            instructionAdapter.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;)[Ljava/lang/Object;", false);
            instructionAdapter.areturn(Type.getType("[Ljava/lang/Object;"));
            FunctionCodegen.endVisit(mv, "toArray", this.myClass);
        }
        if (!hasGenericToArray) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 1, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", "<T:Ljava/lang/Object;>([TT;)[TT;", null);
            InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
            mv.visitCode();
            instructionAdapter.load(0, this.classAsmType);
            instructionAdapter.load(1, Type.getType("[Ljava/lang/Object;"));
            instructionAdapter.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", false);
            instructionAdapter.areturn(Type.getType("[Ljava/lang/Object;"));
            FunctionCodegen.endVisit(mv, "toArray", this.myClass);
        }
    }

    public Type genPropertyOnStack(InstructionAdapter iv, MethodContext context, @NotNull PropertyDescriptor propertyDescriptor, Type classAsmType, int index2) {
        iv.load(index2, classAsmType);
        if (JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, false, context, this.state.getShouldInlineConstVals())) {
            Type type2 = this.typeMapper.mapType(propertyDescriptor.getType());
            String fieldName = ((FieldOwnerContext)context.getParentContext()).getFieldName(propertyDescriptor, false);
            iv.getfield(classAsmType.getInternalName(), fieldName, type2.getDescriptor());
            return type2;
        }
        Method method = this.typeMapper.mapAsmMethod(propertyDescriptor.getGetter());
        iv.invokevirtual(classAsmType.getInternalName(), method.getName(), method.getDescriptor(), false);
        return method.getReturnType();
    }

    private void generateFunctionsForDataClasses() {
        if (!this.descriptor.isData()) {
            return;
        }
        if (!(this.myClass instanceof KtClassOrObject)) {
            return;
        }
        new DataClassMethodGeneratorImpl((KtClassOrObject)this.myClass, this.bindingContext).generate();
    }

    @NotNull
    private static ConstructorDescriptor getPrimaryConstructorOfDataClass(@NotNull ClassDescriptor classDescriptor) {
        ClassConstructorDescriptor constructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        assert (constructor != null) : "Data class must have primary constructor: " + classDescriptor;
        return constructor;
    }

    private void generateEnumMethods() {
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            this.generateEnumValuesMethod();
            this.generateEnumValueOfMethod();
        }
    }

    private void generateEnumValuesMethod() {
        Type type2 = this.typeMapper.mapType(DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        FunctionDescriptor valuesFunction = (FunctionDescriptor)CollectionsKt.single(this.descriptor.getStaticScope().getContributedFunctions(DescriptorUtils.ENUM_VALUES, NoLookupLocation.FROM_BACKEND));
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass, valuesFunction), 9, DescriptorUtils.ENUM_VALUES.asString(), "()" + type2.getDescriptor(), null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        mv.visitFieldInsn(178, this.classAsmType.getInternalName(), "$VALUES", type2.getDescriptor());
        mv.visitMethodInsn(182, type2.getInternalName(), "clone", "()Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, type2.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "values()", this.myClass);
    }

    private void generateEnumValueOfMethod() {
        FunctionDescriptor valueOfFunction = (FunctionDescriptor)CollectionsKt.single(this.descriptor.getStaticScope().getContributedFunctions(DescriptorUtils.ENUM_VALUE_OF, NoLookupLocation.FROM_BACKEND), DescriptorUtilsKt::isEnumValueOfMethod);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass, valueOfFunction), 9, DescriptorUtils.ENUM_VALUE_OF.asString(), "(Ljava/lang/String;)" + this.classAsmType.getDescriptor(), null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        mv.visitLdcInsn(this.classAsmType);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(192, this.classAsmType.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "valueOf()", this.myClass);
    }

    private void generateFieldForSingleton() {
        StackValue.Field field;
        if (JvmAbi.isCompanionObjectInInterfaceNotIntrinsic(this.descriptor)) {
            field = StackValue.createSingletonViaInstance(this.descriptor, this.typeMapper, "$$INSTANCE");
            this.v.newField(JvmDeclarationOriginKt.OtherOrigin(this.descriptor), 4120, field.name, field.type.getDescriptor(), null, null);
        }
        if (DescriptorUtils.isEnumEntry(this.descriptor) || DescriptorUtils.isCompanionObject(this.descriptor)) {
            return;
        }
        if (DescriptorUtils.isNonCompanionObject(this.descriptor)) {
            field = StackValue.createSingletonViaInstance(this.descriptor, this.typeMapper, "INSTANCE");
            this.v.newField(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass), 25, field.name, field.type.getDescriptor(), null, null);
            return;
        }
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 == null) {
            return;
        }
        KtObjectDeclaration companionObject = (KtObjectDeclaration)CollectionsKt.firstOrNull(this.myClass.getCompanionObjects());
        int properFieldVisibilityFlag = AsmUtil.getVisibilityAccessFlag(companionObjectDescriptor2);
        boolean deprecatedFieldForInvisibleCompanionObject = this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.DeprecatedFieldForInvisibleCompanionObject);
        boolean properVisibilityForCompanionObjectInstanceField = this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperVisibilityForCompanionObjectInstanceField);
        boolean fieldShouldBeDeprecated = deprecatedFieldForInvisibleCompanionObject && !properVisibilityForCompanionObjectInstanceField && (properFieldVisibilityFlag & 6) != 0;
        int fieldAccessFlags = 25;
        if (properVisibilityForCompanionObjectInstanceField) {
            fieldAccessFlags |= properFieldVisibilityFlag;
        }
        if (fieldShouldBeDeprecated) {
            fieldAccessFlags |= 0x20000;
        }
        StackValue.Field field2 = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
        FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.OtherOrigin(companionObject == null ? this.myClass.getPsiOrParent() : companionObject), fieldAccessFlags, field2.name, field2.type.getDescriptor(), null, null);
        if (fieldShouldBeDeprecated) {
            AnnotationCodegen.forField(fv, this, this.typeMapper).visitAnnotation("Ljava/lang/Deprecated;", true).visitEnd();
        }
    }

    private void initializeObjects() {
        if (!DescriptorUtils.isObject(this.descriptor)) {
            return;
        }
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        boolean isNonCompanionObject = DescriptorUtils.isNonCompanionObject(this.descriptor);
        boolean isInterfaceCompanion = JvmAbi.isCompanionObjectInInterfaceNotIntrinsic(this.descriptor);
        boolean isMappedIntrinsicCompanionObject = JvmAbi.isMappedIntrinsicCompanionObject(this.descriptor);
        if (isNonCompanionObject || isInterfaceCompanion || isMappedIntrinsicCompanionObject) {
            ExpressionCodegen clInitCodegen = this.createOrGetClInitCodegen();
            InstructionAdapter v = clInitCodegen.v;
            ImplementationBodyCodegen.markLineNumberForElement(((KtPureClassOrObject)this.element).getPsiOrParent(), v);
            v.anew(this.classAsmType);
            v.dup();
            v.invokespecial(this.classAsmType.getInternalName(), "<init>", "()V", false);
            int local0Index = clInitCodegen.getFrameMap().enterTemp(this.classAsmType);
            assert (local0Index == 0) : "Local variable with index 0 in clInit should be used only for singleton instance keeping";
            StackValue.Local local0 = StackValue.local(0, this.classAsmType);
            local0.store(StackValue.onStack(this.classAsmType), clInitCodegen.v);
            StackValue.Field singleton = StackValue.createSingletonViaInstance(this.descriptor, this.typeMapper, isInterfaceCompanion ? "$$INSTANCE" : "INSTANCE");
            singleton.store(local0, clInitCodegen.v);
            this.generateInitializers(clInitCodegen);
            if (isInterfaceCompanion) {
                StackValue.singleton(this.descriptor, this.typeMapper).store(singleton, this.getParentCodegen().createOrGetClInitCodegen().v, true);
            }
        } else if (JvmAbi.isCompanionObjectWithBackingFieldsInOuter(this.descriptor)) {
            ImplementationBodyCodegen parentCodegen = (ImplementationBodyCodegen)this.getParentCodegen();
            ExpressionCodegen parentClInitCodegen = parentCodegen.createOrGetClInitCodegen();
            InstructionAdapter parentVisitor = parentClInitCodegen.v;
            FunctionDescriptor constructor = (FunctionDescriptor)parentCodegen.context.accessibleDescriptor((CallableMemberDescriptor)CollectionsKt.single(this.descriptor.getConstructors()), null);
            parentCodegen.generateMethodCallTo(constructor, null, parentVisitor);
            StackValue instance = StackValue.onStack(parentCodegen.typeMapper.mapClass(this.descriptor));
            StackValue.singleton(this.descriptor, parentCodegen.typeMapper).store(instance, parentVisitor, true);
            this.generateInitializers(parentClInitCodegen);
        } else assert (false) : "Unknown object type: " + this.descriptor;
    }

    private void generateCompanionObjectBackingFieldCopies() {
        if (this.companionObjectPropertiesToCopy == null) {
            return;
        }
        for (PropertyAndDefaultValue info : this.companionObjectPropertiesToCopy) {
            PropertyDescriptor property = info.descriptor;
            Type type2 = this.typeMapper.mapType(property);
            int modifiers2 = 25;
            FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.Synthetic(DescriptorToSourceUtils.descriptorToDeclaration(property), property), modifiers2, this.context.getFieldName(property, false), type2.getDescriptor(), this.typeMapper.mapFieldSignature(property.getType(), property), info.defaultValue);
            AnnotationCodegen.forField(fv, this, this.typeMapper).genAnnotations(property, type2);
            if (!this.state.getClassBuilderMode().generateBodies || info.defaultValue != null) continue;
            ExpressionCodegen codegen = this.createOrGetClInitCodegen();
            int companionObjectIndex = this.putCompanionObjectInLocalVar(codegen);
            StackValue.local(companionObjectIndex, AsmTypes.OBJECT_TYPE).put(AsmTypes.OBJECT_TYPE, codegen.v);
            this.copyFieldFromCompanionObject(property);
        }
    }

    private int putCompanionObjectInLocalVar(ExpressionCodegen codegen) {
        FrameMap frameMap = codegen.myFrameMap;
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        int companionObjectIndex = frameMap.getIndex(companionObjectDescriptor2);
        if (companionObjectIndex == -1) {
            companionObjectIndex = frameMap.enter(companionObjectDescriptor2, AsmTypes.OBJECT_TYPE);
            StackValue.Field companionObject = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            StackValue.local(companionObjectIndex, companionObject.type).store(companionObject, codegen.v);
        }
        return companionObjectIndex;
    }

    private void copyFieldFromCompanionObject(PropertyDescriptor propertyDescriptor) {
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        StackValue.Property property = codegen.intermediateValueForProperty(propertyDescriptor, false, null, StackValue.none());
        StackValue.Field field = StackValue.field(property.type, this.classAsmType, propertyDescriptor.getName().asString(), true, StackValue.none(), propertyDescriptor);
        field.store(property, codegen.v);
    }

    private void generatePrimaryConstructor(final DelegationFieldsInfo delegationFieldsInfo) {
        if (DescriptorUtils.isInterface(this.descriptor) || DescriptorUtils.isAnnotationClass(this.descriptor)) {
            return;
        }
        final ClassConstructorDescriptor constructorDescriptor = this.descriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor);
        final KtPrimaryConstructor primaryConstructor2 = this.myClass.getPrimaryConstructor();
        JvmDeclarationOrigin origin = JvmDeclarationOriginKt.OtherOrigin(primaryConstructor2 != null ? primaryConstructor2 : this.myClass.getPsiOrParent(), constructorDescriptor);
        this.functionCodegen.generateMethod(origin, constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                ImplementationBodyCodegen.this.generatePrimaryConstructorImpl(constructorDescriptor, codegen, delegationFieldsInfo, primaryConstructor2);
            }
        });
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, constructorDescriptor, OwnerKind.IMPLEMENTATION, DefaultParameterValueLoader.DEFAULT, null);
        new DefaultParameterValueSubstitutor(this.state).generatePrimaryConstructorOverloadsIfNeeded(constructorDescriptor, this.v, this, this.kind, this.myClass);
    }

    private void generateSecondaryConstructor(final @NotNull ClassConstructorDescriptor constructorDescriptor) {
        if (!DescriptorUtils.canHaveDeclaredConstructors(this.descriptor)) {
            return;
        }
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor);
        KtSecondaryConstructor constructor = (KtSecondaryConstructor)DescriptorToSourceUtils.descriptorToDeclaration(constructorDescriptor);
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(constructor, constructorDescriptor), constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                ImplementationBodyCodegen.this.generateSecondaryConstructorImpl(constructorDescriptor, codegen);
            }
        });
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, constructorDescriptor, OwnerKind.IMPLEMENTATION, DefaultParameterValueLoader.DEFAULT, null);
        new DefaultParameterValueSubstitutor(this.state).generateOverloadsIfNeeded(constructor, constructorDescriptor, constructorDescriptor, this.kind, this.v, this);
    }

    private void generatePrimaryConstructorImpl(@NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull ExpressionCodegen codegen, @NotNull DelegationFieldsInfo fieldsInfo, @Nullable KtPrimaryConstructor primaryConstructor2) {
        InstructionAdapter iv = codegen.v;
        ImplementationBodyCodegen.markLineNumberForConstructor(constructorDescriptor, primaryConstructor2, codegen);
        this.generateClosureInitialization(iv);
        this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor, BindingContextUtils.getDelegationConstructorCall(this.bindingContext, constructorDescriptor));
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            this.genCallToDelegatorByExpressionSpecifier(iv, codegen, (KtDelegatedSuperTypeEntry)specifier, fieldsInfo);
        }
        int curParam = 0;
        List<ValueParameterDescriptor> parameters2 = constructorDescriptor.getValueParameters();
        for (KtParameter parameter : this.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVar()) {
                VariableDescriptor descriptor2 = parameters2.get(curParam);
                Type type2 = this.typeMapper.mapType(descriptor2);
                iv.load(0, this.classAsmType);
                iv.load(codegen.myFrameMap.getIndex(descriptor2), type2);
                PropertyDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                assert (propertyDescriptor != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                iv.putfield(this.classAsmType.getInternalName(), this.context.getFieldName(propertyDescriptor, false), type2.getDescriptor());
            }
            ++curParam;
        }
        if (!DescriptorUtils.isObject(this.descriptor)) {
            this.generateInitializers(codegen);
        }
        iv.visitInsn(177);
    }

    private void generateSecondaryConstructorImpl(@NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull ExpressionCodegen codegen) {
        InstructionAdapter iv = codegen.v;
        KtSecondaryConstructor constructor = (KtSecondaryConstructor)DescriptorToSourceUtils.descriptorToDeclaration(constructorDescriptor);
        ImplementationBodyCodegen.markLineNumberForConstructor(constructorDescriptor, constructor, codegen);
        ResolvedCall<ConstructorDescriptor> constructorDelegationCall = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, constructorDescriptor);
        ConstructorDescriptor delegateConstructor = constructorDelegationCall == null ? null : constructorDelegationCall.getResultingDescriptor();
        this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor, constructorDelegationCall);
        if (!this.isSameClassConstructor(delegateConstructor)) {
            this.generateClosureInitialization(iv);
            this.generateInitializers(codegen);
        }
        assert (constructor != null);
        if (constructor.hasBody()) {
            codegen.gen(constructor.getBodyExpression(), Type.VOID_TYPE);
        }
        iv.visitInsn(177);
    }

    private static void markLineNumberForConstructor(@NotNull ClassConstructorDescriptor descriptor2, @Nullable KtConstructor constructor, @NotNull ExpressionCodegen codegen) {
        if (constructor == null) {
            ImplementationBodyCodegen.markLineNumberForDescriptor(descriptor2.getContainingDeclaration(), codegen.v);
        } else if (constructor.hasBody() && (!(constructor instanceof KtSecondaryConstructor) || ((KtSecondaryConstructor)constructor).hasImplicitDelegationCall())) {
            List<Object> statements;
            KtBlockExpression bodyExpression = constructor.getBodyExpression();
            List<Object> list2 = statements = bodyExpression != null ? bodyExpression.getStatements() : Collections.emptyList();
            if (!statements.isEmpty()) {
                codegen.markStartLineNumber((KtElement)statements.iterator().next());
            } else {
                codegen.markStartLineNumber((KtElement)((Object)(bodyExpression != null ? bodyExpression : constructor)));
            }
        } else {
            codegen.markStartLineNumber(constructor);
        }
    }

    public void generateInitializers(@NotNull ExpressionCodegen codegen) {
        this.generateInitializers((Function0<ExpressionCodegen>)((Function0)() -> codegen));
    }

    private void generateClosureInitialization(@NotNull InstructionAdapter iv) {
        MutableClosure closure = this.context.closure;
        if (closure != null) {
            List<FieldInfo> argsFromClosure = ClosureCodegen.calculateConstructorParameters(this.typeMapper, closure, this.classAsmType);
            int k = 1;
            for (FieldInfo info : argsFromClosure) {
                k = AsmUtil.genAssignInstanceFieldFromParam(info, k, iv);
            }
        }
    }

    private void genSimpleSuperCall(InstructionAdapter iv) {
        iv.load(0, this.superClassAsmType);
        if (this.descriptor.getKind() == ClassKind.ENUM_CLASS || this.descriptor.getKind() == ClassKind.ENUM_ENTRY) {
            iv.load(1, AsmTypes.JAVA_STRING_TYPE);
            iv.load(2, Type.INT_TYPE);
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        } else {
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "()V", false);
        }
    }

    @NotNull
    private DelegationFieldsInfo getDelegationFieldsInfo(@NotNull List<KtSuperTypeListEntry> delegationSpecifiers) {
        DelegationFieldsInfo result2 = new DelegationFieldsInfo();
        int n = 0;
        for (KtSuperTypeListEntry specifier : delegationSpecifiers) {
            KtExpression expression2;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry) || (expression2 = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression()) == null) continue;
            PropertyDescriptor propertyDescriptor = CodegenUtil.getDelegatePropertyIfAny(expression2, this.descriptor, this.bindingContext);
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor, this.bindingContext)) {
                result2.addField((KtDelegatedSuperTypeEntry)specifier, propertyDescriptor);
            } else {
                Type asmType;
                KotlinType expressionType = this.bindingContext.getType(expression2);
                ClassDescriptor superClass = this.getSuperClass(specifier);
                Type type2 = expressionType != null ? this.typeMapper.mapType(expressionType) : (asmType = superClass != null ? this.typeMapper.mapType(superClass) : null);
                if (asmType == null) continue;
                result2.addField((KtDelegatedSuperTypeEntry)specifier, asmType, "$$delegate_" + n);
            }
            ++n;
        }
        return result2;
    }

    @Nullable
    private ClassDescriptor getSuperClass(@NotNull KtSuperTypeListEntry specifier) {
        ClassDescriptor superClass = CodegenUtil.getSuperClassBySuperTypeListEntry(specifier, this.bindingContext);
        assert (superClass != null || this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) : "ClassDescriptor should not be null:" + specifier.getText();
        return superClass;
    }

    private void genCallToDelegatorByExpressionSpecifier(InstructionAdapter iv, ExpressionCodegen codegen, KtDelegatedSuperTypeEntry specifier, DelegationFieldsInfo fieldsInfo) {
        KtExpression expression2 = specifier.getDelegateExpression();
        DelegationFieldsInfo.Field fieldInfo = fieldsInfo.getInfo(specifier);
        if (fieldInfo == null) {
            return;
        }
        if (fieldInfo.generateField) {
            iv.load(0, this.classAsmType);
            fieldInfo.getStackValue().store(codegen.gen(expression2), iv);
        }
    }

    private void lookupConstructorExpressionsInClosureIfPresent() {
        if (!this.state.getClassBuilderMode().generateBodies || this.descriptor.getConstructors().isEmpty()) {
            return;
        }
        KtVisitorVoid visitor2 = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement e) {
                e.acceptChildren(this);
            }

            @Override
            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expr) {
                DeclarationDescriptor descriptor2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expr);
                if (ExpressionTypingUtils.isLocalFunction(descriptor2)) {
                    this.lookupInContext(descriptor2);
                } else if (descriptor2 instanceof CallableMemberDescriptor) {
                    ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(expr, ImplementationBodyCodegen.this.bindingContext);
                    if (call2 != null) {
                        this.lookupReceivers(call2);
                    }
                    if (call2 instanceof VariableAsFunctionResolvedCall) {
                        this.lookupReceivers(((VariableAsFunctionResolvedCall)((Object)call2)).getVariableCall());
                    }
                } else if (descriptor2 instanceof VariableDescriptor) {
                    ClassDescriptor classDescriptor;
                    DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
                    if (containingDeclaration instanceof ConstructorDescriptor && (classDescriptor = ((ConstructorDescriptor)containingDeclaration).getConstructedClass()) == ImplementationBodyCodegen.this.descriptor) {
                        return;
                    }
                    this.lookupInContext(descriptor2);
                }
            }

            private void lookupReceivers(@NotNull ResolvedCall<? extends CallableDescriptor> call2) {
                this.lookupReceiver(call2.getDispatchReceiver());
                this.lookupReceiver(call2.getExtensionReceiver());
            }

            private void lookupReceiver(@Nullable ReceiverValue value) {
                if (value instanceof ImplicitReceiver) {
                    if (value instanceof ExtensionReceiver) {
                        ReceiverParameterDescriptor parameter = ((ExtensionReceiver)value).getDeclarationDescriptor().getExtensionReceiverParameter();
                        assert (parameter != null) : "Extension receiver should exist: " + ((ExtensionReceiver)value).getDeclarationDescriptor();
                        this.lookupInContext(parameter);
                    } else {
                        this.lookupInContext(((ImplicitReceiver)value).getDeclarationDescriptor());
                    }
                }
            }

            private void lookupInContext(@NotNull DeclarationDescriptor toLookup) {
                ImplementationBodyCodegen.this.context.lookupInContext(toLookup, StackValue.LOCAL_0, ImplementationBodyCodegen.this.state, true);
            }

            @Override
            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                ReceiverParameterDescriptor parameter;
                DeclarationDescriptor descriptor2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference());
                assert (descriptor2 instanceof CallableDescriptor || descriptor2 instanceof ClassDescriptor) : "'This' reference target should be class or callable descriptor but was " + descriptor2;
                if (descriptor2 instanceof ClassDescriptor) {
                    this.lookupInContext(descriptor2);
                }
                if (descriptor2 instanceof CallableDescriptor && (parameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter()) != null) {
                    this.lookupInContext(parameter);
                }
            }

            @Override
            public void visitSuperExpression(@NotNull KtSuperExpression expression2) {
                this.lookupInContext(ExpressionCodegen.getSuperCallLabelTarget(ImplementationBodyCodegen.this.context, expression2));
            }
        };
        for (KtDeclaration declaration : this.myClass.getDeclarations()) {
            if (declaration instanceof KtProperty) {
                KtProperty property = (KtProperty)declaration;
                KtExpression initializer2 = property.getDelegateExpressionOrInitializer();
                if (initializer2 == null) continue;
                initializer2.accept(visitor2);
                continue;
            }
            if (declaration instanceof KtAnonymousInitializer) {
                KtAnonymousInitializer initializer3 = (KtAnonymousInitializer)declaration;
                initializer3.accept(visitor2);
                continue;
            }
            if (!(declaration instanceof KtSecondaryConstructor)) continue;
            KtSecondaryConstructor constructor = (KtSecondaryConstructor)declaration;
            constructor.accept(visitor2);
        }
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            if (specifier instanceof KtDelegatedSuperTypeEntry) {
                KtExpression delegateExpression = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression();
                assert (delegateExpression != null);
                delegateExpression.accept(visitor2);
                continue;
            }
            if (!(specifier instanceof KtSuperTypeCallEntry)) continue;
            specifier.accept(visitor2);
        }
    }

    private void generateTraitMethods() {
        if (JvmCodegenUtil.isInterfaceWithoutDefaults(this.descriptor, this.state)) {
            return;
        }
        ArrayList<FunctionDescriptor> restrictedInheritance = new ArrayList<FunctionDescriptor>();
        for (Map.Entry<FunctionDescriptor, FunctionDescriptor> entry : CodegenUtil.getNonPrivateTraitMethods(this.descriptor).entrySet()) {
            FunctionDescriptor interfaceFun = entry.getKey();
            if (CodegenUtilKt.isDefinitelyNotDefaultImplsMethod(interfaceFun) || JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(interfaceFun, this.state)) continue;
            if (this.state.isJvm8TargetWithDefaults() && !JvmCodegenUtil.isJvm8InterfaceWithDefaults(interfaceFun.getContainingDeclaration(), this.state)) {
                restrictedInheritance.add(interfaceFun);
                continue;
            }
            this.generateDelegationToDefaultImpl(interfaceFun, entry.getValue());
        }
        CodegenUtilKt.reportTarget6InheritanceErrorIfNeeded(this.descriptor, this.myClass.getPsiOrParent(), restrictedInheritance, this.state);
    }

    private void generateDelegationToDefaultImpl(final @NotNull FunctionDescriptor interfaceFun, final @NotNull FunctionDescriptor inheritedFun) {
        this.functionCodegen.generateMethod(new JvmDeclarationOrigin(JvmDeclarationOriginKind.CLASS_MEMBER_DELEGATION_TO_DEFAULT_IMPL, DescriptorToSourceUtils.descriptorToDeclaration(interfaceFun), interfaceFun), inheritedFun, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                DeclarationDescriptor containingDeclaration = interfaceFun.getContainingDeclaration();
                if (!DescriptorUtils.isInterface(containingDeclaration)) {
                    return;
                }
                DeclarationDescriptor declarationInheritedFun = inheritedFun.getContainingDeclaration();
                PsiElement classForInheritedFun = DescriptorToSourceUtils.descriptorToDeclaration(declarationInheritedFun);
                if (classForInheritedFun instanceof KtDeclaration) {
                    codegen.markLineNumber((KtElement)classForInheritedFun, false);
                }
                ClassDescriptor containingTrait = (ClassDescriptor)containingDeclaration;
                Type traitImplType = ImplementationBodyCodegen.this.typeMapper.mapDefaultImpls(containingTrait);
                Method traitMethod = ImplementationBodyCodegen.this.typeMapper.mapAsmMethod(interfaceFun.getOriginal(), OwnerKind.DEFAULT_IMPLS);
                Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                Type[] originalArgTypes = traitMethod.getArgumentTypes();
                assert (originalArgTypes.length == argTypes.length + 1) : "Invalid trait implementation signature: " + signature + " vs " + traitMethod + " for " + interfaceFun;
                InstructionAdapter iv = codegen.v;
                iv.load(0, AsmTypes.OBJECT_TYPE);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i + 1], iv);
                    reg += argTypes[i].getSize();
                }
                if (KotlinBuiltIns.isCloneable(containingTrait) && traitMethod.getName().equals("clone")) {
                    iv.invokespecial("java/lang/Object", "clone", "()Ljava/lang/Object;", false);
                } else {
                    iv.invokestatic(traitImplType.getInternalName(), traitMethod.getName(), traitMethod.getDescriptor(), false);
                }
                Type returnType = signature.getReturnType();
                StackValue.onStack(traitMethod.getReturnType()).put(returnType, iv);
                iv.areturn(returnType);
            }
        });
    }

    private void generateDelegatorToConstructorCall(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ClassConstructorDescriptor constructorDescriptor, @Nullable ResolvedCall<ConstructorDescriptor> delegationConstructorCall) {
        MethodContext codegenContext = codegen.context;
        assert (codegenContext instanceof ConstructorContext) : "Constructor context expected: " + codegenContext;
        assert (!((ConstructorContext)codegenContext).isThisInitialized()) : "Delegating constructor call is already generated for " + ((ConstructorContext)codegenContext).getConstructorDescriptor();
        if (delegationConstructorCall == null) {
            this.genSimpleSuperCall(iv);
        } else {
            this.generateDelegationConstructorCall(iv, codegen, constructorDescriptor, delegationConstructorCall);
        }
        ((ConstructorContext)codegenContext).setThisInitialized(true);
    }

    private void generateDelegationConstructorCall(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull ResolvedCall<ConstructorDescriptor> delegationConstructorCall) {
        iv.load(0, AsmTypes.OBJECT_TYPE);
        ConstructorDescriptor delegateConstructor = SamCodegenUtil.resolveSamAdapter(codegen.getConstructorDescriptor(delegationConstructorCall));
        CallableMethod delegateConstructorCallable = this.typeMapper.mapToCallableMethod(delegateConstructor, false);
        CallableMethod callable = this.typeMapper.mapToCallableMethod(constructorDescriptor, false);
        List<JvmMethodParameterSignature> delegatingParameters = delegateConstructorCallable.getValueParameters();
        List<JvmMethodParameterSignature> parameters2 = callable.getValueParameters();
        ArgumentGenerator argumentGenerator = this.isSameClassConstructor(delegateConstructor) ? ImplementationBodyCodegen.generateThisCallImplicitArguments(iv, codegen, delegateConstructor, delegateConstructorCallable, delegatingParameters, parameters2) : this.generateSuperCallImplicitArguments(iv, codegen, constructorDescriptor, delegateConstructor, delegationConstructorCall, delegateConstructorCallable, delegatingParameters, parameters2);
        codegen.invokeMethodWithArguments(delegateConstructorCallable, delegationConstructorCall, StackValue.none(), codegen.defaultCallGenerator, argumentGenerator);
    }

    private boolean isSameClassConstructor(@Nullable ConstructorDescriptor delegatingConstructor) {
        return delegatingConstructor != null && delegatingConstructor.getContainingDeclaration() == this.descriptor;
    }

    @NotNull
    private ArgumentGenerator generateSuperCallImplicitArguments(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull ConstructorDescriptor superConstructor, @NotNull ResolvedCall<ConstructorDescriptor> superConstructorCall, @NotNull CallableMethod superCallable, @NotNull List<JvmMethodParameterSignature> superParameters, @NotNull List<JvmMethodParameterSignature> parameters2) {
        int offset2 = 1;
        int superIndex = 0;
        for (JvmMethodParameterSignature parameter : parameters2) {
            if (superIndex >= superParameters.size()) break;
            JvmMethodParameterKind superKind = superParameters.get(superIndex).getKind();
            JvmMethodParameterKind kind = parameter.getKind();
            Type type2 = parameter.getAsmType();
            if (superKind == JvmMethodParameterKind.VALUE && kind == JvmMethodParameterKind.SUPER_CALL_PARAM) break;
            if (superKind == JvmMethodParameterKind.OUTER) {
                assert (kind == JvmMethodParameterKind.OUTER || kind == JvmMethodParameterKind.SUPER_CALL_PARAM) : String.format("Non-outer parameter incorrectly mapped to outer for %s: %s vs %s", constructorDescriptor, parameters2, superParameters);
                ClassDescriptor outerForSuper = (ClassDescriptor)superConstructor.getContainingDeclaration().getContainingDeclaration();
                StackValue outer = codegen.generateThisOrOuter(outerForSuper, true, true);
                outer.put(outer.type, codegen.v);
                ++superIndex;
            } else if (kind == JvmMethodParameterKind.SUPER_CALL_PARAM || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL) {
                iv.load(offset2, type2);
                ++superIndex;
            }
            offset2 += type2.getSize();
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor)) {
            List<JvmMethodParameterSignature> superValues = superParameters.subList(superIndex, superParameters.size());
            return new ObjectSuperCallArgumentGenerator(superValues, iv, superConstructor.getValueParameters(), codegen.typeMapper, offset2, superConstructorCall);
        }
        return new CallBasedArgumentGenerator(codegen, codegen.defaultCallGenerator, superConstructor.getValueParameters(), superCallable.getValueParameterTypes());
    }

    @NotNull
    private static ArgumentGenerator generateThisCallImplicitArguments(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor delegatingConstructor, @NotNull CallableMethod delegatingCallable, @NotNull List<JvmMethodParameterSignature> delegatingParameters, @NotNull List<JvmMethodParameterSignature> parameters2) {
        int index2;
        int offset2 = 1;
        for (index2 = 0; index2 < delegatingParameters.size(); ++index2) {
            JvmMethodParameterKind delegatingKind = delegatingParameters.get(index2).getKind();
            if (delegatingKind == JvmMethodParameterKind.VALUE) {
                assert (index2 == parameters2.size() || parameters2.get(index2).getKind() == JvmMethodParameterKind.VALUE) : "Delegating constructor has not enough implicit parameters";
                break;
            }
            assert (index2 < parameters2.size() && parameters2.get(index2).getKind() == delegatingKind) : "Constructors of the same class should have the same set of implicit arguments";
            JvmMethodParameterSignature parameter = parameters2.get(index2);
            iv.load(offset2, parameter.getAsmType());
            offset2 += parameter.getAsmType().getSize();
        }
        assert (index2 == parameters2.size() || parameters2.get(index2).getKind() == JvmMethodParameterKind.VALUE) : "Delegating constructor has not enough parameters";
        return new CallBasedArgumentGenerator(codegen, codegen.defaultCallGenerator, delegatingConstructor.getValueParameters(), delegatingCallable.getValueParameterTypes());
    }

    private void generateEnumEntries() {
        if (this.descriptor.getKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        List enumEntries = CollectionsKt.filterIsInstance(((KtPureClassOrObject)this.element).getDeclarations(), KtEnumEntry.class);
        for (KtEnumEntry enumEntry : enumEntries) {
            ClassDescriptor descriptor2 = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, enumEntry);
            int isDeprecated = KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : 0;
            FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.OtherOrigin(enumEntry, descriptor2), 0x4019 | isDeprecated, descriptor2.getName().asString(), this.classAsmType.getDescriptor(), null, null);
            AnnotationCodegen.forField(fv, this, this.typeMapper).genAnnotations(descriptor2, null);
        }
        this.initializeEnumConstants(enumEntries);
    }

    private void initializeEnumConstants(@NotNull List<KtEnumEntry> enumEntries) {
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen.v;
        Type arrayAsmType = this.typeMapper.mapType(DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        this.v.newField(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass), 4122, "$VALUES", arrayAsmType.getDescriptor(), null, null);
        iv.iconst(enumEntries.size());
        iv.newarray(this.classAsmType);
        if (!enumEntries.isEmpty()) {
            iv.dup();
            int size = enumEntries.size();
            for (int ordinal = 0; ordinal < size; ++ordinal) {
                this.initializeEnumConstant(enumEntries, ordinal);
            }
        }
        iv.putstatic(this.classAsmType.getInternalName(), "$VALUES", arrayAsmType.getDescriptor());
    }

    private void initializeEnumConstant(@NotNull List<KtEnumEntry> enumEntries, int ordinal) {
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen.v;
        KtEnumEntry enumEntry = enumEntries.get(ordinal);
        iv.dup();
        iv.iconst(ordinal);
        ClassDescriptor classDescriptor = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, enumEntry);
        Type implClass = this.typeMapper.mapClass(classDescriptor);
        iv.anew(implClass);
        iv.dup();
        iv.aconst(enumEntry.getName());
        iv.iconst(ordinal);
        List<KtSuperTypeListEntry> delegationSpecifiers = enumEntry.getSuperTypeListEntries();
        ResolvedCall<? extends CallableDescriptor> defaultArgumentsConstructorCall = CallUtilKt.getResolvedCall(enumEntry, this.bindingContext);
        boolean enumEntryHasSubclass = CodegenBinding.enumEntryNeedSubclass(this.bindingContext, classDescriptor);
        if (delegationSpecifiers.size() == 1 && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, enumEntry)) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(delegationSpecifiers.get(0), this.bindingContext);
            CallableMethod method = this.typeMapper.mapToCallableMethod((ConstructorDescriptor)resolvedCall2.getResultingDescriptor(), false);
            codegen.invokeMethodWithArguments(method, resolvedCall2, StackValue.none());
        } else if (defaultArgumentsConstructorCall != null && !enumEntryHasSubclass) {
            codegen.invokeFunction(defaultArgumentsConstructorCall, StackValue.none()).put(Type.VOID_TYPE, iv);
        } else {
            iv.invokespecial(implClass.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        }
        iv.dup();
        iv.putstatic(this.classAsmType.getInternalName(), enumEntry.getName(), this.classAsmType.getDescriptor());
        iv.astore(AsmTypes.OBJECT_TYPE);
    }

    private void generateDelegates(DelegationFieldsInfo delegationFieldsInfo) {
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            DelegationFieldsInfo.Field field;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry) || (field = delegationFieldsInfo.getInfo((KtDelegatedSuperTypeEntry)specifier)) == null) continue;
            this.generateDelegateField(field);
            KtExpression delegateExpression = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression();
            KotlinType delegateExpressionType = delegateExpression != null ? this.bindingContext.getType(delegateExpression) : null;
            ClassDescriptor superClass = this.getSuperClass(specifier);
            if (superClass == null) continue;
            this.generateDelegates(superClass, delegateExpressionType, field);
        }
    }

    private void generateDelegateField(DelegationFieldsInfo.Field fieldInfo) {
        if (!fieldInfo.generateField) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4114, fieldInfo.name, fieldInfo.type.getDescriptor(), null, null);
    }

    private void generateDelegates(@NotNull ClassDescriptor toInterface, @Nullable KotlinType delegateExpressionType, @NotNull DelegationFieldsInfo.Field field) {
        for (Map.Entry<CallableMemberDescriptor, CallableMemberDescriptor> entry : DelegationResolver.Companion.getDelegates(this.descriptor, toInterface, delegateExpressionType).entrySet()) {
            CallableMemberDescriptor member = entry.getKey();
            CallableMemberDescriptor delegateTo = entry.getValue();
            if (member instanceof PropertyDescriptor) {
                this.propertyCodegen.genDelegate((PropertyDescriptor)member, (PropertyDescriptor)delegateTo, field.getStackValue());
                continue;
            }
            if (!(member instanceof FunctionDescriptor)) continue;
            this.functionCodegen.genDelegate((FunctionDescriptor)member, (FunctionDescriptor)delegateTo, field.getStackValue());
        }
    }

    public void addCompanionObjectPropertyToCopy(@NotNull PropertyDescriptor descriptor2, Object defaultValue) {
        if (this.companionObjectPropertiesToCopy == null) {
            this.companionObjectPropertiesToCopy = new ArrayList<PropertyAndDefaultValue>();
        }
        this.companionObjectPropertiesToCopy.add(new PropertyAndDefaultValue(descriptor2, defaultValue));
    }

    @Override
    protected void done() {
        for (Function2<ImplementationBodyCodegen, ClassBuilder, Unit> task : this.additionalTasks) {
            task.invoke((Object)this, (Object)this.v);
        }
        super.done();
    }

    public void addAdditionalTask(Function2<ImplementationBodyCodegen, ClassBuilder, Unit> additionalTask) {
        this.additionalTasks.add(additionalTask);
    }

    static {
        for (JavaToKotlinClassMap.PlatformMutabilityMapping platformMutabilityMapping : JavaToKotlinClassMap.INSTANCE.getMutabilityMappings()) {
            KOTLIN_MARKER_INTERFACES.put(platformMutabilityMapping.getKotlinReadOnly().asSingleFqName(), "kotlin/jvm/internal/markers/KMappedMarker");
            ClassId mutableClassId = platformMutabilityMapping.getKotlinMutable();
            KOTLIN_MARKER_INTERFACES.put(mutableClassId.asSingleFqName(), "kotlin/jvm/internal/markers/K" + mutableClassId.getRelativeClassName().asString().replace("MutableEntry", "Entry").replace(".", "$"));
        }
    }

    private static class PropertyAndDefaultValue {
        public final PropertyDescriptor descriptor;
        public final Object defaultValue;

        public PropertyAndDefaultValue(@NotNull PropertyDescriptor descriptor2, Object defaultValue) {
            this.descriptor = descriptor2;
            this.defaultValue = defaultValue;
        }
    }

    private class DelegationFieldsInfo {
        private final Map<KtDelegatedSuperTypeEntry, Field> fields = new HashMap<KtDelegatedSuperTypeEntry, Field>();

        private DelegationFieldsInfo() {
        }

        @Nullable
        public Field getInfo(KtDelegatedSuperTypeEntry specifier) {
            Field field = this.fields.get(specifier);
            assert (field != null || ImplementationBodyCodegen.this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) : "No field for " + specifier.getText();
            return field;
        }

        private void addField(KtDelegatedSuperTypeEntry specifier, PropertyDescriptor propertyDescriptor) {
            this.fields.put(specifier, new Field(ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor), propertyDescriptor.getName().asString(), false));
        }

        private void addField(KtDelegatedSuperTypeEntry specifier, Type type2, String name) {
            this.fields.put(specifier, new Field(type2, name, true));
        }

        private class Field {
            public final Type type;
            public final String name;
            public final boolean generateField;

            private Field(Type type2, String name, boolean generateField) {
                this.type = type2;
                this.name = name;
                this.generateField = generateField;
            }

            @NotNull
            public StackValue getStackValue() {
                return StackValue.field(this.type, ImplementationBodyCodegen.this.classAsmType, this.name, false, StackValue.none());
            }
        }
    }

    private class DataClassMethodGeneratorImpl
    extends DataClassMethodGenerator {
        DataClassMethodGeneratorImpl(KtClassOrObject klass2, BindingContext bindingContext) {
            super(klass2, bindingContext);
        }

        @Override
        public void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
            MethodContext context = ImplementationBodyCodegen.this.context.intoFunction(function2);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(function2), 1, "equals", "(Ljava/lang/Object;)Z", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            Label eq = new Label();
            Label ne = new Label();
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.load(1, AsmTypes.OBJECT_TYPE);
            iv.ifacmpeq(eq);
            iv.load(1, AsmTypes.OBJECT_TYPE);
            iv.instanceOf(ImplementationBodyCodegen.this.classAsmType);
            iv.ifeq(ne);
            iv.load(1, AsmTypes.OBJECT_TYPE);
            iv.checkcast(ImplementationBodyCodegen.this.classAsmType);
            iv.store(2, AsmTypes.OBJECT_TYPE);
            for (PropertyDescriptor propertyDescriptor : properties2) {
                Type asmType = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor);
                Type thisPropertyType = ImplementationBodyCodegen.this.genPropertyOnStack(iv, context, propertyDescriptor, ImplementationBodyCodegen.this.classAsmType, 0);
                StackValue.coerce(thisPropertyType, asmType, iv);
                Type otherPropertyType = ImplementationBodyCodegen.this.genPropertyOnStack(iv, context, propertyDescriptor, ImplementationBodyCodegen.this.classAsmType, 2);
                StackValue.coerce(otherPropertyType, asmType, iv);
                if (asmType.getSort() == 6) {
                    iv.invokestatic("java/lang/Float", "compare", "(FF)I", false);
                    iv.ifne(ne);
                    continue;
                }
                if (asmType.getSort() == 8) {
                    iv.invokestatic("java/lang/Double", "compare", "(DD)I", false);
                    iv.ifne(ne);
                    continue;
                }
                StackValue value = AsmUtil.genEqualsForExpressionsOnStack(KtTokens.EQEQ, StackValue.onStack(asmType), StackValue.onStack(asmType));
                value.put(Type.BOOLEAN_TYPE, iv);
                iv.ifeq(ne);
            }
            iv.mark(eq);
            iv.iconst(1);
            iv.areturn(Type.INT_TYPE);
            iv.mark(ne);
            iv.iconst(0);
            iv.areturn(Type.INT_TYPE);
            FunctionCodegen.endVisit(mv, "equals", ImplementationBodyCodegen.this.myClass);
        }

        @Override
        public void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
            MethodContext context = ImplementationBodyCodegen.this.context.intoFunction(function2);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(function2), 1, "hashCode", "()I", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : properties2) {
                if (!first) {
                    iv.iconst(31);
                    iv.mul(Type.INT_TYPE);
                }
                Type propertyType = ImplementationBodyCodegen.this.genPropertyOnStack(iv, context, propertyDescriptor, ImplementationBodyCodegen.this.classAsmType, 0);
                Type asmType = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor);
                StackValue.coerce(propertyType, asmType, iv);
                Label ifNull = null;
                if (!AsmUtil.isPrimitive(asmType)) {
                    ifNull = new Label();
                    iv.dup();
                    iv.ifnull(ifNull);
                }
                AsmUtil.genHashCode(mv, iv, asmType, ImplementationBodyCodegen.this.state.getTarget());
                if (ifNull != null) {
                    Label end = new Label();
                    iv.goTo(end);
                    iv.mark(ifNull);
                    iv.pop();
                    iv.iconst(0);
                    iv.mark(end);
                }
                if (first) {
                    first = false;
                    continue;
                }
                iv.add(Type.INT_TYPE);
            }
            mv.visitInsn(172);
            FunctionCodegen.endVisit(mv, "hashCode", ImplementationBodyCodegen.this.myClass);
        }

        @Override
        public void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
            MethodContext context = ImplementationBodyCodegen.this.context.intoFunction(function2);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(function2), 1, "toString", "()Ljava/lang/String;", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            AsmUtil.genStringBuilderConstructor(iv);
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : properties2) {
                if (first) {
                    iv.aconst(ImplementationBodyCodegen.this.descriptor.getName() + "(" + propertyDescriptor.getName().asString() + "=");
                    first = false;
                } else {
                    iv.aconst(", " + propertyDescriptor.getName().asString() + "=");
                }
                AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE);
                Type type2 = ImplementationBodyCodegen.this.genPropertyOnStack(iv, context, propertyDescriptor, ImplementationBodyCodegen.this.classAsmType, 0);
                if (type2.getSort() == 9) {
                    Type elementType = AsmUtil.correctElementType(type2);
                    if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                        iv.invokestatic("java/util/Arrays", "toString", "([Ljava/lang/Object;)Ljava/lang/String;", false);
                        type2 = AsmTypes.JAVA_STRING_TYPE;
                    } else if (elementType.getSort() != 2) {
                        iv.invokestatic("java/util/Arrays", "toString", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
                        type2 = AsmTypes.JAVA_STRING_TYPE;
                    }
                }
                AsmUtil.genInvokeAppendMethod(iv, type2);
            }
            iv.aconst(")");
            AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE);
            iv.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            iv.areturn(AsmTypes.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit(mv, "toString", ImplementationBodyCodegen.this.myClass);
        }

        @Override
        public void generateComponentFunction(@NotNull FunctionDescriptor function2, final @NotNull ValueParameterDescriptor parameter) {
            PsiElement originalElement = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(originalElement, function2), function2, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                    Type componentType = signature.getReturnType();
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    if (!componentType.equals(Type.VOID_TYPE)) {
                        PropertyDescriptor property = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, DescriptorToSourceUtils.descriptorToDeclaration(parameter));
                        assert (property != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                        Type propertyType = ImplementationBodyCodegen.this.genPropertyOnStack(iv, context, property, ImplementationBodyCodegen.this.classAsmType, 0);
                        StackValue.coerce(propertyType, componentType, iv);
                    }
                    iv.areturn(componentType);
                }

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return false;
                }
            });
        }

        @Override
        public void generateCopyFunction(final @NotNull FunctionDescriptor function2, @NotNull List<? extends KtParameter> constructorParameters) {
            final Type thisDescriptorType = ImplementationBodyCodegen.this.typeMapper.mapType(ImplementationBodyCodegen.this.descriptor);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOriginFromPure(ImplementationBodyCodegen.this.myClass, function2), function2, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    iv.anew(thisDescriptorType);
                    iv.dup();
                    ConstructorDescriptor constructor = ImplementationBodyCodegen.getPrimaryConstructorOfDataClass(ImplementationBodyCodegen.this.descriptor);
                    assert (function2.getValueParameters().size() == constructor.getValueParameters().size()) : "Number of parameters of copy function and constructor are different. Copy: " + function2.getValueParameters().size() + ", constructor: " + constructor.getValueParameters().size();
                    MutableClosure closure = ImplementationBodyCodegen.this.context.closure;
                    if (closure != null) {
                        this.pushCapturedFieldsOnStack(iv, closure);
                    }
                    int parameterIndex = 1;
                    for (ValueParameterDescriptor parameterDescriptor : function2.getValueParameters()) {
                        Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(parameterDescriptor.getType());
                        iv.load(parameterIndex, type2);
                        parameterIndex += type2.getSize();
                    }
                    Method constructorAsmMethod = ImplementationBodyCodegen.this.typeMapper.mapAsmMethod(constructor);
                    iv.invokespecial(thisDescriptorType.getInternalName(), "<init>", constructorAsmMethod.getDescriptor(), false);
                    iv.areturn(thisDescriptorType);
                }

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return false;
                }

                private void pushCapturedFieldsOnStack(InstructionAdapter iv, MutableClosure closure) {
                    KotlinType captureReceiver;
                    ClassDescriptor captureThis = closure.getCaptureThis();
                    if (captureThis != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(captureThis);
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), "this$0", type2.getDescriptor());
                    }
                    if ((captureReceiver = closure.getCaptureReceiverType()) != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type3 = ImplementationBodyCodegen.this.typeMapper.mapType(captureReceiver);
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), "receiver$0", type3.getDescriptor());
                    }
                    for (Map.Entry<DeclarationDescriptor, EnclosedValueDescriptor> entry : closure.getCaptureVariables().entrySet()) {
                        DeclarationDescriptor declarationDescriptor = entry.getKey();
                        EnclosedValueDescriptor enclosedValueDescriptor = entry.getValue();
                        StackValue capturedValue = enclosedValueDescriptor.getInstanceValue();
                        Type sharedVarType = ImplementationBodyCodegen.this.typeMapper.getSharedVarType(declarationDescriptor);
                        if (sharedVarType == null) {
                            sharedVarType = ImplementationBodyCodegen.this.typeMapper.mapType((VariableDescriptor)declarationDescriptor);
                        }
                        capturedValue.put(sharedVarType, iv);
                    }
                }
            });
            ImplementationBodyCodegen.this.functionCodegen.generateDefaultIfNeeded(ImplementationBodyCodegen.this.context.intoFunction(function2), function2, OwnerKind.IMPLEMENTATION, (valueParameter, codegen) -> {
                assert (((ClassDescriptor)function2.getContainingDeclaration()).isData()) : "Function container must have [data] modifier: " + function2;
                PropertyDescriptor property = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter);
                assert (property != null) : "Copy function doesn't correspond to any property: " + function2;
                return codegen.intermediateValueForProperty(property, false, null, StackValue.LOCAL_0);
            }, null);
        }
    }
}

