/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.kernel.KernelInfo;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.SparkMagicCommandOptions;
import com.twosigma.beakerx.widget.SparkEngine;
import com.twosigma.beakerx.widget.SparkEngineConf;
import java.util.HashMap;
import org.apache.spark.sql.SparkSession;

public class YarnSparkOptionCommand
implements SparkMagicCommandOptions.SparkOptionCommand {
    private static final String PROXY_URI_BASES = "spark.org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter.param.PROXY_URI_BASES";

    @Override
    public void run(SparkEngine sparkEngine, Message parent) {
        SparkEngineConf conf = new SparkEngineConf();
        conf.setMaster("yarn");
        conf.setExecutorCores("4");
        conf.setExecutorMemory("1g");
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("spark.submit.deployMode", "client");
        configs.put("spark.yarn.jars", KernelInfo.mvnRepoPath() + "/*");
        conf.setConfigs(configs);
        sparkEngine.additionalConf(conf);
        sparkEngine.sparkUiWebUrlFactory(() -> {
            SparkSession sparkSession = sparkEngine.getOrCreate();
            if (sparkSession != null && sparkSession.sparkContext().getConf().contains(PROXY_URI_BASES)) {
                return sparkEngine.getOrCreate().sparkContext().getConf().get(PROXY_URI_BASES);
            }
            return "";
        });
        sparkEngine.stageLinkFactory(stageId -> {
            String url = sparkEngine.getSparkUiWebUrl();
            return url + "/stages/stage/?id=" + stageId + "&attempt=0";
        });
        sparkEngine.jobLinkFactory(jobId -> {
            String url = sparkEngine.getSparkUiWebUrl();
            return url + "/jobs/job/?id=" + jobId;
        });
    }

    @Override
    public String getName() {
        return "yarn";
    }
}

