/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.Context;
import io.javalin.LogLevel;
import io.javalin.core.HandlerEntry;
import io.javalin.core.HandlerType;
import io.javalin.core.PathMatcher;
import io.javalin.core.util.LogUtil$WhenMappings;
import io.javalin.embeddedserver.CachedResponseWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lio/javalin/core/util/LogUtil;", "", "()V", "logRequestAndResponse", "", "ctx", "Lio/javalin/Context;", "logLevel", "Lio/javalin/LogLevel;", "matcher", "Lio/javalin/core/PathMatcher;", "log", "Lorg/slf4j/Logger;", "gzipped", "", "javalin"})
public final class LogUtil {
    public static final LogUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void logRequestAndResponse(@NotNull Context ctx, @NotNull LogLevel logLevel, @NotNull PathMatcher matcher, @NotNull Logger log, boolean gzipped) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        if (logLevel == LogLevel.OFF) {
            return;
        }
        HandlerType type = HandlerType.Companion.fromServletRequest(ctx.request());
        String requestUri = ctx.request().getRequestURI();
        long startTime = ((Number)ctx.attribute("javalin-request-log-start-time")).longValue();
        Formatter executionTime = new Formatter(Locale.US).format("%.2f", Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f));
        Context $receiver = ctx;
        String string = $receiver.response().getContentType();
        if (string == null) {
            string = "content-type-not-set";
        }
        String resContentType = string;
        switch (LogUtil$WhenMappings.$EnumSwitchMapping$0[logLevel.ordinal()]) {
            case 1: {
                log.info("" + $receiver.method() + " -> " + $receiver.status() + " (" + executionTime + " ms)");
                break;
            }
            case 2: {
                log.info("" + $receiver.method() + ' ' + $receiver.path() + " -> " + $receiver.status() + " [" + resContentType + "] (took " + executionTime + " ms)");
                break;
            }
            case 3: {
                boolean bl;
                String string2;
                Object[] v;
                Object object;
                Map.Entry $$_$_v;
                Map map;
                Object k;
                Object k2;
                Map.Entry it$iv$iv;
                Map map2;
                Map<String, String[]> $receiver$iv$iv;
                Map<String, String[]> $receiver$iv;
                CharSequence charSequence;
                Collection collection;
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                String string3 = requestUri;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"requestUri");
                Iterable iterable = $receiver$iv2 = (Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)matcher.findEntries(HandlerType.BEFORE, string3), (Iterable)matcher.findEntries(type, requestUri)), (Iterable)matcher.findEntries(HandlerType.AFTER, requestUri));
                Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it;
                    HandlerEntry handlerEntry = (HandlerEntry)item$iv$iv;
                    collection = destination$iv$iv;
                    charSequence = it.getType().name() + "=" + it.getPath();
                    collection.add(charSequence);
                }
                List allMatching = (List)destination$iv$iv;
                HttpServletResponse httpServletResponse = $receiver.response();
                if (httpServletResponse == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.javalin.embeddedserver.CachedResponseWrapper");
                }
                String resBody = ((CachedResponseWrapper)httpServletResponse).getCopy();
                Collection collection2 = $receiver.response().getHeaderNames();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"response().headerNames");
                Map resHeaders2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection2), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends String>>($receiver){
                    final /* synthetic */ Context receiver$0;

                    @NotNull
                    public final Pair<String, String> invoke(String it) {
                        return TuplesKt.to((Object)it, (Object)this.receiver$0.response().getHeader(it));
                    }
                    {
                        this.receiver$0 = context;
                        super(1);
                    }
                })));
                destination$iv$iv = $receiver.queryParamMap();
                charSequence = new StringBuilder().append("JAVALIN EXTENSIVE REQUEST LOG (this clones the response, which is an expensive operation):\n                        |Request: ").append($receiver.method()).append(" [").append($receiver.path()).append("]\n                        |    Matching endpoint-handlers: ").append(allMatching).append("\n                        |    Headers: ").append($receiver.headerMap()).append("\n                        |    Cookies: ").append($receiver.cookieMap()).append("\n                        |    Body: ").append(ctx.isMultipart() ? "Multipart data ..." : $receiver.body()).append("\n                        |    QueryString: ").append($receiver.queryString()).append("\n                        |    QueryParams: ");
                collection = log;
                Iterator iterator = $receiver$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
                Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    Map.Entry $i$f$map = (Map.Entry)element$iv$iv$iv;
                    map2 = destination$iv$iv2;
                    k2 = it$iv$iv.getKey();
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    k = k2;
                    map = map2;
                    object = $$_$_v;
                    v = (String[])object.getValue();
                    object = v;
                    Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.toString((Object[])object), (String)"java.util.Arrays.toString(this)");
                    map.put(k, string2);
                }
                map = destination$iv$iv2;
                $receiver$iv = $receiver.formParamMap();
                charSequence = ((StringBuilder)charSequence).append(map).append("\n                        |    FormParams: ");
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
                $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    it$iv$iv = (Map.Entry)element$iv$iv$iv;
                    map2 = destination$iv$iv2;
                    k2 = it$iv$iv.getKey();
                    $$_$_v = (Map.Entry)element$iv$iv$iv;
                    k = k2;
                    map = map2;
                    object = $$_$_v;
                    v = (String[])object.getValue();
                    object = v;
                    Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.toString((Object[])object), (String)"java.util.Arrays.toString(this)");
                    map.put(k, string2);
                }
                map = destination$iv$iv2;
                StringBuilder stringBuilder = ((StringBuilder)charSequence).append(map).append("\n                        |Response: [").append($receiver.status()).append("], execution took ").append(executionTime).append(" ms\n                        |    Headers: ").append(resHeaders2).append("\n                        |    Body: ").append(resBody.length()).append(" bytes (starts on next line)\n                        |");
                String string4 = resBody;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"resBody");
                CharSequence charSequence2 = string4;
                charSequence = stringBuilder;
                boolean bl2 = bl = charSequence2.length() > 0;
                collection.info(StringsKt.trimMargin$default((String)((StringBuilder)charSequence).append(bl ? (gzipped ? "dynamically gzipped response ..." : resBody) : "No body was set").append("\n                        |----------------------------------------------------------------------------------").toString(), null, (int)1, null));
            }
        }
    }

    private LogUtil() {
    }

    static {
        LogUtil logUtil;
        INSTANCE = logUtil = new LogUtil();
    }
}

