/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteNode;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AutocompleteNodeStatic
extends AutocompleteNode {
    public AutocompleteNodeStatic(String name, List<AutocompleteNode> children) {
        super(name, children);
    }

    @Override
    public Optional<AutocompleteResult> matchToTheWord(String text, LinkedList<String> parts, String last) {
        if (parts.isEmpty()) {
            List<String> matches = this.findMatches(this.getChildren(), last);
            if (!matches.isEmpty()) {
                return Optional.of(new AutocompleteResult(matches, text.length() - last.length()));
            }
            return Optional.empty();
        }
        Optional<AutocompleteNode> node = this.findNode(parts);
        if (node.isPresent()) {
            return node.get().matchToTheWord(text, parts, last);
        }
        return Optional.empty();
    }

    @Override
    public Optional<AutocompleteResult> findNextWord(String text, LinkedList<String> parts) {
        if (parts.isEmpty()) {
            List<String> matches = this.getChildren().stream().map(x -> x.getName()).collect(Collectors.toList());
            if (!matches.isEmpty()) {
                return Optional.of(new AutocompleteResult(matches, text.length()));
            }
            return Optional.empty();
        }
        Optional<AutocompleteNode> node = this.findNode(parts);
        if (node.isPresent()) {
            return node.get().findNextWord(text, parts);
        }
        return Optional.empty();
    }

    private List<String> findMatches(Collection<AutocompleteNode> nodes, String txt) {
        return nodes.stream().filter(x -> x.getName().startsWith(txt)).filter(x -> !x.getName().equals(txt)).map(x -> x.getName()).collect(Collectors.toList());
    }

    private Optional<AutocompleteNode> findNode(LinkedList<String> parts) {
        String first = parts.removeFirst();
        return this.getChildren().stream().filter(x -> x.getName().equals(first)).findFirst();
    }
}

