/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.util.Preconditions;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PathToJar {
    private URL url;
    private String canonicalPath;

    public PathToJar(String path) {
        Preconditions.checkNotNull(path);
        File file = this.getFile(path);
        try {
            this.canonicalPath = file.getCanonicalPath();
            this.url = Paths.get(this.canonicalPath, new String[0]).toUri().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPath() {
        return this.canonicalPath;
    }

    public URL getUrl() {
        return this.url;
    }

    private File getFile(String path) {
        File file = Paths.get(path, new String[0]).toFile();
        if (!file.exists()) {
            throw new RuntimeException("Path does not exist: " + path);
        }
        return file;
    }

    private void checkNotWhitespaces(String path) {
        if (StringUtils.containsWhitespace((CharSequence)path)) {
            throw new RuntimeException("Can not create path with whitespace.");
        }
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

