/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.object;

import com.twosigma.beakerx.jvm.object.Configuration;
import com.twosigma.beakerx.jvm.object.ConfigurationFactory;
import com.twosigma.beakerx.jvm.object.ConsoleOutput;
import com.twosigma.beakerx.jvm.object.ProgressReporting;
import com.twosigma.beakerx.jvm.threads.BeakerInputHandler;
import com.twosigma.beakerx.jvm.threads.BeakerOutputHandler;
import com.twosigma.beakerx.jvm.threads.BeakerStdInOutErrHandler;
import com.twosigma.beakerx.kernel.threads.ResultSender;
import com.twosigma.beakerx.message.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SimpleEvaluationObject {
    private Message jupyterMessage;
    private int executionCount;
    private EvaluationStatus status;
    private final String expression;
    private Object payload;
    private ResultSender resultSender;
    private BeakerOutputHandler stdout;
    private BeakerOutputHandler stderr;
    private BeakerInputHandler stdin;
    private Queue<ConsoleOutput> consoleOutput = new ConcurrentLinkedQueue<ConsoleOutput>();
    private ProgressReporting progressReporting;
    private boolean showResult = true;
    private static final int OUTPUT_QUEUE_SIZE = 20;
    private static final int MAX_LINE_LENGTH = 240;
    private int outputdataCount = 0;
    private String buildingout = "";
    private List<Object> outputdata = new ArrayList<Object>();
    private String buildingerr = "";

    public SimpleEvaluationObject(String e, ConfigurationFactory factory) {
        this.expression = e;
        this.status = EvaluationStatus.QUEUED;
        Configuration config = factory.create(this);
        this.stdout = config.getStdout();
        this.stderr = config.getStderr();
        this.resultSender = config.getResultSender();
        this.stdin = config.getStdin();
        this.jupyterMessage = config.getMessage();
        this.executionCount = config.getExecutionCount();
    }

    public boolean isShowResult() {
        return this.showResult;
    }

    public void started() {
        this.status = EvaluationStatus.RUNNING;
        this.resultSender.update(this);
    }

    public void finished(Object r) {
        this.clrOutputHandler();
        this.status = EvaluationStatus.FINISHED;
        this.payload = r;
        this.resultSender.update(this);
    }

    public void error(Object r) {
        this.clrOutputHandler();
        this.status = EvaluationStatus.ERROR;
        this.payload = r;
        this.resultSender.update(this);
    }

    public void update(Object r) {
        this.status = EvaluationStatus.RUNNING;
        this.payload = r;
        this.resultSender.update(this);
    }

    public String getExpression() {
        return this.expression;
    }

    public EvaluationStatus getStatus() {
        return this.status;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void structuredUpdate(String message, int progress) {
        if (this.progressReporting == null) {
            this.progressReporting = new ProgressReporting();
        }
        this.progressReporting.structuredUpdate(message, progress);
    }

    public void noResult() {
        this.showResult = false;
    }

    public BeakerOutputHandler getStdOutputHandler() {
        return this.stdout;
    }

    public BeakerOutputHandler getStdErrorHandler() {
        return this.stderr;
    }

    public void setOutputHandler() {
        BeakerStdInOutErrHandler.setOutputHandler(this.getStdOutputHandler(), this.getStdErrorHandler(), this.getStdinHandler());
    }

    private BeakerInputHandler getStdinHandler() {
        return this.stdin;
    }

    public void clrOutputHandler() {
        this.closeProgressUpdater();
        BeakerStdInOutErrHandler.clrOutputHandler();
    }

    private void closeProgressUpdater() {
        if (this.progressReporting != null) {
            this.progressReporting.close();
            this.progressReporting = null;
        }
    }

    public Message getJupyterMessage() {
        return this.jupyterMessage;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public Queue<ConsoleOutput> getConsoleOutput() {
        return this.consoleOutput;
    }

    public String toString() {
        return this.status.toString() + " Console messages size = " + this.consoleOutput.size();
    }

    public List<Object> getOutputdata() {
        return this.outputdata;
    }

    public void appendOutput(String s) {
        if (this.getSize() > 20) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.getSize() > 20) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.doAppendOutput(s);
    }

    private int getSize() {
        return this.outputdataCount;
    }

    private void doAppendOutput(String s) {
        this.buildingout = this.buildingout + s;
        String add = null;
        if (s.contains("\n")) {
            if (s.endsWith("\n")) {
                add = this.buildingout;
                this.buildingout = "";
            } else {
                add = this.buildingout.substring(0, this.buildingout.lastIndexOf(10) + 1);
                this.buildingout = this.buildingout.substring(this.buildingout.lastIndexOf(10) + 1);
            }
        }
        if (this.buildingout.length() > 240) {
            add = this.buildingout;
            this.buildingout = "";
        }
        if (add != null) {
            String[] v;
            for (String sv : v = add.split("\n")) {
                while (sv.length() > 240) {
                    String t = sv.substring(0, 240);
                    sv = sv.substring(240);
                    if (this.outputdata.size() == 0 || !(this.outputdata.get(this.outputdata.size() - 1) instanceof EvaluationStdOutput)) {
                        this.outputdata.add(new EvaluationStdOutput(t + "\n"));
                    } else {
                        EvaluationStdOutput st = (EvaluationStdOutput)this.outputdata.get(this.outputdata.size() - 1);
                        st.payload = st.payload + t + "\n";
                    }
                    ++this.outputdataCount;
                }
                if (this.outputdata.size() == 0 || !(this.outputdata.get(this.outputdata.size() - 1) instanceof EvaluationStdOutput)) {
                    this.outputdata.add(new EvaluationStdOutput(sv + "\n"));
                } else {
                    EvaluationStdOutput st = (EvaluationStdOutput)this.outputdata.get(this.outputdata.size() - 1);
                    st.payload = st.payload + sv + "\n";
                }
                ++this.outputdataCount;
            }
            this.resultSender.update(this);
        }
    }

    public void appendError(String s) {
        if (this.getSize() > 20) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.getSize() > 20) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.doAppendError(s);
    }

    private void doAppendError(String s) {
        this.buildingerr = this.buildingerr + s;
        String add = null;
        if (s.contains("\n")) {
            if (s.endsWith("\n")) {
                add = this.buildingerr;
                this.buildingerr = "";
            } else {
                add = this.buildingerr.substring(0, this.buildingerr.lastIndexOf(10) + 1);
                this.buildingerr = this.buildingerr.substring(this.buildingerr.lastIndexOf(10) + 1);
            }
        }
        if (this.buildingerr.length() > 240) {
            add = this.buildingerr;
            this.buildingerr = "";
        }
        if (add != null) {
            String[] v;
            if (add.contains("org.antlr.v4.runtime.misc.NullUsageProcessor") && add.contains("'RELEASE_6'") || add.contains("JavaSourceCompilerImpl compile")) {
                v = add.split("\n");
                add = "";
                for (String s2 : v) {
                    if (s2.contains("org.antlr.v4.runtime.misc.NullUsageProcessor") || s2.contains("JavaSourceCompilerImpl compile")) continue;
                    add = add + s2 + "\n";
                }
            }
            for (String sv : v = add.split("\n")) {
                while (sv.length() > 240) {
                    String t = sv.substring(0, 240);
                    sv = sv.substring(240);
                    if (this.outputdata.size() == 0 || !(this.outputdata.get(this.outputdata.size() - 1) instanceof EvaluationStdError)) {
                        this.outputdata.add(new EvaluationStdError(t + "\n"));
                    } else {
                        EvaluationStdError st = (EvaluationStdError)this.outputdata.get(this.outputdata.size() - 1);
                        st.payload = st.payload + t + "\n";
                    }
                    ++this.outputdataCount;
                }
                if (this.outputdata.size() == 0 || !(this.outputdata.get(this.outputdata.size() - 1) instanceof EvaluationStdError)) {
                    this.outputdata.add(new EvaluationStdError(sv + "\n"));
                } else {
                    EvaluationStdError st = (EvaluationStdError)this.outputdata.get(this.outputdata.size() - 1);
                    st.payload = st.payload + sv + "\n";
                }
                ++this.outputdataCount;
            }
            this.resultSender.update(this);
        }
    }

    public class EvaluationStdError {
        public String payload;

        public EvaluationStdError(String s) {
            this.payload = s;
        }
    }

    public class EvaluationStdOutput {
        public String payload;

        public EvaluationStdOutput(String s) {
            this.payload = s;
        }
    }

    public static class SimpleOutputHandler
    implements BeakerOutputHandler {
        private boolean error;
        private ResultSender executionResultSender;
        private SimpleEvaluationObject seo;

        public SimpleOutputHandler(boolean error, ResultSender executionResultSender, SimpleEvaluationObject seo) {
            this.error = error;
            this.executionResultSender = executionResultSender;
            this.seo = seo;
        }

        @Override
        public void write(String b) {
            this.seo.consoleOutput.add(new ConsoleOutput(this.error, b));
            this.executionResultSender.update(this.seo);
        }
    }

    public static enum EvaluationStatus {
        QUEUED,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

