/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.object;

import com.twosigma.beakerx.jvm.threads.BeakerInputHandler;
import com.twosigma.beakerx.jvm.threads.BeakerOutputHandler;
import com.twosigma.beakerx.kernel.threads.ResultSender;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.util.Preconditions;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Configuration {
    private final Message message;
    private final int executionCount;
    private final BeakerInputHandler stdin;
    private final ResultSender resultSender;
    private final BeakerOutputHandler stdout;
    private final BeakerOutputHandler stderr;

    public Configuration(BeakerInputHandler stdin, BeakerOutputHandler stdout, BeakerOutputHandler stderr, ResultSender resultSender, Message message, int executionCount) {
        this.stdin = Preconditions.checkNotNull(stdin);
        this.resultSender = Preconditions.checkNotNull(resultSender);
        this.stdout = Preconditions.checkNotNull(stdout);
        this.stderr = Preconditions.checkNotNull(stderr);
        this.message = Preconditions.checkNotNull(message);
        this.executionCount = executionCount;
    }

    public BeakerOutputHandler getStdout() {
        return this.stdout;
    }

    public BeakerOutputHandler getStderr() {
        return this.stderr;
    }

    public Message getMessage() {
        return this.message;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public BeakerInputHandler getStdin() {
        return this.stdin;
    }

    public ResultSender getResultSender() {
        return this.resultSender;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

