/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.MagicCommandAutocompletePatterns;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.groovy.autocomplete.GroovyAutocomplete;
import com.twosigma.beakerx.groovy.autocomplete.GroovyClasspathScanner;
import com.twosigma.beakerx.groovy.evaluator.EnvVariablesFilter;
import com.twosigma.beakerx.groovy.evaluator.GroovyClassLoaderFactory;
import com.twosigma.beakerx.groovy.evaluator.GroovyWorkerThread;
import com.twosigma.beakerx.jvm.classloader.BeakerXUrlClassLoader;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ExecutionOptions;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import com.twosigma.beakerx.kernel.PathToJar;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.util.concurrent.Executors;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyEvaluator
extends BaseEvaluator {
    private GroovyClassLoader groovyClassLoader;
    private Binding scriptBinding = null;
    private ImportCustomizer icz;
    private BeakerXUrlClassLoader beakerxUrlClassLoader;
    private GroovyAutocomplete gac;

    public GroovyEvaluator(String id, String sId, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient, MagicCommandAutocompletePatterns autocompletePatterns) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("groovy"), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters, beakerxClient, autocompletePatterns);
    }

    public GroovyEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient, MagicCommandAutocompletePatterns autocompletePatterns) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters, beakerxClient, autocompletePatterns);
        this.reloadClassloader();
        this.gac = this.createGroovyAutocomplete(new GroovyClasspathScanner(), this.groovyClassLoader, this.imports, autocompletePatterns);
        this.outDir = EnvVariablesFilter.envVariablesFilter(this.outDir, System.getenv());
    }

    public TryResult evaluate(SimpleEvaluationObject seo, String code, ExecutionOptions executionOptions) {
        return this.evaluate(seo, new GroovyWorkerThread(this, new JobDescriptor(code, seo, executionOptions)));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.gac.find(code, caretPosition);
    }

    protected void doResetEnvironment() {
        String cpp = this.createClasspath(this.classPath);
        this.reloadClassloader();
        this.gac = this.createGroovyAutocomplete(new GroovyClasspathScanner(cpp), this.groovyClassLoader, this.imports, this.autocompletePatterns);
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void exit() {
        super.exit();
        this.killAllThreads();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    protected void addJarToClassLoader(PathToJar pathToJar) {
        this.beakerxUrlClassLoader.addJar(pathToJar);
    }

    protected void addImportToClassLoader(ImportPath anImport) {
        GroovyClassLoaderFactory.addImportPathToImportCustomizer(this.icz, anImport);
    }

    private GroovyAutocomplete createGroovyAutocomplete(GroovyClasspathScanner c, GroovyClassLoader groovyClassLoader, Imports imports, MagicCommandAutocompletePatterns autocompletePatterns) {
        return new GroovyAutocomplete(c, groovyClassLoader, imports, autocompletePatterns);
    }

    private String createClasspath(Classpath classPath) {
        StringBuilder cppBuilder = new StringBuilder();
        for (String pt : classPath.getPathsAsStrings()) {
            cppBuilder.append(pt);
            cppBuilder.append(File.pathSeparator);
        }
        String cpp = cppBuilder.toString();
        cpp = cpp + File.pathSeparator;
        cpp = cpp + System.getProperty("java.class.path");
        return cpp;
    }

    public ClassLoader getClassLoader() {
        return this.groovyClassLoader;
    }

    private void reloadClassloader() {
        this.beakerxUrlClassLoader = GroovyClassLoaderFactory.newParentClassLoader(this.getClasspath());
        this.icz = new ImportCustomizer();
        this.groovyClassLoader = GroovyClassLoaderFactory.newEvaluator(this.getImports(), this.getClasspath(), this.getOutDir(), this.icz, (ClassLoader)this.beakerxUrlClassLoader);
        this.scriptBinding = new Binding();
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.groovyClassLoader;
    }

    public Binding getScriptBinding() {
        return this.scriptBinding;
    }
}

