/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.inspect;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CodeParsingTool {
    private CodeParsingTool() {
    }

    public static int getCaretPositionInLine(String code, int caretPosition) {
        int begOfLine = code.substring(0, caretPosition).lastIndexOf(System.lineSeparator());
        return caretPosition - begOfLine - 1;
    }

    public static String getLineWithCursor(String code, int caretPosition) {
        int begOfLine = CodeParsingTool.lastIndexOrZero(code.substring(0, caretPosition), System.lineSeparator());
        int endOfLine = CodeParsingTool.firstIndexOrLength(code.substring(caretPosition), System.lineSeparator());
        return code.substring(begOfLine, endOfLine + caretPosition).trim();
    }

    private static int lastIndexOrZero(String string, String pattern) {
        return string.lastIndexOf(pattern) == -1 ? 0 : string.lastIndexOf(pattern);
    }

    private static int firstIndexOrLength(String string, String pattern) {
        return string.indexOf(pattern) == -1 ? string.length() : string.indexOf(pattern);
    }

    public static String getSelectedMethodName(String code, int caretPosition) {
        int pos = CodeParsingTool.getCaretPositionInLine(code, caretPosition);
        String line = CodeParsingTool.getLineWithCursor(code, caretPosition);
        int begOfMethod = CodeParsingTool.lastIndexOrZero(line.substring(0, pos), ".");
        int bracketStart = CodeParsingTool.firstIndexOrLength(line.substring(begOfMethod), "(");
        if (begOfMethod == 0) {
            return null;
        }
        return line.substring(begOfMethod + 1, begOfMethod + bracketStart);
    }

    public static String getClassName(String code, int caretPosition, String methodName) {
        String inspectObject = CodeParsingTool.getInspectObject(code, caretPosition, methodName);
        return CodeParsingTool.getClassOfInspectObject(code, inspectObject);
    }

    public static String getInspectObject(String code, int caretPosition, String methodName) {
        String line = CodeParsingTool.getLineWithCursor(code, caretPosition);
        if (methodName == null || line.indexOf(methodName) < 1) {
            return CodeParsingTool.getClassInspectObject(code, caretPosition).trim();
        }
        return CodeParsingTool.getMethodInspectObject(methodName, line).trim();
    }

    private static String getMethodInspectObject(String methodName, String line) {
        String lineToMethodName = line.substring(0, line.indexOf(methodName) - 1);
        String lineToClassName = CodeParsingTool.removeLastBracket(lineToMethodName);
        return lineToClassName.substring(CodeParsingTool.lastIndexOrZero(lineToClassName, " ")).split("\\.")[0].trim();
    }

    private static String getClassInspectObject(String code, int caretPosition) {
        int caretPos = CodeParsingTool.getCaretPositionInLine(code, caretPosition);
        String line = CodeParsingTool.getLineWithCursor(code, caretPosition);
        int begOfClass = CodeParsingTool.lastIndexOrZero(line.substring(0, caretPos), " ");
        int endOfClass = line.length();
        for (char endChar : Arrays.asList(Character.valueOf(' '), Character.valueOf('('), Character.valueOf('.'))) {
            int index = line.substring(caretPos).indexOf(endChar);
            if (index == -1 || index + caretPos >= endOfClass) continue;
            endOfClass = index + caretPos;
        }
        return line.substring(begOfClass, endOfClass);
    }

    public static String getClassOfInspectObject(String code, String inspectObject) {
        Optional<String> inspect = CodeParsingTool.getLinesWithPattern(code, inspectObject).stream().map(line -> line.substring(line.indexOf(inspectObject))).filter(line -> line.indexOf("= new ") != -1 || line.indexOf("=new ") != -1).map(line -> line.substring(line.indexOf("new ") + 4)).filter(line -> line.indexOf("(") != -1).map(line -> line.substring(0, line.indexOf("("))).findFirst();
        return inspect.orElse(inspectObject);
    }

    private static String removeLastBracket(String lineToMethodName) {
        int lastBracketPos = lineToMethodName.length();
        int i = lastBracketPos - 1;
        if (lineToMethodName.charAt(i) == ')') {
            int counter = 0;
            while (i > 0) {
                char character = lineToMethodName.charAt(i);
                if (character == ')') {
                    ++counter;
                } else if (character == '(') {
                    --counter;
                }
                if (counter == 0) {
                    lastBracketPos = i;
                    break;
                }
                --i;
            }
        }
        return lineToMethodName.substring(0, lastBracketPos);
    }

    private static List<String> getLinesWithPattern(String code, String pattern) {
        return Arrays.stream(code.split(System.lineSeparator())).filter(line -> line.trim().contains(pattern)).collect(Collectors.toList());
    }
}

