/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.kernel.BeakerXJson;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SparkUiDefaultsImpl
implements SparkUiDefaults {
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String PROPERTIES = "properties";
    public static final String SPARK_OPTIONS = "spark_options";
    public static final String BEAKERX = "beakerx";
    private static final String SPARK_PROFILES = "profiles";
    private static final String CURRENT_PROFILE = "current_profile";
    private Map<String, Object> defaults = new HashMap<String, Object>();
    private List<Map<String, Object>> profiles = new ArrayList<Map<String, Object>>();
    private BeakerXJson beakerXJson;
    private String currentProfile = "";

    public SparkUiDefaultsImpl(BeakerXJson beakerXJson) {
        this.beakerXJson = beakerXJson;
    }

    @Override
    public void saveSparkConf(List<Map<String, Object>> profiles) {
        Map map = this.beakerXJson.beakerxJsonAsMap();
        Map sparkOptions = ((Map)map.get(BEAKERX)).getOrDefault(SPARK_OPTIONS, new HashMap());
        sparkOptions.put(SPARK_PROFILES, profiles == null ? new ArrayList<Map<String, Object>>() : profiles);
        ((Map)map.get(BEAKERX)).put(SPARK_OPTIONS, sparkOptions);
        this.beakerXJson.save(map);
        this.profiles = profiles;
    }

    @Override
    public void loadDefaults() {
        this.loadProfiles();
        this.defaults = this.getProfileByName(this.currentProfile);
    }

    @Override
    public List<Map<String, Object>> getProfiles() {
        return this.profiles;
    }

    @Override
    public Map<String, Object> getProfileByName(String name) {
        HashMap profile = new HashMap();
        return this.profiles.stream().filter(x -> x.get(NAME).equals(name)).findFirst().orElse(profile);
    }

    @Override
    public void loadProfiles() {
        Map beakerxJsonAsMap = this.beakerXJson.beakerxJsonAsMap();
        Map sparkOptions = ((Map)beakerxJsonAsMap.get(BEAKERX)).getOrDefault(SPARK_OPTIONS, new HashMap());
        List profiles = (List)sparkOptions.get(SPARK_PROFILES);
        this.currentProfile = sparkOptions.getOrDefault(CURRENT_PROFILE, "");
        if (profiles == null) {
            HashMap<String, Object> defaultProfile = new HashMap<String, Object>();
            defaultProfile.put(NAME, "");
            defaultProfile.put("spark.master", "local[*]");
            defaultProfile.put("spark.executor.cores", "10");
            defaultProfile.put("spark.executor.memory", "8g");
            defaultProfile.put(PROPERTIES, new ArrayList());
            this.saveProfile(defaultProfile);
        } else {
            this.profiles = profiles;
        }
    }

    @Override
    public void saveProfile(Map<String, Object> profile) {
        int idx = IntStream.range(0, this.profiles.size()).filter(i -> profile.get(NAME).equals(this.profiles.get(i).get(NAME))).findFirst().orElse(-1);
        if (idx == -1) {
            this.profiles.add(profile);
        } else {
            this.profiles.set(idx, profile);
        }
        this.saveSparkConf(this.profiles);
    }

    @Override
    public List<String> getProfileNames() {
        return this.profiles.stream().map(x -> (String)x.get(NAME)).collect(Collectors.toList());
    }

    @Override
    public void saveProfileName(String profileName) {
        Map map = this.beakerXJson.beakerxJsonAsMap();
        Map sparkOptions = ((Map)map.get(BEAKERX)).getOrDefault(SPARK_OPTIONS, new HashMap());
        sparkOptions.put(CURRENT_PROFILE, profileName);
        ((Map)map.get(BEAKERX)).put(SPARK_OPTIONS, sparkOptions);
        this.beakerXJson.save(map);
        this.currentProfile = profileName;
    }

    @Override
    public String getCurrentProfileName() {
        return this.currentProfile;
    }

    @Override
    public boolean containsKey(String key) {
        return this.defaults.containsKey(key);
    }

    @Override
    public Object get(String key) {
        return this.defaults.get(key);
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.defaults.containsKey(PROPERTIES)) {
            List props = (List)this.defaults.get(PROPERTIES);
            props.forEach(x -> {
                String pname = (String)x.get(NAME);
                String pvalue = (String)x.get(VALUE);
                if (pname != null && !pname.isEmpty() && pvalue != null && !pvalue.isEmpty()) {
                    result.put(pname, pvalue);
                }
            });
        }
        return result;
    }

    @Override
    public void removeSparkConf(String profileName) {
        this.profiles.removeIf(x -> x.get(NAME).equals(profileName));
        this.saveSparkConf(this.profiles);
    }
}

