/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.ErrorPrinter;
import com.twosigma.beakerx.widget.SparkEngineBase;
import com.twosigma.beakerx.widget.SparkEngineNoUI;
import com.twosigma.beakerx.widget.SparkVariable;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkEngineNoUIImpl
extends SparkEngineBase
implements SparkEngineNoUI {
    SparkEngineNoUIImpl(SparkSession.Builder sparkSessionBuilder) {
        super(sparkSessionBuilder, SparkEngineNoUIImpl.errorPrinter());
    }

    @Override
    public TryResult configure(KernelFunctionality kernel, Message parentMessage) {
        SparkConf sparkConf = SparkEngineNoUIImpl.getSparkConfBasedOn(this.sparkSessionBuilder);
        this.configureSparkConfDefaults(sparkConf);
        this.configureSparkConf(sparkConf);
        this.sparkSessionBuilder = SparkSession.builder().config(sparkConf);
        TryResult sparkSessionTry = this.createSparkSession();
        if (sparkSessionTry.isError()) {
            return sparkSessionTry;
        }
        SparkVariable.putSparkSession(this.getOrCreate());
        TryResult tryResultSparkContext = this.initSparkContextInShell(kernel, parentMessage);
        if (!tryResultSparkContext.isError()) {
            kernel.registerCancelHook(SparkVariable::cancelAllJobs);
        }
        return tryResultSparkContext;
    }

    private void configureSparkConfDefaults(SparkConf sparkConf) {
        if (!sparkConf.contains("spark.master")) {
            this.conf.getMaster().ifPresent(arg_0 -> ((SparkConf)sparkConf).setMaster(arg_0));
        }
        if (!sparkConf.contains("spark.executor.cores")) {
            this.conf.getExecutorCores().ifPresent(x -> sparkConf.set("spark.executor.cores", x));
        }
        if (!sparkConf.contains("spark.executor.memory")) {
            this.conf.getExecutorMemory().ifPresent(x -> sparkConf.set("spark.executor.memory", x));
        }
    }

    private static ErrorPrinter errorPrinter() {
        return e -> Stream.of(e.getMessage(), e.getCause()).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    public static class SparkEngineNoUIFactoryImpl
    implements SparkEngineNoUIFactory {
        @Override
        public SparkEngineNoUI create(SparkSession.Builder sparkSessionBuilder) {
            return new SparkEngineNoUIImpl(sparkSessionBuilder);
        }
    }

    public static interface SparkEngineNoUIFactory {
        public SparkEngineNoUI create(SparkSession.Builder var1);
    }
}

