/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.BeakerxSystemProperty;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import java.io.File;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class ClasspathAddRepoMagicCommand
implements MagicCommandFunctionality {
    public static final String CLASSPATH_PREFIX = "%classpath";
    public static final String CONFIG = "config";
    public static final String RESOLVER = "resolver";
    public static final String CLASSPATH_CONFIG_RESOLVER = "%classpath config resolver";
    public static final String MVN_LOCAL = "mvnLocal";
    public static final String ADDED_NEW_REPO = "Added new repo: ";
    private KernelFunctionality kernel;

    public ClasspathAddRepoMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath(command);
        if (split.length == 4 && split[3].equals(MVN_LOCAL)) {
            return this.handleMvnLocal();
        }
        return this.handleNewRepo(split);
    }

    private MagicCommandOutcomeItem handleNewRepo(String[] split) {
        if (split.length != 5) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. %classpath config resolver");
        }
        String repoName = split[3];
        String urlName = split[4];
        ClasspathAddMvnMagicCommand mvnMagicCommand = this.kernel.magicCommandConfiguration().getClasspathAddMvnMagicCommand(this.kernel);
        String result = mvnMagicCommand.addRepo(repoName, urlName);
        return this.createResult(result);
    }

    private MagicCommandOutcomeItem handleMvnLocal() {
        String localRepo = BeakerxSystemProperty.getHomeUser() + "/.m2/repository";
        if (Files.exists(Paths.get(localRepo, new String[0]), new LinkOption[0])) {
            ClasspathAddMvnMagicCommand mvnMagicCommand = this.kernel.magicCommandConfiguration().getClasspathAddMvnMagicCommand(this.kernel);
            try {
                String result = mvnMagicCommand.addRepo(MVN_LOCAL, new File(localRepo).toURI().toURL().toString());
                return this.createResult(result);
            }
            catch (MalformedURLException e) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, e.toString());
            }
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, String.format("Warning: directory %s not found", localRepo));
    }

    private MagicCommandOutcomeItem createResult(String result) {
        if (result.isEmpty()) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, ADDED_NEW_REPO + result);
    }

    @Override
    public String getMagicCommandName() {
        return CLASSPATH_CONFIG_RESOLVER;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 2 && commandParts[0].equals(CLASSPATH_PREFIX) && commandParts[1].equals(CONFIG) && commandParts[2].equals(RESOLVER);
    }
}

