/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.twosigma.beakerx.kernel.BeakerXJson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeakerXJsonConfig
implements BeakerXJson {
    private Path path;
    private ObjectMapper objectMapper;

    public BeakerXJsonConfig() {
        this(Paths.get((System.getenv("JUPYTER_CONFIG_DIR") != null ? System.getenv("JUPYTER_CONFIG_DIR") : System.getProperty("user.home") + File.separator + ".jupyter") + File.separator + "beakerx.json", new String[0]));
    }

    public BeakerXJsonConfig(Path path) {
        this.path = path;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @Override
    public Map<String, Map> beakerxJsonAsMap() {
        String jsonAsString = null;
        try {
            jsonAsString = new String(Files.readAllBytes(this.path), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.fromJson(jsonAsString, LinkedHashMap.class);
    }

    private <T> T fromJson(String json, Class<T> theClass) {
        Object result = null;
        try {
            result = this.objectMapper.readValue(json, theClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)result;
    }

    private String toJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void save(Map<String, Map> map) {
        try {
            String content = this.toJson(map);
            Files.write(this.path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

