/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.CodeCell;
import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.easyform.EasyForm;
import com.twosigma.beakerx.jvm.object.BeakerDashboard;
import com.twosigma.beakerx.jvm.object.CyclingOutputContainerLayoutManager;
import com.twosigma.beakerx.jvm.object.DashboardLayoutManager;
import com.twosigma.beakerx.jvm.object.EvaluationResult;
import com.twosigma.beakerx.jvm.object.GridOutputContainerLayoutManager;
import com.twosigma.beakerx.jvm.object.OutputContainer;
import com.twosigma.beakerx.jvm.object.OutputContainerCell;
import com.twosigma.beakerx.jvm.object.TabbedOutputContainerLayoutManager;
import com.twosigma.beakerx.jvm.object.UpdatableEvaluationResult;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import com.twosigma.beakerx.jvm.serialization.ObjectSerializer;
import com.twosigma.beakerx.table.TableDisplay;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicObjectSerializer
implements BeakerObjectConverter {
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_LONG = "int64";
    public static final String TYPE_BIGINT = "bigint";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_TIME = "time";
    public static final String TYPE_SELECT = "select";
    private static final Logger logger = LoggerFactory.getLogger((String)BasicObjectSerializer.class.getName());
    protected final Map<String, String> types = new HashMap<String, String>();
    protected final List<String> knownBeakerTypes;
    protected final List<ObjectDeserializer> supportedDeserializers;
    protected final List<ObjectSerializer> supportedSerializers;
    protected final ThreadLocal<Map<String, String>> threadTypes;
    protected final ThreadLocal<List<ObjectDeserializer>> threadDeserializers = new ThreadLocal();
    protected final ThreadLocal<List<ObjectSerializer>> threadSerializers = new ThreadLocal();

    protected boolean isListOfPrimitiveTypeMaps(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.isEmpty()) {
            return false;
        }
        for (Object obj : c) {
            if (obj == null || this.isPrimitiveTypeMap(obj)) continue;
            return false;
        }
        return true;
    }

    protected boolean isPrimitiveTypeMap(Object o) {
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        Set eset = m.entrySet();
        for (Map.Entry entry : eset) {
            Map.Entry e = entry;
            if (e.getValue() == null || this.isPrimitiveType(e.getValue().getClass().getName())) continue;
            return false;
        }
        return true;
    }

    protected boolean isPrimitiveTypeListOfList(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection m = (Collection)o;
        int max = 0;
        for (Object entry : m) {
            if (!(entry instanceof Collection)) {
                return false;
            }
            Collection e = (Collection)entry;
            for (Object ei : e) {
                if (ei == null || this.isPrimitiveType(ei.getClass().getName())) continue;
                return false;
            }
            if (max >= e.size()) continue;
            max = e.size();
        }
        return max >= 2 && m.size() >= 2;
    }

    public BasicObjectSerializer() {
        this.supportedDeserializers = new ArrayList<ObjectDeserializer>();
        this.supportedSerializers = new ArrayList<ObjectSerializer>();
        this.threadTypes = new ThreadLocal();
        this.knownBeakerTypes = new ArrayList<String>();
        this.addTypeConversion("java.lang.Boolean", TYPE_BOOLEAN);
        this.addTypeConversion("java.lang.Byte", TYPE_INTEGER);
        this.addTypeConversion("java.lang.Character", TYPE_STRING);
        this.addTypeConversion("java.lang.Double", TYPE_DOUBLE);
        this.addTypeConversion("java.lang.Enum", TYPE_SELECT);
        this.addTypeConversion("java.lang.Float", TYPE_DOUBLE);
        this.addTypeConversion("java.lang.Integer", TYPE_INTEGER);
        this.addTypeConversion("java.lang.Long", TYPE_LONG);
        this.addTypeConversion("java.lang.Short", TYPE_INTEGER);
        this.addTypeConversion("java.lang.String", TYPE_STRING);
        this.addTypeConversion("java.lang.StringBuffer", TYPE_STRING);
        this.addTypeConversion("java.lang.StringBuilder", TYPE_STRING);
        this.addTypeConversion("java.util.Date", TYPE_TIME);
        this.addTypeConversion("java.util.concurrent.atomic.AtomicInteger", TYPE_INTEGER);
        this.addTypeConversion("java.util.concurrent.atomic.AtomicLong", TYPE_INTEGER);
        this.addTypeConversion("java.math.BigDecimal", TYPE_DOUBLE);
        this.addTypeConversion("java.math.BigInteger", TYPE_BIGINT);
        this.addTypeConversion("org.codehaus.groovy.runtime.GStringImpl", TYPE_STRING);
        this.addTypeSerializer(new PrimitiveTypeSerializer());
        this.addTypeSerializer(new ListOfPrimitiveTypeMapsSerializer(this));
        this.addTypeSerializer(new PrimitiveTypeListOfListSerializer());
        this.addTypeSerializer(new PrimitiveTypeMapSerializer());
        this.addTypeSerializer(new ArraySerializer(this));
        this.addTypeSerializer(new CollectionSerializer(this));
        this.addTypeSerializer(new MapSerializer(this));
    }

    @Override
    public String convertType(String tn) {
        if (this.threadTypes.get() != null && this.threadTypes.get().containsKey(tn)) {
            return this.threadTypes.get().get(tn);
        }
        if (this.types.containsKey(tn)) {
            return this.types.get(tn);
        }
        return "";
    }

    @Override
    public boolean isPrimitiveType(String tn) {
        return this.types.containsKey(tn) || this.threadTypes.get() != null && this.threadTypes.get().containsKey(tn);
    }

    @Override
    public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws IOException {
        if (obj == null) {
            jgen.writeNull();
        } else if (obj instanceof TableDisplay || obj instanceof EvaluationResult || obj instanceof UpdatableEvaluationResult || obj instanceof CodeCell || obj instanceof ImageIcon || obj instanceof Date || obj instanceof BeakerDashboard || obj instanceof BufferedImage || obj instanceof TabbedOutputContainerLayoutManager || obj instanceof GridOutputContainerLayoutManager || obj instanceof CyclingOutputContainerLayoutManager || obj instanceof DashboardLayoutManager || obj instanceof OutputContainerCell || obj instanceof OutputContainer || obj instanceof EasyForm || obj instanceof Color) {
            logger.debug("basic object");
            jgen.writeObject(obj);
        } else {
            return this.runThreadSerializers(obj, jgen, expand) || this.runConfiguredSerializers(obj, jgen, expand);
        }
        return true;
    }

    public boolean runThreadSerializers(Object obj, JsonGenerator jgen, boolean expand) throws IOException, JsonProcessingException {
        if (this.threadSerializers.get() == null) {
            return false;
        }
        for (ObjectSerializer s : this.threadSerializers.get()) {
            try {
                if (!s.canBeUsed(obj, expand) || !s.writeObject(obj, jgen, expand)) continue;
                logger.debug("used thread serialization");
                return true;
            }
            catch (Exception e) {
                logger.error("exception in thread serialization", (Throwable)e);
            }
        }
        return false;
    }

    public boolean runConfiguredSerializers(Object obj, JsonGenerator jgen, boolean expand) throws IOException, JsonProcessingException {
        for (ObjectSerializer s : this.supportedSerializers) {
            if (!s.canBeUsed(obj, expand) || !s.writeObject(obj, jgen, expand)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        if (n == null) {
            return null;
        }
        Object obj = null;
        if (this.threadDeserializers.get() != null) {
            for (ObjectDeserializer d : this.threadDeserializers.get()) {
                try {
                    if (!d.canBeUsed(n) || (obj = d.deserialize(n, mapper)) == null) continue;
                    logger.debug("used thread deserialization");
                    break;
                }
                catch (Exception e) {
                    logger.error("exception in thread deserialization", (Throwable)e);
                    obj = null;
                }
            }
        }
        if (obj != null) {
            return obj;
        }
        for (ObjectDeserializer d : this.supportedDeserializers) {
            try {
                if (!d.canBeUsed(n) || (obj = d.deserialize(n, mapper)) == null) continue;
                logger.debug("used custom deserialization");
                break;
            }
            catch (Exception e) {
                logger.error("exception in deserialization", (Throwable)e);
                obj = null;
            }
        }
        if (obj == null) {
            logger.debug("using standard deserialization");
            try {
                obj = n.isTextual() ? n.textValue() : mapper.readValue(n.asText(), Object.class);
            }
            catch (Exception e) {
                logger.error("exception in auto deserialization", (Throwable)e);
                obj = null;
            }
        }
        return obj;
    }

    @Override
    public void addTypeConversion(String from, String to) {
        this.types.put(from, to);
    }

    @Override
    public void addTypeDeserializer(ObjectDeserializer o) {
        this.supportedDeserializers.add(o);
    }

    @Override
    public void addTypeSerializer(ObjectSerializer o) {
        this.supportedSerializers.add(o);
    }

    @Override
    public void addfTypeDeserializer(ObjectDeserializer o) {
        this.supportedDeserializers.add(0, o);
    }

    @Override
    public void addfTypeSerializer(ObjectSerializer o) {
        this.supportedSerializers.add(0, o);
    }

    @Override
    public void addThreadSpecificTypeConversion(String from, String to) {
        if (this.threadTypes.get() == null) {
            this.threadTypes.set(new HashMap());
        }
        this.threadTypes.get().put(from, to);
    }

    @Override
    public void addThreadSpecificTypeDeserializer(ObjectDeserializer o) {
        if (this.threadDeserializers.get() == null) {
            this.threadDeserializers.set(new ArrayList());
        }
        this.threadDeserializers.get().add(o);
    }

    @Override
    public void addThreadSpecificTypeSerializer(ObjectSerializer o) {
        if (this.threadSerializers.get() == null) {
            this.threadSerializers.set(new ArrayList());
        }
        this.threadSerializers.get().add(o);
    }

    @Override
    public void addKnownBeakerType(String t) {
        this.knownBeakerTypes.add(t);
    }

    @Override
    public boolean isKnownBeakerType(String t) {
        return this.knownBeakerTypes.contains(t);
    }

    class MapSerializer
    implements ObjectSerializer {
        private final BasicObjectSerializer parent;

        public MapSerializer(BasicObjectSerializer p) {
            this.parent = p;
        }

        @Override
        public boolean canBeUsed(Object obj, boolean expand) {
            return obj instanceof Map;
        }

        @Override
        public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
            logger.debug("generic map");
            Map m = (Map)obj;
            Set kset = m.keySet();
            if (kset.size() == 0 || !(kset.iterator().next() instanceof String)) {
                jgen.writeObject((Object)obj.toString());
            } else {
                jgen.writeStartObject();
                for (Object k : kset) {
                    jgen.writeFieldName(null == k ? "null" : k.toString());
                    if (this.parent.writeObject(m.get(k), jgen, false)) continue;
                    jgen.writeObject((Object)(m.get(k) != null ? m.get(k).toString() : "null"));
                }
                jgen.writeEndObject();
            }
            return true;
        }
    }

    class CollectionSerializer
    implements ObjectSerializer {
        private final BasicObjectSerializer parent;

        public CollectionSerializer(BasicObjectSerializer p) {
            this.parent = p;
        }

        @Override
        public boolean canBeUsed(Object obj, boolean expand) {
            return obj instanceof Collection;
        }

        @Override
        public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
            logger.debug("collection");
            Collection c = (Collection)obj;
            jgen.writeStartArray();
            for (Object o : c) {
                if (this.parent.writeObject(o, jgen, false)) continue;
                jgen.writeObject((Object)o.toString());
            }
            jgen.writeEndArray();
            return true;
        }
    }

    class ArraySerializer
    implements ObjectSerializer {
        private final BasicObjectSerializer parent;

        public ArraySerializer(BasicObjectSerializer p) {
            this.parent = p;
        }

        @Override
        public boolean canBeUsed(Object obj, boolean expand) {
            return obj.getClass().isArray();
        }

        @Override
        public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
            logger.debug("array");
            jgen.writeStartArray();
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(obj, i);
                if (this.parent.writeObject(o, jgen, false)) continue;
                jgen.writeObject((Object)o.toString());
            }
            jgen.writeEndArray();
            return true;
        }
    }

    class PrimitiveTypeMapSerializer
    implements ObjectSerializer {
        PrimitiveTypeMapSerializer() {
        }

        @Override
        public boolean canBeUsed(Object obj, boolean expand) {
            return expand && BasicObjectSerializer.this.isPrimitiveTypeMap(obj);
        }

        @Override
        public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
            logger.debug("primitive type map");
            Map m = (Map)obj;
            ArrayList<String> columns = new ArrayList<String>();
            columns.add("Key");
            columns.add("Value");
            ArrayList values = new ArrayList();
            Set eset = m.entrySet();
            Iterator iterator = eset.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry e = entry = iterator.next();
                ArrayList<String> l = new ArrayList<String>();
                Object o = e.getKey();
                l.add(null == o ? "null" : o.toString());
                l.add((String)e.getValue());
                values.add(l);
            }
            jgen.writeStartObject();
            jgen.writeObjectField("type", (Object)"TableDisplay");
            jgen.writeObjectField("columnNames", columns);
            jgen.writeObjectField("values", values);
            jgen.writeObjectField("subtype", (Object)"Dictionary");
            jgen.writeEndObject();
            return true;
        }
    }

    class PrimitiveTypeListOfListSerializer
    implements ObjectSerializer {
        PrimitiveTypeListOfListSerializer() {
        }

        @Override
        public boolean canBeUsed(Object obj, boolean expand) {
            return expand && BasicObjectSerializer.this.isPrimitiveTypeListOfList(obj);
        }

        @Override
        public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
            logger.debug("collection of collections");
            Collection m = (Collection)obj;
            int max = 0;
            for (Object entry : m) {
                Collection e = (Collection)entry;
                if (max >= e.size()) continue;
                max = e.size();
            }
            ArrayList<String> columns = new ArrayList<String>();
            for (int i = 0; i < max; ++i) {
                columns.add("c" + i);
            }
            ArrayList values = new ArrayList();
            for (Object entry : m) {
                Collection e = (Collection)entry;
                ArrayList l2 = new ArrayList(e);
                if (l2.size() < max) {
                    for (int i = l2.size(); i < max; ++i) {
                        l2.add(null);
                    }
                }
                values.add(l2);
            }
            jgen.writeStartObject();
            jgen.writeObjectField("type", (Object)"TableDisplay");
            jgen.writeObjectField("columnNames", columns);
            jgen.writeObjectField("values", values);
            jgen.writeObjectField("subtype", (Object)"Matrix");
            jgen.writeEndObject();
            return true;
        }
    }

    class ListOfPrimitiveTypeMapsSerializer
    implements ObjectSerializer {
        private final BasicObjectSerializer parent;

        public ListOfPrimitiveTypeMapsSerializer(BasicObjectSerializer p) {
            this.parent = p;
        }

        @Override
        public boolean canBeUsed(Object obj, boolean expand) {
            return expand && BasicObjectSerializer.this.isListOfPrimitiveTypeMaps(obj);
        }

        @Override
        public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
            logger.debug("list of maps");
            try {
                Collection co = (Collection)obj;
                TableDisplay t = new TableDisplay(co, this.parent);
                jgen.writeObject((Object)t);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    class PrimitiveTypeSerializer
    implements ObjectSerializer {
        PrimitiveTypeSerializer() {
        }

        @Override
        public boolean canBeUsed(Object obj, boolean expand) {
            return BasicObjectSerializer.this.isPrimitiveType(obj.getClass().getName());
        }

        @Override
        public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
            jgen.writeObject(obj);
            return true;
        }
    }
}

