/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import java.util.List;
import java.util.Map;
import net.sf.jtreemap.swing.TreeMapNode;

public class TreeMapNodeCounter {
    public static final String IS_LEAF = "isLeaf";

    public static int countAllNodes(TreeMapNode node) {
        return TreeMapNodeCounter.count(node, 0, (object, count1) -> count1 + 1);
    }

    public static int countReducedLeaves(TreeMapNode node) {
        return TreeMapNodeCounter.count(node, 0, (object, count) -> {
            Map userObject = (Map)object.getUserObject();
            Boolean isLeaf = (Boolean)userObject.get(IS_LEAF);
            if (isLeaf.booleanValue()) {
                return count + 1;
            }
            return count;
        });
    }

    private static int count(TreeMapNode node, int count, Visitor visitor) {
        count = visitor.visit(node, count);
        List<TreeMapNode> children = node.getChildren();
        if (children != null) {
            for (TreeMapNode child : children) {
                count = TreeMapNodeCounter.count(child, count, visitor);
            }
        }
        return count;
    }

    static interface Visitor {
        public int visit(TreeMapNode var1, int var2);
    }
}

