/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.HaltException;
import io.javalin.core.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u0012J\u0006\u0010\u001e\u001a\u00020\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lio/javalin/core/util/Util;", "", "()V", "dependencyCheckCache", "Ljava/util/HashMap;", "", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "noServerHasBeenStarted", "getNoServerHasBeenStarted", "()Z", "setNoServerHasBeenStarted", "(Z)V", "classExists", "className", "ensureDependencyPresent", "", "dependencyName", "url", "javalinBanner", "normalizeContextPath", "contextPath", "pathToList", "", "pathString", "prefixContextPath", "path", "printHelpfulMessageIfLoggerIsMissing", "printHelpfulMessageIfNoServerHasBeenStartedAfterOneSecond", "javalin"})
public final class Util {
    private static final Logger log;
    private static boolean noServerHasBeenStarted;
    private static final HashMap<String, Boolean> dependencyCheckCache;
    public static final Util INSTANCE;

    public final boolean getNoServerHasBeenStarted() {
        return noServerHasBeenStarted;
    }

    public final void setNoServerHasBeenStarted(boolean bl) {
        noServerHasBeenStarted = bl;
    }

    @NotNull
    public final String normalizeContextPath(@NotNull String contextPath) {
        Intrinsics.checkParameterIsNotNull((Object)contextPath, (String)"contextPath");
        CharSequence charSequence = "/" + contextPath;
        String string = "/{2,}";
        string = new Regex(string);
        String string2 = "/";
        return StringsKt.removeSuffix((String)string.replace(charSequence, string2), (CharSequence)"/");
    }

    @NotNull
    public final String prefixContextPath(@NotNull String path, @NotNull String contextPath) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)contextPath, (String)"contextPath");
        if (Intrinsics.areEqual((Object)path, (Object)"*")) {
            string = path;
        } else {
            CharSequence charSequence = contextPath + "/" + path;
            String string2 = "/{2,}";
            string2 = new Regex(string2);
            String string3 = "/";
            string = string2.replace(charSequence, string3);
        }
        return string;
    }

    private final boolean classExists(String className) {
        boolean bl;
        try {
            Class.forName(className);
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public final void ensureDependencyPresent(@NotNull String dependencyName, @NotNull String className, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)dependencyCheckCache.get(className), (Object)true)) {
            return;
        }
        if (!this.classExists(className)) {
            String message = "Missing dependency '" + dependencyName + "'. Please add dependency: https://mvnrepository.com/artifact/" + url;
            log.warn(message);
            throw (Throwable)new HaltException(500, message);
        }
        Map map = dependencyCheckCache;
        Boolean bl = true;
        map.put(className, bl);
    }

    public final void printHelpfulMessageIfNoServerHasBeenStartedAfterOneSecond() {
        new Thread(printHelpfulMessageIfNoServerHasBeenStartedAfterOneSecond.1.INSTANCE).start();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> pathToList(@NotNull String pathString) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)pathString, (String)"pathString");
        Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)pathString, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            CharSequence charSequence = it;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void printHelpfulMessageIfLoggerIsMissing() {
        if (!this.classExists("org.slf4j.impl.StaticLoggerBinder")) {
            String message = StringsKt.trimIndent((String)"\n            -------------------------------------------------------------------\n            Javalin: In the Java world, it's common to add your own logger.\n            Javalin: To easily fix the warning above, get the latest version of slf4j-simple:\n            Javalin: https://mvnrepository.com/artifact/org.slf4j/slf4j-simple\n            Javalin: then add it to your dependencies (pom.xml or build.gradle)\n            Javalin: Visit https://javalin.io/documentation#logging if you need more help\n            ");
            System.err.println(message);
        }
    }

    @NotNull
    public final String javalinBanner() {
        return "\n" + StringsKt.trimIndent((String)"\n             _________________________________________\n            |        _                  _ _           |\n            |       | | __ ___   ____ _| (_)_ __      |\n            |    _  | |/ _` \\ \\ / / _` | | | '_ \\     |\n            |   | |_| | (_| |\\ V / (_| | | | | | |    |\n            |    \\___/ \\__,_| \\_/ \\__,_|_|_|_| |_|    |\n            |_________________________________________|\n            |                                         |\n            |    https://javalin.io/documentation     |\n            |_________________________________________|");
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
        log = LoggerFactory.getLogger(Util.class);
        noServerHasBeenStarted = true;
        dependencyCheckCache = new HashMap();
    }

    public static final /* synthetic */ Logger access$getLog$p(Util $this) {
        Util util = $this;
        return log;
    }
}

