/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.util.introspection.ClassUtils;

public class TypeComparators {
    private Map<Class<?>, Comparator<?>> typeComparators = new HashMap();

    public Comparator<?> get(Class<?> clazz) {
        Comparator<?> comparator = this.typeComparators.get(clazz);
        if (comparator == null) {
            for (Class<?> superClass : ClassUtils.getAllSuperclasses(clazz)) {
                if (!this.typeComparators.containsKey(superClass)) continue;
                comparator = this.typeComparators.get(superClass);
                break;
            }
            if (comparator == null) {
                for (Class<?> interfaceClass : ClassUtils.getAllInterfaces(clazz)) {
                    if (!this.typeComparators.containsKey(interfaceClass)) continue;
                    comparator = this.typeComparators.get(interfaceClass);
                    break;
                }
            }
        }
        return comparator;
    }

    public <T> void put(Class<T> clazz, Comparator<T> comparator) {
        this.typeComparators.put(clazz, comparator);
    }

    public boolean isEmpty() {
        return this.typeComparators.isEmpty();
    }

    public int hashCode() {
        return this.typeComparators.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TypeComparators && this.typeComparators.equals(((TypeComparators)obj).typeComparators);
    }

    public String toString() {
        return this.typeComparators.toString();
    }
}

