/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteCandidate;
import java.util.ArrayList;
import java.util.List;

public class AutocompleteRegistry {
    private AutocompleteRegistryForType[] registry;

    public AutocompleteRegistry(int numt) {
        this.registry = new AutocompleteRegistryForType[numt];
        for (int i = 0; i < numt; ++i) {
            this.registry[i] = new AutocompleteRegistryForType();
        }
    }

    public void addCandidate(AutocompleteCandidate c) {
        this.registry[c.getType()].add(c);
    }

    public List<String> searchCandidates(List<AutocompleteCandidate> cands) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AutocompleteCandidate a : cands) {
            if (a == null) continue;
            this.registry[a.getType()].searchCandidates(ret, a);
        }
        return ret;
    }

    class AutocompleteRegistryForType {
        private List<AutocompleteCandidate> children = new ArrayList<AutocompleteCandidate>();

        AutocompleteRegistryForType() {
        }

        void add(AutocompleteCandidate c) {
            for (AutocompleteCandidate c1 : this.children) {
                if (!c1.getKey().equals(c.getKey())) continue;
                c1.addChildrens(c.getChildrens());
                return;
            }
            this.children.add(c);
        }

        void searchCandidates(List<String> ret, AutocompleteCandidate a) {
            for (AutocompleteCandidate c1 : this.children) {
                c1.searchCandidates(ret, a);
            }
        }
    }
}

