/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.testng.IAnnotationTransformer;
import org.testng.TestNGException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IListenersAnnotation;
import org.testng.annotations.IObjectFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Listeners;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.DataProviderAnnotation;
import org.testng.internal.annotations.FactoryAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.annotations.ListenersAnnotation;
import org.testng.internal.annotations.ObjectFactoryAnnotation;
import org.testng.internal.annotations.ParametersAnnotation;
import org.testng.internal.annotations.TestAnnotation;
import org.testng.internal.collections.Ints;

public class JDK15TagFactory {
    private static final Default<Class<?>> DEFAULT_CLASS = new Default<Class<?>>(){

        @Override
        public boolean isDefault(Class<?> clazz) {
            return clazz == Object.class;
        }
    };
    private static final Default<String> DEFAULT_STRING = new Default<String>(){

        @Override
        public boolean isDefault(String string) {
            return Utils.isStringEmpty(string);
        }
    };

    public <A extends IAnnotation> A createTag(Class<?> clazz, Method method, Annotation annotation, Class<A> clazz2, IAnnotationTransformer iAnnotationTransformer) {
        IAnnotation iAnnotation = null;
        if (annotation != null) {
            if (clazz2 == IDataProviderAnnotation.class) {
                iAnnotation = this.createDataProviderTag(method, annotation);
            } else if (clazz2 == IFactoryAnnotation.class) {
                iAnnotation = this.createFactoryTag(clazz, annotation);
            } else if (clazz2 == IParametersAnnotation.class) {
                iAnnotation = this.createParametersTag(annotation);
            } else if (clazz2 == IObjectFactoryAnnotation.class) {
                iAnnotation = this.createObjectFactoryTag(annotation);
            } else if (clazz2 == ITestAnnotation.class) {
                iAnnotation = this.createTestTag(clazz, annotation, iAnnotationTransformer);
            } else if (clazz2 == IListenersAnnotation.class) {
                iAnnotation = this.createListenersTag(clazz, annotation, iAnnotationTransformer);
            } else if (clazz2 == IBeforeSuite.class || clazz2 == IAfterSuite.class || clazz2 == IBeforeTest.class || clazz2 == IAfterTest.class || clazz2 == IBeforeGroups.class || clazz2 == IAfterGroups.class || clazz2 == IBeforeClass.class || clazz2 == IAfterClass.class || clazz2 == IBeforeMethod.class || clazz2 == IAfterMethod.class) {
                iAnnotation = this.maybeCreateNewConfigurationTag(clazz, annotation, clazz2);
            } else {
                throw new TestNGException("Unknown annotation requested:" + clazz2);
            }
        }
        return (A)iAnnotation;
    }

    private IAnnotation maybeCreateNewConfigurationTag(Class<?> clazz, Annotation annotation, Class<?> clazz2) {
        IAnnotation iAnnotation = null;
        if (clazz2 == IBeforeSuite.class) {
            BeforeSuite beforeSuite = (BeforeSuite)annotation;
            iAnnotation = this.createConfigurationTag(clazz, annotation, true, false, false, false, new String[0], new String[0], false, false, false, false, beforeSuite.alwaysRun(), beforeSuite.dependsOnGroups(), beforeSuite.dependsOnMethods(), beforeSuite.description(), beforeSuite.enabled(), beforeSuite.groups(), beforeSuite.inheritGroups(), null, false, false, beforeSuite.timeOut());
        } else if (clazz2 == IAfterSuite.class) {
            AfterSuite afterSuite = (AfterSuite)annotation;
            iAnnotation = this.createConfigurationTag(clazz, annotation, false, true, false, false, new String[0], new String[0], false, false, false, false, afterSuite.alwaysRun(), afterSuite.dependsOnGroups(), afterSuite.dependsOnMethods(), afterSuite.description(), afterSuite.enabled(), afterSuite.groups(), afterSuite.inheritGroups(), null, false, false, afterSuite.timeOut());
        } else if (clazz2 == IBeforeTest.class) {
            BeforeTest beforeTest = (BeforeTest)annotation;
            iAnnotation = this.createConfigurationTag(clazz, annotation, false, false, true, false, new String[0], new String[0], false, false, false, false, beforeTest.alwaysRun(), beforeTest.dependsOnGroups(), beforeTest.dependsOnMethods(), beforeTest.description(), beforeTest.enabled(), beforeTest.groups(), beforeTest.inheritGroups(), null, false, false, beforeTest.timeOut());
        } else if (clazz2 == IAfterTest.class) {
            AfterTest afterTest = (AfterTest)annotation;
            iAnnotation = this.createConfigurationTag(clazz, annotation, false, false, false, true, new String[0], new String[0], false, false, false, false, afterTest.alwaysRun(), afterTest.dependsOnGroups(), afterTest.dependsOnMethods(), afterTest.description(), afterTest.enabled(), afterTest.groups(), afterTest.inheritGroups(), null, false, false, afterTest.timeOut());
        } else if (clazz2 == IBeforeGroups.class) {
            BeforeGroups beforeGroups = (BeforeGroups)annotation;
            String[] stringArray = beforeGroups.value().length > 0 ? beforeGroups.value() : beforeGroups.groups();
            iAnnotation = this.createConfigurationTag(clazz, annotation, false, false, false, false, stringArray, new String[0], false, false, false, false, beforeGroups.alwaysRun(), beforeGroups.dependsOnGroups(), beforeGroups.dependsOnMethods(), beforeGroups.description(), beforeGroups.enabled(), beforeGroups.groups(), beforeGroups.inheritGroups(), null, false, false, beforeGroups.timeOut());
        } else if (clazz2 == IAfterGroups.class) {
            AfterGroups afterGroups = (AfterGroups)annotation;
            String[] stringArray = afterGroups.value().length > 0 ? afterGroups.value() : afterGroups.groups();
            iAnnotation = this.createConfigurationTag(clazz, annotation, false, false, false, false, new String[0], stringArray, false, false, false, false, afterGroups.alwaysRun(), afterGroups.dependsOnGroups(), afterGroups.dependsOnMethods(), afterGroups.description(), afterGroups.enabled(), afterGroups.groups(), afterGroups.inheritGroups(), null, false, false, afterGroups.timeOut());
        } else if (clazz2 == IBeforeClass.class) {
            BeforeClass beforeClass = (BeforeClass)annotation;
            iAnnotation = this.createConfigurationTag(clazz, annotation, false, false, false, false, new String[0], new String[0], true, false, false, false, beforeClass.alwaysRun(), beforeClass.dependsOnGroups(), beforeClass.dependsOnMethods(), beforeClass.description(), beforeClass.enabled(), beforeClass.groups(), beforeClass.inheritGroups(), null, false, false, beforeClass.timeOut());
        } else if (clazz2 == IAfterClass.class) {
            AfterClass afterClass = (AfterClass)annotation;
            iAnnotation = this.createConfigurationTag(clazz, annotation, false, false, false, false, new String[0], new String[0], false, true, false, false, afterClass.alwaysRun(), afterClass.dependsOnGroups(), afterClass.dependsOnMethods(), afterClass.description(), afterClass.enabled(), afterClass.groups(), afterClass.inheritGroups(), null, false, false, afterClass.timeOut());
        } else if (clazz2 == IBeforeMethod.class) {
            BeforeMethod beforeMethod = (BeforeMethod)annotation;
            iAnnotation = this.createConfigurationTag(clazz, annotation, false, false, false, false, new String[0], new String[0], false, false, true, false, beforeMethod.alwaysRun(), beforeMethod.dependsOnGroups(), beforeMethod.dependsOnMethods(), beforeMethod.description(), beforeMethod.enabled(), beforeMethod.groups(), beforeMethod.inheritGroups(), null, beforeMethod.firstTimeOnly(), false, beforeMethod.timeOut());
        } else if (clazz2 == IAfterMethod.class) {
            AfterMethod afterMethod = (AfterMethod)annotation;
            iAnnotation = this.createConfigurationTag(clazz, annotation, false, false, false, false, new String[0], new String[0], false, false, false, true, afterMethod.alwaysRun(), afterMethod.dependsOnGroups(), afterMethod.dependsOnMethods(), afterMethod.description(), afterMethod.enabled(), afterMethod.groups(), afterMethod.inheritGroups(), null, false, afterMethod.lastTimeOnly(), afterMethod.timeOut());
        }
        return iAnnotation;
    }

    private IAnnotation createConfigurationTag(Class<?> clazz, Annotation annotation, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray, String[] stringArray2, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, String[] stringArray3, String[] stringArray4, String string, boolean bl10, String[] stringArray5, boolean bl11, String[] stringArray6, boolean bl12, boolean bl13, long l) {
        ConfigurationAnnotation configurationAnnotation = new ConfigurationAnnotation();
        configurationAnnotation.setFakeConfiguration(true);
        configurationAnnotation.setBeforeSuite(bl);
        configurationAnnotation.setAfterSuite(bl2);
        configurationAnnotation.setBeforeTest(bl3);
        configurationAnnotation.setAfterTest(bl4);
        configurationAnnotation.setBeforeTestClass(bl5);
        configurationAnnotation.setAfterTestClass(bl6);
        configurationAnnotation.setBeforeGroups(stringArray);
        configurationAnnotation.setAfterGroups(stringArray2);
        configurationAnnotation.setBeforeTestMethod(bl7);
        configurationAnnotation.setAfterTestMethod(bl8);
        configurationAnnotation.setAlwaysRun(bl9);
        configurationAnnotation.setDependsOnGroups(stringArray3);
        configurationAnnotation.setDependsOnMethods(stringArray4);
        configurationAnnotation.setDescription(string);
        configurationAnnotation.setEnabled(bl10);
        configurationAnnotation.setGroups(stringArray5);
        configurationAnnotation.setInheritGroups(bl11);
        configurationAnnotation.setParameters(stringArray6);
        configurationAnnotation.setFirstTimeOnly(bl12);
        configurationAnnotation.setLastTimeOnly(bl13);
        configurationAnnotation.setTimeOut(l);
        return configurationAnnotation;
    }

    private IAnnotation createDataProviderTag(Method method, Annotation annotation) {
        DataProviderAnnotation dataProviderAnnotation = new DataProviderAnnotation();
        DataProvider dataProvider = (DataProvider)annotation;
        if (dataProvider.name().isEmpty()) {
            dataProviderAnnotation.setName(method.getName());
        } else {
            dataProviderAnnotation.setName(dataProvider.name());
        }
        dataProviderAnnotation.setParallel(dataProvider.parallel());
        dataProviderAnnotation.setIndices(Ints.asList(dataProvider.indices()));
        return dataProviderAnnotation;
    }

    private IAnnotation createFactoryTag(Class<?> clazz, Annotation annotation) {
        FactoryAnnotation factoryAnnotation = new FactoryAnnotation();
        Factory factory = (Factory)annotation;
        factoryAnnotation.setParameters(factory.parameters());
        factoryAnnotation.setDataProvider(factory.dataProvider());
        factoryAnnotation.setDataProviderClass(this.findInherited(factory.dataProviderClass(), clazz, Factory.class, "dataProviderClass", DEFAULT_CLASS));
        factoryAnnotation.setEnabled(factory.enabled());
        factoryAnnotation.setIndices(Ints.asList(factory.indices()));
        return factoryAnnotation;
    }

    private IAnnotation createObjectFactoryTag(Annotation annotation) {
        return new ObjectFactoryAnnotation();
    }

    private IAnnotation createParametersTag(Annotation annotation) {
        ParametersAnnotation parametersAnnotation = new ParametersAnnotation();
        Parameters parameters = (Parameters)annotation;
        parametersAnnotation.setValue(parameters.value());
        return parametersAnnotation;
    }

    private IAnnotation createListenersTag(Class<?> clazz, Annotation annotation, IAnnotationTransformer iAnnotationTransformer) {
        ListenersAnnotation listenersAnnotation = new ListenersAnnotation();
        Listeners listeners = (Listeners)annotation;
        listenersAnnotation.setValue(listeners.value());
        return listenersAnnotation;
    }

    private IAnnotation createTestTag(Class<?> clazz, Annotation annotation, IAnnotationTransformer iAnnotationTransformer) {
        TestAnnotation testAnnotation = new TestAnnotation();
        Test test = (Test)annotation;
        testAnnotation.setEnabled(test.enabled());
        testAnnotation.setGroups(this.join(test.groups(), this.findInheritedStringArray(clazz, Test.class, "groups")));
        testAnnotation.setParameters(test.parameters());
        testAnnotation.setDependsOnGroups(this.join(test.dependsOnGroups(), this.findInheritedStringArray(clazz, Test.class, "dependsOnGroups")));
        testAnnotation.setDependsOnMethods(this.join(test.dependsOnMethods(), this.findInheritedStringArray(clazz, Test.class, "dependsOnMethods")));
        testAnnotation.setTimeOut(test.timeOut());
        testAnnotation.setInvocationTimeOut(test.invocationTimeOut());
        testAnnotation.setInvocationCount(test.invocationCount());
        testAnnotation.setThreadPoolSize(test.threadPoolSize());
        testAnnotation.setSuccessPercentage(test.successPercentage());
        testAnnotation.setDataProvider(test.dataProvider());
        testAnnotation.setDataProviderClass(this.findInherited(test.dataProviderClass(), clazz, Test.class, "dataProviderClass", DEFAULT_CLASS));
        testAnnotation.setAlwaysRun(test.alwaysRun());
        testAnnotation.setDescription(this.findInherited(test.description(), clazz, Test.class, "description", DEFAULT_STRING));
        testAnnotation.setExpectedExceptions(test.expectedExceptions());
        testAnnotation.setExpectedExceptionsMessageRegExp(test.expectedExceptionsMessageRegExp());
        testAnnotation.setSuiteName(test.suiteName());
        testAnnotation.setTestName(test.testName());
        testAnnotation.setSequential(test.sequential());
        testAnnotation.setSingleThreaded(test.singleThreaded());
        testAnnotation.setRetryAnalyzer(test.retryAnalyzer());
        testAnnotation.setSkipFailedInvocations(test.skipFailedInvocations());
        testAnnotation.setIgnoreMissingDependencies(test.ignoreMissingDependencies());
        testAnnotation.setPriority(test.priority());
        return testAnnotation;
    }

    private String[] join(String[] stringArray, String[] stringArray2) {
        List<String> list = Lists.newArrayList(stringArray);
        HashSet<String> hashSet = new HashSet<String>(Lists.newArrayList(stringArray));
        for (String string : stringArray2) {
            if (hashSet.contains(string)) continue;
            list.add(string);
        }
        return list.toArray(new String[list.size()]);
    }

    private <T> T findInherited(T t, Class<?> clazz, Class<? extends Annotation> clazz2, String string, Default<T> default_) {
        if (!default_.isDefault(t)) {
            return t;
        }
        while (clazz != null && clazz != Object.class) {
            Object object;
            Annotation annotation = clazz.getAnnotation(clazz2);
            if (annotation != null && !default_.isDefault(object = this.invokeMethod(annotation, string))) {
                return (T)object;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private String[] findInheritedStringArray(Class<?> clazz, Class<? extends Annotation> clazz2, String string) {
        if (null == clazz) {
            return new String[0];
        }
        List list = Lists.newArrayList();
        while (clazz != null && clazz != Object.class) {
            Annotation annotation = clazz.getAnnotation(clazz2);
            if (annotation != null) {
                String[] stringArray;
                for (String string2 : stringArray = (String[])this.invokeMethod(annotation, string)) {
                    list.add(string2);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return list.toArray(new String[list.size()]);
    }

    private Object invokeMethod(Annotation annotation, String string) {
        Object object = null;
        try {
            Method method = annotation.getClass().getMethod(string, new Class[0]);
            object = method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    private void ppp(String string) {
        System.out.println("[JDK15TagFactory] " + string);
    }

    static interface Default<T> {
        public boolean isDefault(T var1);
    }
}

