/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.AbstractSimpleScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.QualifierScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.TowerData;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B]\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00128\u0010\n\u001a4\u0012\u0004\u0012\u00020\f\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000bj\u0002`\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\u0006\u0010\u000f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\"\u001a\u00020\u001fH\u0016RC\u0010\n\u001a4\u0012\u0004\u0012\u00020\f\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000bj\u0002`\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/QualifierScopeTowerProcessor;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "Lorg/jetbrains/kotlin/resolve/calls/tower/AbstractSimpleScopeTowerProcessor;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "context", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactory;", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/QualifierReceiver;", "collectCandidates", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "Lkotlin/ParameterName;", "name", "extensionReceiver", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidatesCollector;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactory;Lorg/jetbrains/kotlin/resolve/scopes/receivers/QualifierReceiver;Lkotlin/jvm/functions/Function2;)V", "getCollectCandidates", "()Lkotlin/jvm/functions/Function2;", "getQualifier", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/QualifierReceiver;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "recordLookups", "", "skippedData", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerData;", "Lorg/jetbrains/kotlin/name/Name;", "simpleProcess", "data", "resolution"})
final class QualifierScopeTowerProcessor<C extends Candidate>
extends AbstractSimpleScopeTowerProcessor<C> {
    @NotNull
    private final ImplicitScopeTower scopeTower;
    @NotNull
    private final QualifierReceiver qualifier;
    @NotNull
    private final Function2<ScopeTowerLevel, ReceiverValueWithSmartCastInfo, Collection<CandidateWithBoundDispatchReceiver>> collectCandidates;

    @Override
    @NotNull
    public Collection<C> simpleProcess(@NotNull TowerData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)data, (Object)TowerData.Empty.INSTANCE) ^ true) {
            return CollectionsKt.emptyList();
        }
        List staticMembers = new ArrayList();
        for (CandidateWithBoundDispatchReceiver towerCandidate : (Collection)this.collectCandidates.invoke((Object)new QualifierScopeTowerLevel(this.scopeTower, this.qualifier), null)) {
            if (TowerUtilsKt.getRequiresExtensionReceiver(towerCandidate)) continue;
            staticMembers.add(this.getCandidateFactory().createCandidate(towerCandidate, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null));
        }
        return staticMembers;
    }

    @Override
    public void recordLookups(@NotNull Collection<? extends TowerData> skippedData, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(skippedData, (String)"skippedData");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
    }

    @NotNull
    public final ImplicitScopeTower getScopeTower() {
        return this.scopeTower;
    }

    @NotNull
    public final QualifierReceiver getQualifier() {
        return this.qualifier;
    }

    @NotNull
    public final Function2<ScopeTowerLevel, ReceiverValueWithSmartCastInfo, Collection<CandidateWithBoundDispatchReceiver>> getCollectCandidates() {
        return this.collectCandidates;
    }

    public QualifierScopeTowerProcessor(@NotNull ImplicitScopeTower scopeTower, @NotNull CandidateFactory<? extends C> context, @NotNull QualifierReceiver qualifier, @NotNull Function2<? super ScopeTowerLevel, ? super ReceiverValueWithSmartCastInfo, ? extends Collection<? extends CandidateWithBoundDispatchReceiver>> collectCandidates) {
        Intrinsics.checkParameterIsNotNull((Object)scopeTower, (String)"scopeTower");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)qualifier, (String)"qualifier");
        Intrinsics.checkParameterIsNotNull(collectCandidates, (String)"collectCandidates");
        super(context);
        this.scopeTower = scopeTower;
        this.qualifier = qualifier;
        this.collectCandidates = collectCandidates;
    }
}

