/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.util;

import java.util.Arrays;
import org.jetbrains.kotlin.js.util.TextOutput;

public class TextOutputImpl
implements TextOutput {
    private final boolean compact;
    private int identLevel = 0;
    private char[][] indents = new char[][]{new char[0]};
    private boolean justNewlined;
    private final StringBuilder out;
    private int position = 0;
    private int line = 0;
    private int column = 0;

    public TextOutputImpl() {
        this(false);
    }

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    public TextOutputImpl(boolean compact) {
        this.compact = compact;
        this.out = new StringBuilder();
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void indentIn() {
        ++this.identLevel;
        if (this.identLevel >= this.indents.length) {
            char[] newIndentLevel = new char[this.identLevel * 2];
            Arrays.fill(newIndentLevel, ' ');
            char[][] newIndents = new char[this.indents.length + 1][];
            System.arraycopy(this.indents, 0, newIndents, 0, this.indents.length);
            newIndents[this.identLevel] = newIndentLevel;
            this.indents = newIndents;
        }
    }

    @Override
    public void indentOut() {
        --this.identLevel;
    }

    @Override
    public void newline() {
        this.out.append('\n');
        ++this.position;
        ++this.line;
        this.column = 0;
        this.justNewlined = true;
    }

    @Override
    public void print(double value) {
        this.maybeIndent();
        int oldLength = this.out.length();
        this.out.append(value);
        this.movePosition(this.out.length() - oldLength);
    }

    @Override
    public void print(int value) {
        this.maybeIndent();
        int oldLength = this.out.length();
        this.out.append(value);
        this.movePosition(this.out.length() - oldLength);
    }

    @Override
    public void print(char c) {
        this.maybeIndent();
        this.out.append(c);
        this.movePosition(1);
    }

    private void movePosition(int l) {
        this.position += l;
        this.column += l;
    }

    @Override
    public void print(char[] s) {
        this.maybeIndent();
        this.printAndCount(s);
    }

    @Override
    public void print(CharSequence s) {
        this.maybeIndent();
        this.printAndCount(s);
    }

    @Override
    public void printOpt(char c) {
        if (!this.compact) {
            this.print(c);
        }
    }

    @Override
    public void maybeIndent() {
        if (this.justNewlined && !this.compact) {
            this.printAndCount(this.indents[this.identLevel]);
            this.justNewlined = false;
        }
    }

    private void printAndCount(CharSequence charSequence) {
        this.position += charSequence.length();
        this.column += charSequence.length();
        this.out.append(charSequence);
    }

    private void printAndCount(char[] chars) {
        this.position += chars.length;
        this.column += chars.length;
        this.out.append(chars);
    }
}

