/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsNameValuePairImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;

public class ClsAnnotationParameterListImpl
extends ClsElementImpl
implements PsiAnnotationParameterList {
    private final PsiAnnotation myParent;
    private final ClsNameValuePairImpl[] myAttributes;

    public ClsAnnotationParameterListImpl(@NotNull PsiAnnotation parent2, @NotNull PsiNameValuePair[] psiAttributes) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "<init>"));
        }
        if (psiAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAttributes", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "<init>"));
        }
        this.myParent = parent2;
        this.myAttributes = new ClsNameValuePairImpl[psiAttributes.length];
        for (int i = 0; i < psiAttributes.length; ++i) {
            String name = psiAttributes[i].getName();
            PsiAnnotationMemberValue value = psiAttributes[i].getValue();
            if (value == null) {
                String anno = parent2 instanceof ClsAnnotationImpl ? ((PsiAnnotationStub)((ClsAnnotationImpl)parent2).getStub()).getText() : parent2.getText();
                Logger.getInstance(this.getClass()).error("name=" + name + " anno=[" + anno + "] file=" + parent2.getContainingFile());
                value = new ClsLiteralExpressionImpl(this, "null", PsiType.NULL, null);
            }
            if (psiAttributes.length == 1 && "value".equals(name)) {
                name = null;
            }
            this.myAttributes[i] = new ClsNameValuePairImpl(this, name, value);
        }
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "appendMirrorText"));
        }
        if (this.myAttributes.length != 0) {
            buffer.append("(");
            for (int i = 0; i < this.myAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                this.myAttributes[i].appendMirrorText(indentLevel, buffer);
            }
            buffer.append(")");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, null);
        ClsAnnotationParameterListImpl.setMirrors((PsiElement[])this.myAttributes, (PsiElement[])((PsiAnnotationParameterList)SourceTreeToPsiMap.treeToPsiNotNull(element)).getAttributes());
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (this.myAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "getChildren"));
        }
        return this.myAttributes;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnnotationParameterList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiNameValuePair[] getAttributes() {
        if (this.myAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationParameterListImpl", "getAttributes"));
        }
        return this.myAttributes;
    }
}

