/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.restserver.BeakerXServer;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.Label;
import com.twosigma.beakerx.widget.RESTButton;
import com.twosigma.beakerx.widget.SparkUI;
import com.twosigma.beakerx.widget.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class SparkUIStatus
extends HBox {
    public static final String STOP_SPARK_SESSION = "stopsparksession";

    public SparkUIStatus(SparkUI.OnSparkRestButtonAction onSparkButtonAction) {
        super(new ArrayList());
        KernelFunctionality kernel = KernelManager.get();
        BeakerXServer beakerXServer = kernel.getBeakerXServer();
        beakerXServer.addPostMapping(STOP_SPARK_SESSION, ctx -> onSparkButtonAction.run());
        this.createStatusPanel();
    }

    private void createStatusPanel() {
        Label appStatus = this.createAppStatus();
        this.add((Widget)appStatus);
        Widget disconnect = this.createDisconnectButton();
        this.add(disconnect);
        this.setDomClasses(new ArrayList<String>(Collections.singletonList("bx-status-panel")));
    }

    private Label createAppStatus() {
        Label appStatus = new Label();
        appStatus.setValue((Object)"Connected");
        appStatus.setDomClasses(new ArrayList<String>(Arrays.asList("bx-connection-status", "connected")));
        return appStatus;
    }

    private Widget createDisconnectButton() {
        BeakerXServer beakerXServer = KernelManager.get().getBeakerXServer();
        RESTButton disconnect2 = new RESTButton(beakerXServer.getURL() + STOP_SPARK_SESSION);
        disconnect2.setTooltip("Stop Spark Session");
        disconnect2.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-close")));
        return disconnect2;
    }
}

