/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.win32.IdeaWin32;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.WeakStringInterner;
import org.jetbrains.kotlin.com.intellij.util.lang.CachePoolImpl;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

public class UrlClassLoader
extends ClassLoader {
    private static final Set<Class<?>> ourParallelCapableLoaders;
    private static final boolean ourClassPathIndexEnabled;
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final WeakStringInterner myClassNameInterner;
    private final boolean myAllowBootstrapResources;

    @NotNull
    protected ClassPath getClassPath() {
        ClassPath classPath = this.myClassPath;
        if (classPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader", "getClassPath"));
        }
        return classPath;
    }

    public static Builder build() {
        return new Builder();
    }

    protected UrlClassLoader(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader", "<init>"));
        }
        super(builder.myParent);
        this.myURLs = ContainerUtil.map(builder.myURLs, new Function<URL, URL>(){

            @Override
            public URL fun(URL url) {
                return UrlClassLoader.internProtocol(url);
            }
        });
        this.myClassPath = this.createClassPath(builder);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
        this.myClassNameInterner = ourParallelCapableLoaders != null && ourParallelCapableLoaders.contains(this.getClass()) ? new WeakStringInterner() : null;
    }

    @NotNull
    protected final ClassPath createClassPath(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader", "createClassPath"));
        }
        ClassPath classPath = new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myPreload, builder.myUsePersistentClasspathIndex, builder.myCachePool, builder.myCachingCondition);
        if (classPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader", "createClassPath"));
        }
        return classPath;
    }

    public static URL internProtocol(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader", "internProtocol"));
        }
        try {
            String protocol = url.getProtocol();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                return new URL(protocol.intern(), url.getHost(), url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            Logger.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    public boolean hasLoadedClass(String name) {
        Class<?> aClass2 = this.findLoadedClass(name);
        return aClass2 != null && aClass2.getClassLoader() == this;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Resource res2 = this.getClassPath().getResource(name.replace('.', '/') + ".class", false);
        if (res2 == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            return this.defineClass(name, res2);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Nullable
    protected Class _findClass(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader", "_findClass"));
        }
        Resource res2 = this.getClassPath().getResource(name.replace('.', '/') + ".class", false);
        if (res2 == null) {
            return null;
        }
        try {
            return this.defineClass(name, res2);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class defineClass(String name, Resource res2) throws IOException {
        String pkgName;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, res2.getValue(Resource.Attribute.SPEC_TITLE), res2.getValue(Resource.Attribute.SPEC_VERSION), res2.getValue(Resource.Attribute.SPEC_VENDOR), res2.getValue(Resource.Attribute.IMPL_TITLE), res2.getValue(Resource.Attribute.IMPL_VERSION), res2.getValue(Resource.Attribute.IMPL_VENDOR), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res2.getBytes();
        return this._defineClass(name, b);
    }

    protected Class _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    @Nullable
    public URL findResource(String name) {
        return this.findResourceImpl(name);
    }

    protected URL findResourceImpl(String name) {
        Resource res2 = this._getResource(name);
        return res2 != null ? res2.getURL() : null;
    }

    @Nullable
    private Resource _getResource(String name) {
        String n = FileUtil.toCanonicalUriPath(name);
        Resource resource = this.getClassPath().getResource(n, true);
        if (resource == null && n.startsWith("/")) {
            resource = this.getClassPath().getResource(n.substring(1), true);
        }
        return resource;
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            return super.getResourceAsStream(name);
        }
        try {
            Resource res2 = this._getResource(name);
            if (res2 == null) {
                return null;
            }
            return res2.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getClassPath().getResources(name, true);
    }

    public static void loadPlatformLibrary(@NotNull String libName) {
        String libPath;
        if (libName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libName", "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader", "loadPlatformLibrary"));
        }
        String libFileName = UrlClassLoader.mapLibraryName(libName);
        File libFile = PathManager.findBinFile(libFileName);
        if (libFile != null) {
            libPath = libFile.getAbsolutePath();
        } else {
            libPath = PathManager.getHomePathFor(IdeaWin32.class) + "/bin/" + libFileName;
            if (!new File(libPath).exists()) {
                File libDir = new File(PathManager.getBinPath());
                throw new UnsatisfiedLinkError("'" + libFileName + "' not found in '" + libDir + "' among " + Arrays.toString(libDir.list()));
            }
        }
        System.load(libPath);
    }

    private static String mapLibraryName(String libName) {
        String baseName = libName;
        if (SystemInfo.is64Bit) {
            baseName = baseName.replace("32", "") + "64";
        }
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfo.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        return fileName;
    }

    @Override
    protected Object getClassLoadingLock(String className2) {
        return this.myClassNameInterner != null ? this.myClassNameInterner.intern(new String(className2)) : this;
    }

    static {
        boolean capable;
        boolean bl = capable = SystemInfo.isJavaVersionAtLeast("1.7") && !SystemInfo.isIbmJvm && SystemProperties.getBooleanProperty("use.parallel.class.loading", true);
        if (capable) {
            ourParallelCapableLoaders = Collections.synchronizedSet(new HashSet());
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                if (Boolean.TRUE.equals(registerAsParallelCapable.invoke(null, new Object[0]))) {
                    ourParallelCapableLoaders.add(UrlClassLoader.class);
                }
            }
            catch (Exception exception) {}
        } else {
            ourParallelCapableLoaders = null;
        }
        ourClassPathIndexEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
    }

    public static interface CachingCondition {
        public boolean shouldCacheData(@NotNull URL var1);
    }

    public static final class Builder {
        private List<URL> myURLs = ContainerUtil.emptyList();
        private ClassLoader myParent;
        private boolean myLockJars;
        private boolean myUseCache;
        private boolean myUsePersistentClasspathIndex;
        private boolean myAcceptUnescaped;
        private boolean myPreload = true;
        private boolean myAllowBootstrapResources;
        @Nullable
        private CachePoolImpl myCachePool;
        @Nullable
        private CachingCondition myCachingCondition;

        private Builder() {
        }

        public Builder urls(List<URL> urls) {
            this.myURLs = urls;
            return this;
        }

        public Builder allowLock() {
            this.myLockJars = true;
            return this;
        }

        public Builder useCache() {
            this.myUseCache = true;
            return this;
        }
    }
}

