/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.JobLinkFactory;
import com.twosigma.beakerx.scala.magic.command.SparkUiWebUrlFactory;
import com.twosigma.beakerx.scala.magic.command.StageLinkFactory;
import com.twosigma.beakerx.widget.ErrorPrinter;
import com.twosigma.beakerx.widget.SparkEngine;
import com.twosigma.beakerx.widget.SparkEngineConf;
import com.twosigma.beakerx.widget.SparkUI;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import com.twosigma.beakerx.widget.configuration.SparkConfiguration;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.jetbrains.annotations.NotNull;
import scala.Tuple2;
import scala.collection.Iterator;

abstract class SparkEngineBase
implements SparkEngine {
    protected SparkSession.Builder sparkSessionBuilder;
    private ErrorPrinter errorPrinter;
    protected SparkEngineConf conf = new SparkEngineConf();
    private StageLinkFactory stageLinkFactory;
    private JobLinkFactory jobLinkFactory;
    private SparkUiWebUrlFactory sparkUiWebUrlFactory;

    SparkEngineBase(SparkSession.Builder sparkSessionBuilder, ErrorPrinter errorPrinter) {
        this.sparkSessionBuilder = sparkSessionBuilder;
        this.errorPrinter = errorPrinter;
        this.jobLinkFactory(this.createJobLinkFactory());
        this.stageLinkFactory(this.createStageLinkFactory());
        this.sparkUiWebUrlFactory(this.createSparkUiWebUrl());
    }

    @Override
    public String stageLink(int stageId) {
        return this.stageLinkFactory.create(stageId);
    }

    @Override
    public String jobLink(int jobId) {
        return this.jobLinkFactory.create(jobId);
    }

    @Override
    public void additionalConf(SparkEngineConf conf) {
        this.conf = conf;
    }

    @Override
    public SparkEngineConf getSparkEngineConf() {
        return this.conf;
    }

    @Override
    public void configAutoStart() {
    }

    protected TryResult createSparkSession() {
        try {
            SparkSession sparkSession = this.getOrCreate();
            return TryResult.createResult((Object)sparkSession);
        }
        catch (Exception e) {
            return TryResult.createError((String)this.errorPrinter.print(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TryResult createSparkSession(SparkUIApi sparkUI, Message parentMessage) {
        sparkUI.startSpinner(parentMessage);
        try {
            SparkSession sparkSession = this.getOrCreate();
            TryResult.CellResult cellResult = TryResult.createResult((Object)sparkSession);
            return cellResult;
        }
        catch (Exception e) {
            TryResult.CellError cellError = TryResult.createError((String)this.errorPrinter.print(e));
            return cellError;
        }
        finally {
            sparkUI.stopSpinner();
        }
    }

    @Override
    public SparkSession getOrCreate() {
        return this.sparkSessionBuilder.getOrCreate();
    }

    @Override
    public String getSparkAppId() {
        RuntimeConfig conf = this.getOrCreate().conf();
        return (String)conf.getAll().get((Object)"spark.app.id").get();
    }

    @Override
    public String getSparkUiWebUrl() {
        return this.sparkUiWebUrlFactory.create();
    }

    @Override
    public String getSparkMasterUrl() {
        RuntimeConfig conf = this.getOrCreate().conf();
        return (String)conf.getAll().get((Object)"spark.master").get();
    }

    @Override
    public String sparkVersion() {
        try {
            InputStream sparkProps = Thread.currentThread().getContextClassLoader().getResourceAsStream("spark-version-info.properties");
            Properties props = new Properties();
            props.load(sparkProps);
            return props.getProperty("version");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected TryResult initSparkContextInShell(KernelFunctionality kernel, Message parent) {
        String addSc = String.format("import com.twosigma.beakerx.widget.SparkVariable\nval %s = SparkVariable.getSparkSession()\nval %s = %s.sparkContext\nimport org.apache.spark.SparkContext._\nimport %s.implicits._\nimport %s.sql\nimport org.apache.spark.sql.functions._\n", "spark", "sc", "spark", "spark", "spark");
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject((String)addSc, (KernelFunctionality)kernel, (Message)new Message(new Header(JupyterMessages.COMM_MSG, parent.getHeader().getSession())), (int)1);
        return kernel.executeCode(addSc, seo);
    }

    protected SparkConf createSparkConf(List<SparkConfiguration.Configuration> configurations, SparkConf old) {
        SparkConf sparkConf = new SparkConf();
        sparkConf.set("spark.extraListeners", old.get("spark.extraListeners"));
        sparkConf.set("beakerx.id", old.get("beakerx.id"));
        if (old.contains("spark.app.name")) {
            sparkConf.set("spark.app.name", old.get("spark.app.name"));
        }
        configurations.forEach(x -> {
            if (x.getName() != null) {
                sparkConf.set(x.getName(), x.getValue() != null ? x.getValue() : "");
            }
        });
        return sparkConf;
    }

    @Override
    public SparkConf getSparkConf() {
        return SparkEngineBase.getSparkConfBasedOn(this.sparkSessionBuilder);
    }

    public static SparkConf getSparkConfBasedOn(SparkSession.Builder sparkSessionBuilder) {
        SparkConf sparkConf = new SparkConf();
        Iterator iterator = SparkEngineBase.getConfigIterator(sparkSessionBuilder);
        while (iterator.hasNext()) {
            Tuple2 x = (Tuple2)iterator.next();
            sparkConf.set((String)x._1, (String)x._2);
        }
        return sparkConf;
    }

    protected SparkConf configureSparkConf(SparkConf sparkConf) {
        if (!sparkConf.contains("spark.app.name")) {
            sparkConf.setAppName("beaker_" + UUID.randomUUID().toString());
        }
        if (!SparkEngineBase.isLocalSpark(sparkConf)) {
            sparkConf.set("spark.repl.class.outputDir", KernelManager.get().getOutDir());
        }
        this.conf.getConfigs().forEach((arg_0, arg_1) -> ((SparkConf)sparkConf).set(arg_0, arg_1));
        return sparkConf;
    }

    protected SparkConf configureSparkConf(SparkConf sc, SparkUIApi sparkUI) {
        if (sparkUI.getMasterURL().getValue() != null && !((String)((Object)sparkUI.getMasterURL().getValue())).isEmpty()) {
            sc.set("spark.master", (String)((Object)sparkUI.getMasterURL().getValue()));
        }
        if (sparkUI.getExecutorMemory().getValue() != null && !((String)((Object)sparkUI.getExecutorMemory().getValue())).isEmpty()) {
            sc.set("spark.executor.memory", (String)((Object)sparkUI.getExecutorMemory().getValue()));
        }
        if (sparkUI.getExecutorCores().getValue() != null && !((String)((Object)sparkUI.getExecutorCores().getValue())).isEmpty()) {
            sc.set("spark.executor.cores", (String)((Object)sparkUI.getExecutorCores().getValue()));
        }
        return this.configureSparkConf(sc);
    }

    @Override
    public Map<String, String> getAdvanceSettings(SparkUiDefaults defaults) {
        HashMap<String, String> configs = new HashMap<String, String>();
        Iterator iterator = SparkEngineBase.getConfigIterator(this.sparkSessionBuilder);
        while (iterator.hasNext()) {
            Tuple2 x = (Tuple2)iterator.next();
            if (!this.isAdvancedSettings((String)x._1)) continue;
            configs.put((String)x._1, (String)x._2);
        }
        Map<String, String> props = defaults.getProperties();
        props.forEach((pname, pvalue) -> {
            if (!(pname == null || pname.isEmpty() || configs.containsKey(pname) || pvalue == null || pvalue.isEmpty())) {
                configs.put((String)pname, (String)pvalue);
            }
        });
        return configs;
    }

    private static Iterator getConfigIterator(SparkSession.Builder sparkSessionBuilder) {
        try {
            Field options = sparkSessionBuilder.getClass().getDeclaredField("org$apache$spark$sql$SparkSession$Builder$$options");
            options.setAccessible(true);
            return ((scala.collection.mutable.HashMap)options.get(sparkSessionBuilder)).iterator();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAdvancedSettings(String name) {
        return !SparkUI.STANDARD_SETTINGS.contains(name);
    }

    private static boolean isLocalSpark(SparkConf sparkConf) {
        return sparkConf.contains("spark.master") && sparkConf.get("spark.master") != null && sparkConf.get("spark.master").startsWith("local");
    }

    @Override
    public void jobLinkFactory(JobLinkFactory jobLinkFactory) {
        this.jobLinkFactory = jobLinkFactory;
    }

    @Override
    public void stageLinkFactory(StageLinkFactory stageLinkFactory) {
        this.stageLinkFactory = stageLinkFactory;
    }

    @Override
    public void sparkUiWebUrlFactory(SparkUiWebUrlFactory factory) {
        this.sparkUiWebUrlFactory = factory;
    }

    @NotNull
    private StageLinkFactory createStageLinkFactory() {
        return stageId -> {
            if (this.getOrCreate().sparkContext().uiWebUrl().isDefined()) {
                return (String)this.getOrCreate().sparkContext().uiWebUrl().get() + "/stages/stage/?id=" + stageId + "&attempt=0";
            }
            return "";
        };
    }

    @NotNull
    private JobLinkFactory createJobLinkFactory() {
        return jobId -> {
            if (this.getOrCreate().sparkContext().uiWebUrl().isDefined()) {
                return (String)this.getOrCreate().sparkContext().uiWebUrl().get() + "/jobs/job/?id=" + jobId;
            }
            return "";
        };
    }

    @NotNull
    private SparkUiWebUrlFactory createSparkUiWebUrl() {
        return () -> (String)this.getOrCreate().sparkContext().uiWebUrl().get();
    }
}

