/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.TimeZone;
import java.util.UUID;

public class Utils {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final String EMPTY_STRING = "";
    private static UUIDStrategy UUID_STRATEGY_DEFAULT;
    private static UUIDStrategy commUUIDStrategy;
    private static int fixedUUIDCounter;

    public static String timestamp() {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of(UTC.getID()));
        return df.format(now);
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String commUUID() {
        return commUUIDStrategy.get();
    }

    public static String getUsString(String[] input) {
        StringBuilder ret = new StringBuilder();
        if (input != null && input.length > 0) {
            for (String s : input) {
                ret.append(s + "\n");
            }
        }
        return ret.toString();
    }

    public static String getAsString(Collection<String> input) {
        if (input == null || input.isEmpty()) {
            return EMPTY_STRING;
        }
        return Utils.getUsString(input.toArray(new String[input.size()]));
    }

    public static synchronized void setFixedCommUUID(String uuid) {
        fixedUUIDCounter = 0;
        commUUIDStrategy = () -> uuid + ++fixedUUIDCounter;
    }

    public static synchronized void setDefaultCommUUID() {
        commUUIDStrategy = UUID_STRATEGY_DEFAULT;
    }

    static {
        commUUIDStrategy = UUID_STRATEGY_DEFAULT = () -> UUID.randomUUID().toString();
    }

    static interface UUIDStrategy {
        public String get();
    }
}

