/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.CodeFrame;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.message.Message;
import java.util.Optional;

public class PlainCode
extends CodeFrame {
    private String plainCode;

    public PlainCode(String plainCode) {
        this.plainCode = plainCode;
    }

    public String getPlainCode() {
        return this.plainCode;
    }

    @Override
    public void executeFrame(Code code, KernelFunctionality kernel, Message message, int executionCount) {
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject(this.plainCode, kernel, message, executionCount);
        seo.noResult();
        TryResult either = kernel.executeCode(this.plainCode, seo);
        PlainCode.handleResult(seo, either);
    }

    @Override
    public void executeLastFrame(Code code, KernelFunctionality kernel, Message message, int executionCount) {
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject(this.plainCode, kernel, message, executionCount);
        TryResult either = kernel.executeCode(this.plainCode, seo);
        PlainCode.handleResult(seo, either);
    }

    @Override
    public Optional<MagicCommandOutcomeItem> getError() {
        return Optional.empty();
    }

    public static SimpleEvaluationObject createSimpleEvaluationObject(String code, KernelFunctionality kernel, Message message, int executionCount) {
        SimpleEvaluationObject seo = new SimpleEvaluationObject(code);
        seo.setJupyterMessage(message);
        seo.setExecutionCount(executionCount);
        seo.addObserver(kernel.getExecutionResultSender());
        return seo;
    }
}

