/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.threads;

import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.threads.InputRequestMessageFactory;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.message.Message;
import java.io.InputStream;
import java.util.Iterator;

public class BxInputStream
extends InputStream {
    private KernelFunctionality kernel;
    private InputRequestMessageFactory inputRequestMessageFactory;
    private Iterator<Character> characters;

    public BxInputStream(KernelFunctionality kernel, InputRequestMessageFactory inputRequestMessageFactory) {
        this.kernel = kernel;
        this.inputRequestMessageFactory = inputRequestMessageFactory;
    }

    @Override
    public int read() {
        if (this.characters == null) {
            this.characters = new CharacterIterator(this.input());
        }
        if (this.characters.hasNext()) {
            return this.characters.next().charValue();
        }
        this.characters = null;
        return -1;
    }

    private String input() {
        Message parent = InternalVariable.getParentHeader();
        Message message = this.inputRequestMessageFactory.create(parent);
        return this.kernel.sendStdIn(message) + System.lineSeparator();
    }

    public static class CharacterIterator
    implements Iterator<Character> {
        private final String str;
        private int pos = 0;

        CharacterIterator(String str) {
            this.str = str;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.str.length();
        }

        @Override
        public Character next() {
            return Character.valueOf(this.str.charAt(this.pos++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

