/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.kernel.msg.StacktraceHtmlPrinter;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.BxHTML;
import com.twosigma.beakerx.widget.Checkbox;
import com.twosigma.beakerx.widget.Dropdown;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.HiveSupport;
import com.twosigma.beakerx.widget.SparkEngine;
import com.twosigma.beakerx.widget.SparkUI;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import com.twosigma.beakerx.widget.Spinner;
import com.twosigma.beakerx.widget.Text;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.ValueWidget;
import com.twosigma.beakerx.widget.Widget;
import com.twosigma.beakerx.widget.configuration.SparkConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkConf;

public class SparkUIForm
extends VBox {
    static final String CONNECT = "Start";
    static final String PROFILE_DESC = "Profile";
    private static final String OK_BUTTON_DESC = "Create";
    private static final String CANCEL_BUTTON_DESC = "Cancel";
    private static final String PROFILE_NAME_PLC_HOLD = "Enter profile name...";
    private static final String NEW_PROFILE_DESC = "New profile";
    private static final String SAVE_PROFILE_TOOLTIP = "Save profile";
    private static final String NEW_PROFILE_TOOLTIP = "Create new profile";
    private static final String REMOVE_PROFILE_TOOLTIP = "Delete this profile";
    private HBox errors;
    private HBox profileManagement;
    private Dropdown profile;
    private Text newProfileName;
    private Text masterURL;
    private Text executorMemory;
    private Text executorCores;
    private HiveSupport hiveSupport;
    private SparkConfiguration advancedOption;
    private SparkEngine sparkEngine;
    private SparkUI.OnSparkButtonAction onStartAction;
    private Button connectButton;
    private Button removeButton;
    private Spinner spinner;
    private HBox spinnerPanel;
    private SparkUiDefaults sparkUiDefaults;
    private HBox profileModal;

    public SparkUIForm(SparkEngine sparkEngine, SparkUiDefaults sparkUiDefaults, SparkUI.OnSparkButtonAction onStartAction) {
        super(new ArrayList());
        this.sparkEngine = sparkEngine;
        this.onStartAction = onStartAction;
        this.sparkUiDefaults = sparkUiDefaults;
        this.createSparkView();
    }

    private void createSparkView() {
        try {
            this.profileModal = this.createProfileModal();
            this.profileManagement = this.createProfileManagement();
            this.masterURL = this.createMasterURL();
            this.executorMemory = this.createExecutorMemory();
            this.executorCores = this.createExecutorCores();
            this.hiveSupport = this.createHiveSupport();
            this.errors = new HBox(new ArrayList());
            this.errors.setDomClasses(Arrays.asList("bx-spark-connect-error"));
            this.addConnectButton(this.createConnectButton(), this.errors);
            this.add((Widget)this.profileModal);
            this.add((Widget)this.profileManagement);
            this.add((Widget)this.masterURL);
            this.add((Widget)this.executorCores);
            this.add((Widget)this.executorMemory);
            this.add((Widget)this.hiveSupport);
            this.advancedOption = new SparkConfiguration(this.sparkEngine.getAdvanceSettings(), this.sparkEngine.sparkVersion(), this.hiveSupport);
            this.add((Widget)this.advancedOption);
        }
        catch (Exception ex) {
            this.sendError(StacktraceHtmlPrinter.printRedBold((String)ex.getMessage()));
        }
    }

    private HiveSupport createHiveSupport() {
        HiveSupport hiveSupport = new HiveSupport("Enable Hive Support");
        hiveSupport.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-hive-support")));
        return hiveSupport;
    }

    private HBox createProfileModal() {
        this.newProfileName = new Text();
        this.newProfileName.setPlaceholder(PROFILE_NAME_PLC_HOLD);
        this.newProfileName.setDescription((Object)NEW_PROFILE_DESC);
        this.newProfileName.setDomClasses(Arrays.asList("bx-spark-config"));
        Button okButton = new Button();
        okButton.setDescription((Object)OK_BUTTON_DESC);
        okButton.registerOnClick(this::createProfileOK);
        okButton.setDomClasses(Arrays.asList("bx-button", "bx-spark-save-button"));
        okButton.setTooltip(NEW_PROFILE_TOOLTIP);
        Button cancelButton = new Button();
        cancelButton.setDescription((Object)CANCEL_BUTTON_DESC);
        cancelButton.registerOnClick(this::createProfileCancel);
        cancelButton.setDomClasses(Arrays.asList("bx-button", "bx-spark-save-button"));
        HBox modal = new HBox(Arrays.asList(this.newProfileName, okButton, cancelButton));
        modal.setDomClasses(Arrays.asList("hidden"));
        return modal;
    }

    private HBox createProfileManagement() {
        Dropdown profileDropdown = new Dropdown();
        profileDropdown.setOptions(this.sparkUiDefaults.getProfileNames());
        profileDropdown.setValue((Object)this.sparkUiDefaults.getCurrentProfileName());
        profileDropdown.setDescription((Object)PROFILE_DESC);
        profileDropdown.register(this::loadProfile);
        profileDropdown.setDomClasses(Arrays.asList("bx-spark-config", "bx-spark-profile"));
        this.profile = profileDropdown;
        Button saveButton = new Button();
        saveButton.setDescription((Object)"Save");
        saveButton.registerOnClick((content, message) -> this.saveProfile());
        saveButton.setDomClasses(Arrays.asList("bx-button", "bx-spark-save-button"));
        saveButton.setTooltip(SAVE_PROFILE_TOOLTIP);
        Button newButton = new Button();
        newButton.registerOnClick((content, message) -> this.newProfile());
        newButton.setDomClasses(Arrays.asList("bx-button", "icon-add"));
        newButton.setTooltip(NEW_PROFILE_TOOLTIP);
        this.removeButton = new Button();
        this.removeButton.registerOnClick((content, message) -> this.removeProfile());
        this.removeButton.setDomClasses(Arrays.asList("bx-button", "icon-close"));
        this.removeButton.setTooltip(REMOVE_PROFILE_TOOLTIP);
        this.refreshElementsAvailability();
        return new HBox(Arrays.asList(profileDropdown, saveButton, newButton, this.removeButton));
    }

    private void loadProfile() {
        String profileName = this.profile.getValue();
        if (!this.sparkUiDefaults.getProfileNames().contains(profileName)) {
            return;
        }
        this.sparkUiDefaults.loadProfiles();
        Map<String, Object> profileData = this.sparkUiDefaults.getProfileByName(profileName);
        if (profileData.size() > 0) {
            this.masterURL.setValue(profileData.getOrDefault("spark.master", "local[*]"));
            this.executorCores.setValue(profileData.getOrDefault("spark.executor.cores", "10"));
            this.executorMemory.setValue(profileData.getOrDefault("spark.executor.memory", "8g"));
            HashMap<String, String> advancedSettings = new HashMap<String, String>();
            ((ArrayList)((Object)profileData.getOrDefault("properties", SparkUI.SPARK_ADVANCED_OPTIONS_DEFAULT))).stream().forEach(x -> advancedSettings.put(x.get("name").toString(), x.get("value").toString()));
            this.advancedOption.setConfiguration(advancedSettings);
        }
        this.refreshElementsAvailability();
    }

    private void saveProfile() {
        try {
            this.clearErrors();
            HashMap<String, Object> sparkProfile = this.getCurrentConfig();
            sparkProfile.put("name", this.profile.getValue());
            this.sparkUiDefaults.saveProfile(sparkProfile);
            this.profile.setOptions(this.sparkUiDefaults.getProfileNames());
            this.profile.setValue(sparkProfile.get("name"));
        }
        catch (Exception ex) {
            this.sendError(StacktraceHtmlPrinter.printRedBold((String)ex.getMessage()));
        }
    }

    private void newProfile() {
        this.profileManagement.setDomClasses(Arrays.asList("hidden"));
        this.profileModal.setDomClasses(new ArrayList(0));
    }

    private void createProfileOK(HashMap hashMap, Message message) {
        this.profileModal.setDomClasses(Arrays.asList("hidden"));
        this.profileManagement.setDomClasses(new ArrayList(0));
        this.profile.setValue((Object)this.newProfileName.getValue());
        this.saveProfile();
        this.newProfileName.setValue((Object)"");
        this.refreshElementsAvailability();
    }

    private void createProfileCancel(HashMap hashMap, Message message) {
        this.profileModal.setDomClasses(Arrays.asList("hidden"));
        this.profileManagement.setDomClasses(new ArrayList(0));
    }

    private HashMap<String, Object> getCurrentConfig() {
        HashMap<String, Object> sparkConfig = new HashMap<String, Object>();
        sparkConfig.put("spark.master", this.getMasterURL().getValue());
        sparkConfig.put("spark.executor.cores", this.getExecutorCores().getValue());
        sparkConfig.put("spark.executor.memory", this.getExecutorMemory().getValue());
        sparkConfig.put("properties", this.getAdvancedOptions());
        return sparkConfig;
    }

    public void saveDefaults() {
        HashMap<String, Object> sparkProfile = this.getCurrentConfig();
        sparkProfile.put("name", "");
        this.sparkUiDefaults.saveProfile(sparkProfile);
    }

    private void removeProfile() {
        if (this.profile.getValue().equals("")) {
            return;
        }
        this.sparkUiDefaults.removeSparkConf(this.profile.getValue());
        this.profile.setOptions(this.sparkUiDefaults.getProfileNames());
        this.profile.setValue((Object)"");
        this.loadProfile();
    }

    private void addConnectButton(Button connect, HBox errors) {
        this.connectButton = connect;
        this.spinnerPanel = new HBox();
        this.add((Widget)new HBox(Arrays.asList(this.connectButton, this.spinnerPanel, errors)));
    }

    public void startSpinner(Message parentMessage) {
        this.spinner = new Spinner(parentMessage, "Connecting to " + (String)((Object)this.masterURL.getValue()));
        this.spinnerPanel.add((Widget)this.spinner, parentMessage);
    }

    public void stopSpinner() {
        this.spinnerPanel.remove((Widget)this.spinner);
    }

    private SparkConf getSparkConf() {
        return this.sparkEngine.getSparkConf();
    }

    private Text createMasterURL() {
        Text masterURL = new Text();
        masterURL.setDescription((Object)"Master URL");
        masterURL.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-config", "bx-spark-master-url")));
        if (this.getSparkConf().contains("spark.master")) {
            masterURL.setValue((Object)this.getSparkConf().get("spark.master"));
        } else {
            masterURL.setValue((Object)"local[*]");
        }
        return masterURL;
    }

    private Button createConnectButton() {
        Button connect = new Button();
        connect.setDescription((Object)CONNECT);
        connect.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-connect")));
        connect.registerOnClick((content, message) -> this.onStartAction.run(message));
        return connect;
    }

    private Text createExecutorMemory() {
        Text memory = new Text();
        memory.setDescription((Object)"Executor Memory");
        memory.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-config", "bx-spark-executor-memory")));
        if (this.getSparkConf().contains("spark.executor.memory")) {
            memory.setValue((Object)this.getSparkConf().get("spark.executor.memory"));
        } else {
            memory.setValue((Object)"8g");
        }
        return memory;
    }

    private Text createExecutorCores() {
        Text cores = new Text();
        cores.setDescription((Object)"Executor Cores");
        cores.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-config", "bx-spark-executor-cores")));
        if (this.getSparkConf().contains("spark.executor.cores")) {
            cores.setValue((Object)this.getSparkConf().get("spark.executor.cores"));
        } else {
            cores.setValue((Object)"10");
        }
        return cores;
    }

    public Text getMasterURL() {
        return this.masterURL;
    }

    public Checkbox getHiveSupport() {
        return this.hiveSupport;
    }

    public Text getExecutorMemory() {
        return this.executorMemory;
    }

    public Text getExecutorCores() {
        return this.executorCores;
    }

    public List<SparkConfiguration.Configuration> getAdvancedOptions() {
        return this.advancedOption.getConfiguration();
    }

    public void sendError(String message) {
        this.clearErrors();
        BxHTML label = new BxHTML();
        label.setValue((Object)message);
        this.errors.add((Widget)label);
    }

    public void clearErrors() {
        this.errors.removeAllChildren();
    }

    public Button getConnectButton() {
        return this.connectButton;
    }

    public String getProfileName() {
        return this.profile.getValue();
    }

    public void setAllToDisabled() {
        this.profileManagement.getChildren().stream().map(x -> (ValueWidget)x).forEach(x -> x.setDisabled((Object)true));
        this.advancedOption.setDisabledToAll();
        this.connectButton.setDisabled((Object)true);
        this.masterURL.setDisabled((Object)true);
        this.executorMemory.setDisabled((Object)true);
        this.executorCores.setDisabled((Object)true);
        this.hiveSupport.setDisabled(true);
    }

    public void setAllToEnabled() {
        this.profileManagement.getChildren().stream().map(x -> (ValueWidget)x).forEach(x -> x.setDisabled((Object)false));
        this.advancedOption.setEnabledToAll();
        this.connectButton.setDisabled((Object)false);
        this.connectButton.setDomClasses(new ArrayList<String>(Arrays.asList("bx-spark-connect")));
        this.masterURL.setDisabled((Object)false);
        this.executorMemory.setDisabled((Object)false);
        this.executorCores.setDisabled((Object)false);
        this.hiveSupport.setDisabled(false);
        this.refreshElementsAvailability();
    }

    public void refreshElementsAvailability() {
        this.removeButton.setDisabled((Object)this.profile.getValue().equals(""));
    }
}

