/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.PlainCode;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.ErrorPrinter;
import com.twosigma.beakerx.widget.SparkEngine;
import com.twosigma.beakerx.widget.SparkUI;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.configuration.SparkConfiguration;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;
import scala.collection.mutable.HashMap;

abstract class SparkEngineBase
implements SparkEngine {
    protected SparkSession.Builder sparkSessionBuilder;
    private ErrorPrinter errorPrinter;

    SparkEngineBase(SparkSession.Builder sparkSessionBuilder, ErrorPrinter errorPrinter) {
        this.sparkSessionBuilder = sparkSessionBuilder;
        this.errorPrinter = errorPrinter;
    }

    protected TryResult createSparkSession() {
        try {
            SparkSession sparkSession = this.getOrCreate();
            return TryResult.createResult((Object)sparkSession);
        }
        catch (Exception e) {
            return TryResult.createError((String)this.errorPrinter.print(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TryResult createSparkSession(SparkUIApi sparkUI, Message parentMessage) {
        sparkUI.startSpinner(parentMessage);
        try {
            SparkSession sparkSession = this.getOrCreate();
            TryResult.CellResult cellResult = TryResult.createResult((Object)sparkSession);
            return cellResult;
        }
        catch (Exception e) {
            TryResult.CellError cellError = TryResult.createError((String)this.errorPrinter.print(e));
            return cellError;
        }
        finally {
            sparkUI.stopSpinner();
        }
    }

    @Override
    public SparkSession getOrCreate() {
        return this.sparkSessionBuilder.getOrCreate();
    }

    @Override
    public String getSparkAppId() {
        RuntimeConfig conf = this.getOrCreate().conf();
        return (String)conf.getAll().get((Object)"spark.app.id").get();
    }

    @Override
    public String getSparkUiWebUrl() {
        return (String)this.getOrCreate().sparkContext().uiWebUrl().get();
    }

    @Override
    public String getSparkMasterUrl() {
        RuntimeConfig conf = this.getOrCreate().conf();
        return (String)conf.getAll().get((Object)"spark.master").get();
    }

    @Override
    public String sparkVersion() {
        try {
            InputStream sparkProps = Thread.currentThread().getContextClassLoader().getResourceAsStream("spark-version-info.properties");
            Properties props = new Properties();
            props.load(sparkProps);
            return props.getProperty("version");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected TryResult initSparkContextInShell(KernelFunctionality kernel, Message parent) {
        String addSc = String.format("import com.twosigma.beakerx.widget.SparkVariable\nval %s = SparkVariable.getSparkSession()\nval %s = %s.sparkContext\nimport org.apache.spark.SparkContext._\nimport %s.implicits._\nimport %s.sql\nimport org.apache.spark.sql.functions._\n", "spark", "sc", "spark", "spark", "spark");
        SimpleEvaluationObject seo = PlainCode.createSimpleEvaluationObject((String)addSc, (KernelFunctionality)kernel, (Message)new Message(new Header(JupyterMessages.COMM_MSG, parent.getHeader().getSession())), (int)1);
        return kernel.executeCode(addSc, seo);
    }

    protected SparkConf createSparkConf(List<SparkConfiguration.Configuration> configurations, SparkConf old) {
        SparkConf sparkConf = new SparkConf();
        sparkConf.set("spark.extraListeners", old.get("spark.extraListeners"));
        sparkConf.set("beakerx.id", old.get("beakerx.id"));
        if (old.contains("spark.app.name")) {
            sparkConf.set("spark.app.name", old.get("spark.app.name"));
        }
        configurations.forEach(x -> {
            if (x.getName() != null) {
                sparkConf.set(x.getName(), x.getValue() != null ? x.getValue() : "");
            }
        });
        return sparkConf;
    }

    @Override
    public SparkConf getSparkConf() {
        return SparkEngineBase.getSparkConfBasedOn(this.sparkSessionBuilder);
    }

    public static SparkConf getSparkConfBasedOn(SparkSession.Builder sparkSessionBuilder) {
        try {
            SparkConf sparkConf = new SparkConf();
            Field options = sparkSessionBuilder.getClass().getDeclaredField("org$apache$spark$sql$SparkSession$Builder$$options");
            options.setAccessible(true);
            for (Tuple2 x : (HashMap)options.get(sparkSessionBuilder)) {
                sparkConf.set((String)x._1, (String)x._2);
            }
            return sparkConf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected SparkConf configureSparkConf(SparkConf sparkConf) {
        if (!sparkConf.contains("spark.app.name")) {
            sparkConf.setAppName("beaker_" + UUID.randomUUID().toString());
        }
        if (!SparkEngineBase.isLocalSpark(sparkConf)) {
            sparkConf.set("spark.repl.class.outputDir", KernelManager.get().getOutDir());
        }
        return sparkConf;
    }

    protected SparkConf configureSparkConf(SparkConf sc, SparkUIApi sparkUI) {
        if (sparkUI.getMasterURL().getValue() != null && !((String)((Object)sparkUI.getMasterURL().getValue())).isEmpty()) {
            sc.set("spark.master", (String)((Object)sparkUI.getMasterURL().getValue()));
        }
        if (sparkUI.getExecutorMemory().getValue() != null && !((String)((Object)sparkUI.getExecutorMemory().getValue())).isEmpty()) {
            sc.set("spark.executor.memory", (String)((Object)sparkUI.getExecutorMemory().getValue()));
        }
        if (sparkUI.getExecutorCores().getValue() != null && !((String)((Object)sparkUI.getExecutorCores().getValue())).isEmpty()) {
            sc.set("spark.executor.cores", (String)((Object)sparkUI.getExecutorCores().getValue()));
        }
        return this.configureSparkConf(sc);
    }

    @Override
    public Map<String, String> getAdvanceSettings() {
        return Arrays.stream(this.getSparkConf().getAll()).filter(x -> this.isAdvancedSettings((String)x._1)).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
    }

    private boolean isAdvancedSettings(String name) {
        return !SparkUI.STANDARD_SETTINGS.contains(name);
    }

    private static boolean isLocalSpark(SparkConf sparkConf) {
        return sparkConf.contains("spark.master") && sparkConf.get("spark.master") != null && sparkConf.get("spark.master").startsWith("local");
    }
}

